/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.expressionbuilderformatter;

import java.text.MessageFormat;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.oracle.dal.OracleSQLBuilder;

public class OracleConstant
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;
    private final OracleSQLBuilder builder;
    private final GeometryExpressionBuilder expbuilder;

    public OracleConstant(SQLBuilder builder, Formatter<ExpressionBuilder.Value> formatter) {
        this.builder = (OracleSQLBuilder)builder;
        this.formatter = formatter;
        this.expbuilder = builder.expression();
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        return value instanceof ExpressionBuilder.Constant;
    }

    public String format(ExpressionBuilder.Value function) {
        Object value = ((ExpressionBuilder.Constant)function).value();
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return "(1=1)";
            }
            return "(1<>1)";
        }
        if (value instanceof Geometry) {
            Geometry geom = (Geometry)value;
            try {
                switch (this.builder.geometry_support_type()) {
                    case EWKB: {
                        return MessageFormat.format("SDO_GEOMETRY(({0}), ({1}))", this.builder.blob(geom.convertToEWKB()), String.valueOf(this.expbuilder.srs_id(geom.getProjection())));
                    }
                    case WKB: {
                        return MessageFormat.format("SDO_GEOMETRY(({0}), ({1}))", this.builder.blob(geom.convertToWKB()), String.valueOf(this.expbuilder.srs_id(geom.getProjection())));
                    }
                }
                return MessageFormat.format("SDO_GEOMETRY(({0}), ({1}))", geom.convertToWKT(), String.valueOf(this.expbuilder.srs_id(geom.getProjection())));
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't convert geometry to string.", ex);
            }
        }
        return function.toString(null);
    }
}

