/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.expressionbuilderformatter;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.fmap.dal.SQLBuilder;

public class Select
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;
    private final SQLBuilder builder;
    private static final int COLUMNS = 0;
    private static final int TABLE = 1;
    private static final int WHERE = 2;
    private static final int ORDER = 3;
    private static final int ORDER_MODE = 4;
    private static final int LIMIT = 5;

    public Select(SQLBuilder builder, Formatter<ExpressionBuilder.Value> formatter) {
        this.builder = builder;
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.Function) {
            return StringUtils.equalsIgnoreCase((CharSequence)"SELECT", (CharSequence)((ExpressionBuilder.Function)value).name());
        }
        return false;
    }

    private StringBuilder appendMainClause(StringBuilder builder, ExpressionBuilder.Function function) {
        String tableName = ((ExpressionBuilder.Value)function.parameters().get(1)).toString(this.formatter);
        ExpressionBuilder.Value where = (ExpressionBuilder.Value)function.parameters().get(2);
        builder.append("SELECT ");
        try {
            ExpressionBuilder.Function columns = (ExpressionBuilder.Function)function.parameters().get(0);
            if (!StringUtils.equalsIgnoreCase((CharSequence)columns.name(), (CharSequence)"TUPLE")) {
                throw new IllegalArgumentException();
            }
            if (columns.parameters().isEmpty()) {
                builder.append("* ");
            } else {
                boolean needcomma = false;
                for (ExpressionBuilder.Value parameter : columns.parameters()) {
                    if (needcomma) {
                        builder.append(", ");
                    } else {
                        needcomma = true;
                    }
                    builder.append(parameter.toString(this.formatter));
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid columns, need a tuple function as columns.");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        if (where != null) {
            builder.append(" WHERE ");
            builder.append(where.toString(this.formatter));
        }
        return builder;
    }

    public String format(ExpressionBuilder.Value function0) {
        ExpressionBuilder.Function function = (ExpressionBuilder.Function)function0;
        String tableName = ((ExpressionBuilder.Value)function.parameters().get(1)).toString(this.formatter);
        ExpressionBuilder.Value limit = (ExpressionBuilder.Value)function.parameters().get(5);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("(");
        if (limit != null) {
            strBuilder.append("SELECT * FROM ( ");
            this.appendMainClause(strBuilder, function);
            strBuilder.append(") a");
            strBuilder.append(" WHERE ROWNUM <= ");
            strBuilder.append(limit);
        } else {
            this.appendMainClause(strBuilder, function);
        }
        strBuilder.append(")");
        return strBuilder.toString();
    }
}

