/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.operations;

import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CalculateEnvelopeOfColumnOperation;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.oracle.dal.SpatialIndexUtils;

public class OracleCalculateEnvelopeOfColumnOperation
extends CalculateEnvelopeOfColumnOperation {
    public OracleCalculateEnvelopeOfColumnOperation(JDBCHelper helper, FeatureType featureType, OperationsFactory.TableReference table, String columnName, String baseFilter, Envelope limit, IProjection crs) {
        super(helper, featureType, table, columnName, baseFilter, limit, crs);
    }

    public String getSQLWithAggregate() {
        if (StringUtils.isEmpty((CharSequence)this.baseFilter) && this.limit == null) {
            boolean validIndex = false;
            String indexName = SpatialIndexUtils.getSpatialIndex(this.conn, this.table.getSchema(), this.table.getTable(), this.columnName);
            if (!StringUtils.isBlank((CharSequence)indexName)) {
                validIndex = SpatialIndexUtils.isValidSpatialIndex(this.conn, this.table.getTable());
            }
            if (validIndex) {
                StringBuilder builder = new StringBuilder();
                builder.append("SELECT SDO_TUNE.EXTENT_OF('");
                builder.append(this.table.getTable());
                builder.append("', '");
                builder.append(this.columnName);
                builder.append("').GET_WKB() FROM DUAL");
                return builder.toString();
            }
        }
        return super.getSQLWithAggregate();
    }
}

