/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.operations;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.oracle.dal.GeometryTypeUtils;
import org.gvsig.oracle.dal.OracleSQLBuilder;

public class OracleFetchFeatureTypeOperation
extends FetchFeatureTypeOperation {
    private static final int ORACLE_COLUMN_BINARY_FLOAT_TYPECODE = 100;
    private static final int ORACLE_COLUMN_BINARY_DOUBLE_TYPECODE = 101;
    public static final String ORACLE_SRID_ATTR_TAG = "oracle_srid";
    protected Set<String> tableTriggers;

    public OracleFetchFeatureTypeOperation(JDBCHelper helper) {
        super(helper);
    }

    public OracleFetchFeatureTypeOperation(JDBCHelper helper, EditableFeatureType featureType, OperationsFactory.TableReference table, List<String> primaryKeys, String defaultGeometryColumn, IProjection crs, int geometryType, int geometrySubtype) {
        super(helper, featureType, table, primaryKeys, defaultGeometryColumn, crs, geometryType, geometrySubtype);
    }

    public void fetch(JDBCConnection conn) throws DataException {
        super.fetch(conn);
    }

    public String getSQLToRetrievePrimaryKeysFromInformationSchema() throws SQLException {
        OracleSQLBuilder sqlbuilder = (OracleSQLBuilder)this.createSQLBuilder();
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        sqlbuilder.select().column().name(sqlbuilder.quote_for_identifiers() + "USER_TAB_COLS" + sqlbuilder.quote_for_identifiers() + "." + sqlbuilder.quote_for_identifiers() + "COLUMN_NAME" + sqlbuilder.quote_for_identifiers());
        sqlbuilder.select().column().name(sqlbuilder.quote_for_identifiers() + "ALL_CONSTRAINTS" + sqlbuilder.quote_for_identifiers() + "." + sqlbuilder.quote_for_identifiers() + "CONSTRAINT_TYPE" + sqlbuilder.quote_for_identifiers());
        sqlbuilder.select().from().custom("USER_TAB_COLS JOIN ALL_CONS_COLUMNS on (ALL_CONS_COLUMNS.TABLE_NAME = USER_TAB_COLS.TABLE_NAME and ALL_CONS_COLUMNS.COLUMN_NAME = USER_TAB_COLS.COLUMN_NAME) LEFT JOIN ALL_CONSTRAINTS on ALL_CONSTRAINTS.CONSTRAINT_NAME = ALL_CONS_COLUMNS.CONSTRAINT_NAME");
        sqlbuilder.select().where().set((ExpressionBuilder.Value)expbuilder.like((ExpressionBuilder.Value)expbuilder.custom((Object)(sqlbuilder.quote_for_identifiers() + "USER_TAB_COLS" + sqlbuilder.quote_for_identifiers() + "." + sqlbuilder.quote_for_identifiers() + "TABLE_NAME" + sqlbuilder.quote_for_identifiers())), (ExpressionBuilder.Value)expbuilder.constant((Object)sqlbuilder.getProviderTableName(this.table))));
        sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.custom((Object)(sqlbuilder.quote_for_identifiers() + "ALL_CONSTRAINTS" + sqlbuilder.quote_for_identifiers() + "." + sqlbuilder.quote_for_identifiers() + "CONSTRAINT_TYPE" + sqlbuilder.quote_for_identifiers())), (ExpressionBuilder.Value)expbuilder.constant((Object)"'P'")));
        return sqlbuilder.select().toString();
    }

    protected int getDataTypeFromMetadata(ResultSetMetaData rsMetadata, int colIndex) throws SQLException {
        int type = rsMetadata.getColumnType(colIndex);
        switch (type) {
            case 4: {
                return 4;
            }
            case -5: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 8: 
            case 101: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                return 8;
            }
            case 6: 
            case 100: {
                return 6;
            }
            case 2: 
            case 3: {
                if (rsMetadata.getScale(colIndex) == 0) {
                    if (rsMetadata.getPrecision(colIndex) == 18) {
                        return 5;
                    }
                    if (rsMetadata.getPrecision(colIndex) == 9) {
                        return 4;
                    }
                }
                return 19;
            }
            case 91: {
                return 9;
            }
            case 92: {
                return 10;
            }
            case 93: {
                return 11;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -4: 
            case -2: 
            case 2004: {
                return 12;
            }
        }
        String typeName = rsMetadata.getColumnTypeName(colIndex);
        if ("MDSYS.SDO_GEOMETRY".equalsIgnoreCase(typeName)) {
            return 66;
        }
        return 64;
    }

    protected void fetchGeometryTypeAndSRS(EditableFeatureAttributeDescriptor attr, ResultSetMetaData rsMetadata, int colIndex) {
        if (attr.getType() != 66) {
            return;
        }
        this.doFetchFromMetadataView(attr, rsMetadata, colIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFetchFromMetadataView(EditableFeatureAttributeDescriptor attr, ResultSetMetaData rsMetadata, int colIndex) {
        GeometryType gt;
        int dimensions;
        block27: {
            int srid = -1;
            dimensions = 2;
            try {
                IProjection proj;
                PreparedStatement st;
                ResultSet rs;
                String sql;
                block26: {
                    sql = "SELECT SRID, ( SELECT count(*) FROM TABLE(t1.diminfo) ) dimensions FROM ALL_SDO_GEOM_METADATA t1 WHERE OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?";
                    rs = null;
                    st = null;
                    try {
                        st = this.getConnection().prepareStatement(sql);
                        st.setString(1, this.getTable().getSchema());
                        st.setString(2, this.getTable().getTable().toUpperCase());
                        st.setString(3, attr.getName().toUpperCase());
                        rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sql);
                        if (rs.next()) {
                            srid = rs.getInt(1);
                            dimensions = rs.getInt(2);
                        }
                        if (srid != -1) {
                            proj = this.helper.getSRSSolver().getProjection(this.conn, (Object)srid);
                            attr.setSRS(proj);
                            if (this.helper.getSRSSolver().hasDatabaseCode(this.conn, (Object)srid)) {
                                attr.getTags().set(ORACLE_SRID_ATTR_TAG, (Object)srid);
                            }
                        }
                        JDBCUtils.closeQuietly((ResultSet)rs);
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Can't get srs for column '" + attr.getName() + "'.", (Throwable)ex);
                        break block26;
                    }
                    finally {
                        JDBCUtils.closeQuietly(rs);
                        JDBCUtils.closeQuietly((Statement)st);
                    }
                    JDBCUtils.closeQuietly((Statement)st);
                }
                if (srid != -1) break block27;
                sql = "SELECT SRID, ( SELECT count(*) FROM TABLE(t1.diminfo) ) dimensions FROM USER_SDO_GEOM_METADATA t1 WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
                rs = null;
                st = null;
                try {
                    st = this.getConnection().prepareStatement(sql);
                    st.setString(1, this.getTable().getTable().toUpperCase());
                    st.setString(2, attr.getName().toUpperCase());
                    rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sql);
                    if (rs.next()) {
                        srid = rs.getInt(1);
                        dimensions = rs.getInt(2);
                    }
                    if (srid != -1) {
                        proj = this.helper.getSRSSolver().getProjection(this.conn, (Object)srid);
                        attr.setSRS(proj);
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't get srs for column '" + attr.getName() + "'.", (Throwable)ex);
                }
                finally {
                    JDBCUtils.closeQuietly((ResultSet)rs);
                    JDBCUtils.closeQuietly((Statement)st);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Can't get geometry type and srs from column '" + attr.getName() + "'.", (Throwable)ex);
            }
        }
        String oracleGeomType = this.doFetchFromSpatialIndex(attr.getName());
        if (oracleGeomType != null) {
            gt = GeometryTypeUtils.getGeometryTypeFromOracleName(oracleGeomType, dimensions);
            if (gt.getType() == 0) {
                gt = this.doFetchFromOgisGeometryTable(attr);
            }
        } else {
            gt = this.doFetchFromOgisGeometryTable(attr);
        }
        if (gt == null) {
            switch (dimensions) {
                case 4: {
                    gt = GeometryTypeUtils.getGeometryTypeFromDatabaseTypeName("ZM");
                    break;
                }
                case 3: {
                    gt = GeometryTypeUtils.getGeometryTypeFromDatabaseTypeName(null);
                    break;
                }
                case 2: {
                    gt = GeometryTypeUtils.getGeometryTypeFromDatabaseTypeName("");
                    break;
                }
                default: {
                    gt = GeometryTypeUtils.getGeometryTypeFromDatabaseTypeName(null);
                }
            }
        }
        attr.setGeometryType(gt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected GeometryType doFetchFromOgisGeometryTable(EditableFeatureAttributeDescriptor attr) {
        PreparedStatement st;
        ResultSet rs;
        block7: {
            GeometryType geometryType;
            block6: {
                String sql = "SELECT GEOMETRY_TYPE FROM MDSYS.OGIS_GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = ? AND F_TABLE_NAME = ? AND F_GEOMETRY_COLUMN = ?";
                rs = null;
                st = null;
                try {
                    st = this.getConnection().prepareStatement(sql);
                    st.setString(1, this.getTable().getSchema());
                    st.setString(2, this.getTable().getTable());
                    st.setString(3, attr.getName());
                    rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sql);
                    if (rs.next()) {
                        int geomType = rs.getInt(1);
                        geometryType = GeometryTypeUtils.getGeometryTypeFromSFSTypeCode(geomType);
                        JDBCUtils.closeQuietly((ResultSet)rs);
                        break block6;
                    }
                    JDBCUtils.closeQuietly((ResultSet)rs);
                    break block7;
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't get geometry type from MDSYS.OGIS_GEOMETRY_COLUMNS '" + attr.getName() + "'.", (Throwable)ex);
                    return null;
                }
            }
            JDBCUtils.closeQuietly((Statement)st);
            return geometryType;
        }
        JDBCUtils.closeQuietly((Statement)st);
        return null;
        finally {
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly((Statement)st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doFetchFromSpatialIndex(String geomColumnName) {
        try {
            PreparedStatement st;
            ResultSet rs;
            block4: {
                String string;
                String sql = "SELECT SDO_LAYER_GTYPE FROM ALL_SDO_INDEX_METADATA tmd, ALL_SDO_INDEX_INFO tinfo WHERE tmd.SDO_INDEX_OWNER = tinfo.SDO_INDEX_OWNER AND tmd.SDO_INDEX_NAME = tinfo.INDEX_NAME AND TABLE_OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?";
                rs = null;
                st = null;
                try {
                    String geomType;
                    st = this.getConnection().prepareStatement(sql);
                    st.setString(1, this.getTable().getSchema());
                    st.setString(2, this.getTable().getTable());
                    st.setString(3, geomColumnName);
                    rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sql);
                    if (!rs.next()) break block4;
                    string = geomType = rs.getString(1);
                }
                catch (Throwable throwable) {
                    JDBCUtils.closeQuietly(rs);
                    JDBCUtils.closeQuietly((Statement)st);
                    throw throwable;
                }
                JDBCUtils.closeQuietly((ResultSet)rs);
                JDBCUtils.closeQuietly((Statement)st);
                return string;
            }
            JDBCUtils.closeQuietly((ResultSet)rs);
            JDBCUtils.closeQuietly((Statement)st);
            return null;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get geometry type from column '" + geomColumnName + "'.", (Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Set<String> fetchTriggers(JDBCConnection connection, String schema, String table) {
        block5: {
            if (this.tableTriggers != null) break block5;
            String getTriggersSql = "SELECT TRIGGER_NAME FROM ALL_TRIGGERS WHERE OWNER = ? AND TABLE_NAME = ? AND STATUS = 'ENABLED'";
            ResultSet rs = null;
            PreparedStatement st = null;
            HashSet<String> triggers = new HashSet<String>();
            try {
                st = connection.prepareStatement(getTriggersSql);
                st.setString(1, schema);
                st.setString(2, table);
                rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)getTriggersSql);
                while (rs.next()) {
                    triggers.add(rs.getString(1));
                }
            }
            catch (Exception exception) {
                JDBCUtils.closeQuietly(rs);
                JDBCUtils.closeQuietly((Statement)st);
                catch (Throwable throwable) {
                    JDBCUtils.closeQuietly(rs);
                    JDBCUtils.closeQuietly((Statement)st);
                    throw throwable;
                }
            }
            JDBCUtils.closeQuietly((ResultSet)rs);
            JDBCUtils.closeQuietly((Statement)st);
            this.tableTriggers = triggers;
        }
        return this.tableTriggers;
    }

    protected EditableFeatureAttributeDescriptor getAttributeFromMetadata(EditableFeatureType type, JDBCConnection conn, ResultSetMetaData rsMetadata, int colIndex) throws SQLException {
        OracleSQLBuilder sqlbuilder = (OracleSQLBuilder)this.helper.createSQLBuilder();
        EditableFeatureAttributeDescriptor attr = type.add(rsMetadata.getColumnName(colIndex), this.getDataTypeFromMetadata(rsMetadata, colIndex));
        attr.setAllowNull(rsMetadata.isNullable(colIndex) == 1);
        attr.setIsAutomatic(rsMetadata.isAutoIncrement(colIndex));
        attr.setIsReadOnly(rsMetadata.isReadOnly(colIndex));
        switch (attr.getType()) {
            case 8: {
                attr.setSize(rsMetadata.getPrecision(colIndex));
                attr.setPrecision(-1);
                attr.setScale(-1);
                break;
            }
            case 2: {
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                attr.setPrecision(3);
                attr.setScale(-1);
                break;
            }
            case 4: 
            case 5: {
                attr.setPrecision(rsMetadata.getPrecision(colIndex));
                attr.setScale(-1);
                break;
            }
            case 6: 
            case 7: 
            case 19: {
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                attr.setScale(rsMetadata.getScale(colIndex));
                attr.setPrecision(rsMetadata.getPrecision(colIndex));
                break;
            }
            case 64: {
                attr.setAdditionalInfo("SQLType", (Object)rsMetadata.getColumnType(colIndex));
                attr.setAdditionalInfo("SQLTypeName", rsMetadata.getColumnTypeName(colIndex));
                break;
            }
            case 66: {
                this.fetchGeometryTypeAndSRS(attr, rsMetadata, colIndex);
            }
        }
        String serialTriggerName = sqlbuilder.getSerialTriggerName(this.getTable().getTable(), attr.getName());
        if (this.fetchTriggers(conn, this.getTable().getSchema(), this.getTable().getTable()).contains(serialTriggerName)) {
            attr.setIsAutomatic(true);
        }
        return attr;
    }
}

