/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.operations;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CalculateEnvelopeOfColumnOperation;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.oracle.dal.GeometryTypeUtils;
import org.gvsig.oracle.dal.OracleDimensionMetadata;
import org.gvsig.oracle.dal.SpatialIndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleUpdateSpatialIndexAndMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleUpdateSpatialIndexAndMetadata.class);
    protected final JDBCHelper helper;
    protected final String database;
    protected final String schema;
    protected final String table;
    protected final FeatureType featureType;
    private JDBCConnection connection = null;

    public OracleUpdateSpatialIndexAndMetadata(JDBCHelper helper, String database, String schema, String table, FeatureType featureType) {
        this.helper = helper;
        this.database = database;
        this.schema = schema;
        this.table = table;
        this.featureType = featureType;
    }

    public void begin() throws AccessResourceException {
        this.connection = this.helper.getConnectionWritable();
    }

    protected void clean() {
        JDBCConnection.closeQuietly((JDBCConnection)this.connection);
        this.connection = null;
    }

    public void execute() throws DataException {
        this.begin();
        FeatureAttributeDescriptor geomDescriptor = this.featureType.getDefaultGeometryAttribute();
        if (geomDescriptor != null && this.updateOrInsertMetadata(geomDescriptor)) {
            this.createOrRebuildSpatialIndex(geomDescriptor);
        }
        this.clean();
    }

    public boolean updateOrInsertMetadata(FeatureAttributeDescriptor geomDescriptor) {
        String geomColumnName = geomDescriptor.getName();
        IProjection crs = geomDescriptor.getSRS();
        CalculateEnvelopeOfColumnOperation envelopeOp = null;
        List<OracleDimensionMetadata> dimensions = this.fetchDimensionMetadata();
        envelopeOp = this.helper.getOperations().createCalculateEnvelopeOfColumn(this.featureType, this.helper.getOperations().createTableReference(this.database, this.schema, this.table, null), geomColumnName, "", null, crs);
        Envelope layerEnvelope = (Envelope)envelopeOp.perform();
        if (layerEnvelope != null) {
            layerEnvelope.setProjectionIffNull(crs);
            JDBCSQLBuilderBase builder = this.helper.createSQLBuilder();
            int srid = (Integer)builder.srs_id(crs);
            if (StringUtils.isBlank((CharSequence)this.schema) || StringUtils.equalsIgnoreCase((CharSequence)this.schema, (CharSequence)this.helper.getConnectionParameters().getUser())) {
                if (dimensions.size() > 0) {
                    if (this.updateDimensions(dimensions, layerEnvelope)) {
                        return this.updateUserMetadata(dimensions, geomColumnName, srid);
                    }
                } else {
                    return this.insertUserMetadata(OracleDimensionMetadata.getDefaultDimensions(layerEnvelope), geomColumnName, srid);
                }
            }
        }
        return false;
    }

    public boolean updateUserMetadata(List<OracleDimensionMetadata> dimensions, String geomColumnName, int srid) {
        boolean bl;
        String sql = SpatialIndexUtils.getSQLUpdateUserMetadata(dimensions, geomColumnName, srid);
        PreparedStatement st = null;
        try {
            st = this.connection.prepareStatement(sql);
            SpatialIndexUtils.setUpdateUserMetadata(st, this.table, dimensions, geomColumnName, srid);
            int updatedRows = JDBCUtils.executeUpdate((PreparedStatement)st, (String)sql);
            bl = updatedRows > 0;
        }
        catch (SQLException ex) {
            try {
                LOGGER.trace("Can't insert layer metadata on USER_SDO_GEOM_METADATA", (Throwable)ex);
                throw new RuntimeException("Can't update layer metadata on USER_SDO_GEOM_METADATA", ex);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(st);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly((Statement)st);
        return bl;
    }

    public boolean insertUserMetadata(List<OracleDimensionMetadata> dimensions, String geomColumnName, int srid) {
        Statement st = null;
        String sql = SpatialIndexUtils.getSQLInsertUserMetadata(this.table, dimensions, geomColumnName, srid);
        try {
            st = this.connection.createStatement();
            int insertedRows = JDBCUtils.executeUpdate((Statement)st, (String)sql);
            boolean bl = insertedRows > 0;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.trace("Can't insert layer metadata on USER_SDO_GEOM_METADATA", (Throwable)ex);
            throw new RuntimeException("Can't insert layer metadata on USER_SDO_GEOM_METADATA", ex);
        }
        finally {
            JDBCUtils.closeQuietly((Statement)st);
        }
    }

    protected Envelope getEnvelope(List<OracleDimensionMetadata> dimensions) {
        try {
            int subType = GeometryTypeUtils.getSubType(dimensions.size());
            Point lowerCorner = (Point)GeometryLocator.getGeometryManager().create(1, subType);
            Point upperCorner = (Point)GeometryLocator.getGeometryManager().create(1, subType);
            for (int i = 0; i < dimensions.size() && i < lowerCorner.getDimension(); ++i) {
                lowerCorner.setCoordinateAt(i, dimensions.get(i).getLowerBound());
                upperCorner.setCoordinateAt(i, dimensions.get(i).getUpperBound());
            }
            Envelope envelope = GeometryLocator.getGeometryManager().createEnvelope(subType);
            envelope.setLowerCorner(lowerCorner);
            envelope.setUpperCorner(upperCorner);
            return envelope;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean updateDimensions(List<OracleDimensionMetadata> dimensions, Envelope newEnvelope) {
        Envelope oldEnvelope = this.getEnvelope(dimensions);
        if (oldEnvelope == null || oldEnvelope.contains(newEnvelope)) {
            return false;
        }
        for (int i = 0; i < dimensions.size(); ++i) {
            OracleDimensionMetadata dim = dimensions.get(i);
            dim.setLowerBound(newEnvelope.getMinimum(i));
            dim.setUpperBound(newEnvelope.getMaximum(i));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OracleDimensionMetadata> fetchDimensionMetadata() {
        OracleDimensionMetadata dim;
        PreparedStatement st;
        ArrayList<OracleDimensionMetadata> dimensions;
        ResultSet rs;
        String sdoMetadataGetTolerance;
        block13: {
            sdoMetadataGetTolerance = "SELECT dinfo.SDO_DIMNAME, dinfo.SDO_LB, dinfo.SDO_UB, dinfo.SDO_TOLERANCE FROM MDSYS.ALL_SDO_GEOM_METADATA, TABLE(DIMINFO) dinfo WHERE OWNER = ? AND TABLE_NAME = ?";
            rs = null;
            dimensions = new ArrayList<OracleDimensionMetadata>();
            st = null;
            try {
                st = this.connection.prepareStatement(sdoMetadataGetTolerance);
                st.setString(1, this.schema);
                st.setString(2, this.table);
                rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sdoMetadataGetTolerance);
                while (rs.next()) {
                    dim = new OracleDimensionMetadata(rs.getString(1), rs.getDouble(2), rs.getDouble(3), rs.getDouble(4));
                    dimensions.add(dim);
                }
                JDBCUtils.closeQuietly((ResultSet)rs);
            }
            catch (Exception ex) {
                LOGGER.debug("Error getting dimensions (ALL_SDO_GEOM_METADATA).", (Throwable)ex);
                break block13;
            }
            finally {
                JDBCUtils.closeQuietly(rs);
                JDBCUtils.closeQuietly((Statement)st);
            }
            JDBCUtils.closeQuietly((Statement)st);
        }
        if (dimensions.isEmpty()) {
            sdoMetadataGetTolerance = "SELECT dinfo.SDO_DIMNAME, dinfo.SDO_LB, dinfo.SDO_UB, dinfo.SDO_TOLERANCE FROM MDSYS.USER_SDO_GEOM_METADATA, TABLE(DIMINFO) dinfo WHERE TABLE_NAME = ?";
            rs = null;
            st = null;
            try {
                st = this.connection.prepareStatement(sdoMetadataGetTolerance);
                st.setString(1, this.table);
                rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sdoMetadataGetTolerance);
                while (rs.next()) {
                    dim = new OracleDimensionMetadata(rs.getString(1), rs.getDouble(2), rs.getDouble(3), rs.getDouble(4));
                    dimensions.add(dim);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Error getting dimensions (USER_SDO_GEOM_METADATA).", (Throwable)ex);
            }
            finally {
                JDBCUtils.closeQuietly((ResultSet)rs);
                JDBCUtils.closeQuietly((Statement)st);
            }
        }
        return dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrRebuildSpatialIndex(FeatureAttributeDescriptor geomDescriptor) {
        int geomType = geomDescriptor.getGeomType().getType();
        int geomSubtype = geomDescriptor.getGeomType().getSubType();
        String geomColumn = geomDescriptor.getName();
        String indexName = SpatialIndexUtils.getSpatialIndex(this.connection, this.schema, this.table, geomColumn);
        Statement st = null;
        if (indexName == null) {
            String sql = SpatialIndexUtils.getSQLCreateSpatialIndex(this.table, geomColumn, geomType, geomSubtype);
            try {
                st = this.connection.createStatement();
                JDBCUtils.execute((Statement)st, (String)sql);
            }
            catch (Exception ex) {
                LOGGER.debug("Error creating spatial index", (Throwable)ex);
            }
            finally {
                JDBCUtils.closeQuietly((Statement)st);
            }
        } else {
            String sql = SpatialIndexUtils.getSQLRebuildSpatialIndex(this.table, geomColumn, geomType, geomSubtype);
            try {
                st = this.connection.createStatement();
                JDBCUtils.executeQuery((Statement)st, (String)sql);
            }
            catch (Exception ex) {
                LOGGER.warn("Error rebuilding spatial index", (Throwable)ex);
            }
            finally {
                JDBCUtils.closeQuietly((Statement)st);
            }
        }
    }
}

