/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.gui.layerproperties;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.legend.gui.Categories;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.SymbolTable;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.ClassifiableVectorial;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.PictureFillSymbol;
import org.gvsig.symbology.fmap.rendering.VectorFilterExpressionLegend;
import org.gvsig.symbology.gui.layerproperties.ExpressionFieldCellEditor;
import org.gvsig.symbology.gui.layerproperties.ExpressionSymbolPanel;
import org.gvsig.symbology.gui.layerproperties.VectorFilterExpressionPanelView;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorFilterExpressionPanel2
extends VectorFilterExpressionPanelView
implements ILegendPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorFilterExpressionPanel2.class);
    private VectorFilterExpressionLegend theLegend;
    private VectorFilterExpressionLegend auxLegend;
    private ClassifiableVectorial layer;
    private PictureFillSymbol previewSymbol;
    private SymbolTable symbolTable;
    private int shapeType;
    private PickerController<ISymbol> defaultSymbolPrev;

    public VectorFilterExpressionPanel2() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.btnAdd);
        toolsSwingManager.translate((AbstractButton)this.btnRemove);
        toolsSwingManager.translate((AbstractButton)this.btnRemoveAll);
        toolsSwingManager.translate((AbstractButton)this.btnDown);
        toolsSwingManager.translate((AbstractButton)this.btnUp);
        toolsSwingManager.translate((AbstractButton)this.chkDefaultValues);
        this.defaultSymbolPrev = SymbologySwingLocator.getSwingManager().createSymbolPickerController(this.btnDefaultValuesPreview, null, this.shapeType, null);
        this.btnUp.setIcon(IconThemeHelper.getImageIcon((String)"symbol-layer-move-up"));
        this.btnDown.setIcon(IconThemeHelper.getImageIcon((String)"symbol-layer-move-down"));
        this.btnUp.setText("");
        this.btnDown.setText("");
        this.btnUp.addActionListener(e -> this.doUp());
        this.btnDown.addActionListener(e -> this.doDown());
        this.btnAdd.addActionListener(e -> this.doAdd());
        this.btnRemove.addActionListener(e -> this.doRemove());
        this.btnRemoveAll.addActionListener(e -> this.doRemoveAll());
    }

    public String getDescription() {
        return Messages.getText((String)"shows_the_elements_of_the_layer_depending_on_the_value_of_a_filter_expression") + ".";
    }

    public ISymbol getIconSymbol() {
        if (this.previewSymbol == null) {
            try {
                this.previewSymbol = new PictureFillSymbol();
                URL resource = this.getClass().getClassLoader().getResource("images/legend/legend-overview-vectorial-unique-value.png");
                if (resource == null) {
                    return null;
                }
                this.previewSymbol.setImage(resource);
                this.previewSymbol.getMarkerFillProperties().setFillStyle(2);
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.previewSymbol;
    }

    public ILegend getLegend() {
        this.auxLegend.clear();
        this.fillSymbolListFromTable();
        this.theLegend = (VectorFilterExpressionLegend)this.auxLegend.cloneLegend();
        if (this.defaultSymbolPrev.get() != null) {
            this.theLegend.setDefaultSymbol((ISymbol)this.defaultSymbolPrev.get());
        }
        this.theLegend.useDefaultSymbol(this.chkDefaultValues.isSelected());
        return this.theLegend;
    }

    private void fillSymbolListFromTable() {
        FLyrVect m = (FLyrVect)this.layer;
        try {
            if (this.auxLegend.getClassifyingFieldNames() != null) {
                String[] fNames = this.auxLegend.getClassifyingFieldNames();
                int[] fieldTypes = new int[this.auxLegend.getClassifyingFieldNames().length];
                FeatureStore fsto = (FeatureStore)m.getDataStore();
                FeatureType fty = fsto.getDefaultFeatureType();
                for (int i = 0; i < fNames.length; ++i) {
                    fieldTypes[i] = fty.getAttributeDescriptor(fNames[i]).getType();
                }
                this.auxLegend.setClassifyingFieldTypes(fieldTypes);
            }
        }
        catch (Exception fNames) {
            // empty catch block
        }
        this.auxLegend.useDefaultSymbol(this.chkDefaultValues.isSelected());
        for (int row = 0; row < this.symbolTable.getRowCount(); ++row) {
            Object clave = this.symbolTable.getFieldValue(row, 1);
            ISymbol theSymbol = (ISymbol)this.symbolTable.getFieldValue(row, 0);
            theSymbol.setDescription((String)this.symbolTable.getFieldValue(row, 2));
            this.auxLegend.addSymbol(clave, theSymbol);
        }
        if (this.chkDefaultValues.isSelected() && this.defaultSymbolPrev.get() != null) {
            String description = VectorFilterExpressionLegend.I18N_DEFAULT;
            ((ISymbol)this.defaultSymbolPrev.get()).setDescription(description);
            this.auxLegend.addSymbol(description, (ISymbol)this.defaultSymbolPrev.get());
        }
    }

    public Class<VectorFilterExpressionLegend> getLegendClass() {
        return VectorFilterExpressionLegend.class;
    }

    public JPanel getPanel() {
        return this;
    }

    public Class<Categories> getParentClass() {
        return Categories.class;
    }

    public String getTitle() {
        return Messages.getText((String)"expressions");
    }

    public boolean isSuitableFor(FLayer layer) {
        FLyrVect lVect = (FLyrVect)layer;
        try {
            return VectorFilterExpressionLegend.isPoint(lVect.getShapeType()) || VectorFilterExpressionLegend.isLinear(lVect.getShapeType()) || VectorFilterExpressionLegend.isPolygonal(lVect.getShapeType());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setData(FLayer lyr, ILegend legend) {
        this.layer = (ClassifiableVectorial)lyr;
        this.shapeType = 0;
        try {
            this.shapeType = this.layer.getGeometryType().getType();
        }
        catch (ReadException e) {
            LOGGER.warn("Error while getting layer shp type", (Throwable)e);
            ApplicationLocator.getManager().message(Messages.getText((String)"generating_intervals"), 0);
        }
        this.defaultSymbolPrev = SymbologySwingLocator.getSwingManager().createSymbolPickerController(this.btnDefaultValuesPreview, null, this.shapeType, null);
        this.symbolTable = new SymbolTable(this.tblSymbols, (Component)this, "expressions", this.shapeType);
        this.doUpdateCellEditor();
        if (legend instanceof VectorFilterExpressionLegend) {
            this.auxLegend = (VectorFilterExpressionLegend)legend.cloneLegend();
            if (this.auxLegend.isUseDefaultSymbol()) {
                this.fillTableSkipDefault(this.auxLegend);
            } else {
                this.symbolTable.fillTableFromSymbolList(this.auxLegend.getSymbols(), this.auxLegend.getValues(), this.auxLegend.getDescriptions());
            }
        } else {
            this.auxLegend = new VectorFilterExpressionLegend();
            this.auxLegend.setShapeType(this.shapeType);
        }
        this.defaultSymbolPrev.set((Object)this.auxLegend.getDefaultSymbol());
        this.chkDefaultValues.setSelected(this.auxLegend.isUseDefaultSymbol());
    }

    private void doUpdateCellEditor() {
        try {
            ExpressionFieldCellEditor cellEditor = new ExpressionFieldCellEditor(((FLyrVect)this.layer).getFeatureStore());
            this.symbolTable.setCellEditor((TableCellEditor)cellEditor);
        }
        catch (Exception ex) {
            LOGGER.debug("Can't update cell editors", (Throwable)ex);
        }
    }

    private void doUp() {
        int[] indices = this.symbolTable.getSelectedRows();
        if (indices.length > 0) {
            int classIndex = indices[0];
            int targetPos = Math.max(0, classIndex - 1);
            this.symbolTable.moveUpRows(classIndex, targetPos, indices.length);
        }
    }

    private void doDown() {
        int[] indices = this.symbolTable.getSelectedRows();
        if (indices.length > 0) {
            int classIndex = indices[indices.length - 1];
            int targetPos = Math.min(this.symbolTable.getRowCount() - 1, classIndex + 1);
            this.symbolTable.moveDownRows(classIndex, targetPos, indices.length);
        }
    }

    private void doAdd() {
        FLyrVect vect = (FLyrVect)this.layer;
        FeatureStore fsto = vect.getFeatureStore();
        FeatureType fty = fsto.getDefaultFeatureTypeQuietly();
        int shptype = fty.getDefaultGeometryAttribute().getGeomType().getType();
        I18nManager i18n = ToolsLocator.getI18nManager();
        ExpressionSymbolPanel esp = new ExpressionSymbolPanel(fsto, shptype, (ISymbol)this.previewSymbol);
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = windowManager.createDialog((JComponent)esp, i18n.getTranslation("expression_creator"), "", 3);
        dialog.addActionListener(e1 -> {
            if (dialog.getAction() != 1) {
                return;
            }
            String expr = esp.getExpression();
            if (StringUtils.isBlank((CharSequence)expr)) {
                ApplicationLocator.getManager().messageDialog(Messages.getText((String)"error_validating_filter_query"), Messages.getText((String)"error"), 0);
                return;
            }
            ISymbol sym = esp.getSymbol();
            this.addClassFieldNames(fty);
            this.auxLegend.addSymbol(expr, sym);
            this.symbolTable.removeAllItems();
            this.doUpdateCellEditor();
            this.fillTableSkipDefault(this.auxLegend);
            this.repaint();
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private void doRemove() {
        if (this.symbolTable.getSelectedRowElements() == null) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"select_one_row"));
        } else {
            String my_expr = (String)this.symbolTable.getSelectedRowElements()[1];
            this.auxLegend.delSymbol(my_expr);
            this.symbolTable.removeAllItems();
            this.doUpdateCellEditor();
            this.fillTableSkipDefault(this.auxLegend);
            this.repaint();
        }
    }

    private void doRemoveAll() {
        this.auxLegend.clear();
        this.symbolTable.removeAllItems();
        this.doUpdateCellEditor();
        this.fillTableSkipDefault(this.auxLegend);
        this.repaint();
    }

    private void addClassFieldNames(FeatureType ft) {
        FeatureAttributeDescriptor[] atts = ft.getAttributeDescriptors();
        String[] nn = new String[atts.length];
        for (int i = 0; i < atts.length; ++i) {
            nn[i] = atts[i].getName();
        }
        this.addClassFieldNames(nn);
    }

    private void addClassFieldNames(String[] fieldNamesExpression) {
        ArrayList<String> myFieldNames = new ArrayList<String>();
        if (this.auxLegend.getClassifyingFieldNames() != null) {
            myFieldNames.addAll(Arrays.asList(this.auxLegend.getClassifyingFieldNames()));
            for (String fieldNamesExpression1 : fieldNamesExpression) {
                boolean appears = false;
                for (String classifyingFieldName : this.auxLegend.getClassifyingFieldNames()) {
                    if (classifyingFieldName.compareTo(fieldNamesExpression1) != 0) continue;
                    appears = true;
                }
                if (appears) continue;
                myFieldNames.add(fieldNamesExpression1);
            }
            this.auxLegend.setClassifyingFieldNames(myFieldNames.toArray(new String[myFieldNames.size()]));
        } else {
            for (String fieldNamesExpression1 : fieldNamesExpression) {
                myFieldNames.add(fieldNamesExpression1);
            }
            this.auxLegend.setClassifyingFieldNames(myFieldNames.toArray(new String[myFieldNames.size()]));
        }
    }

    public ImageIcon getIcon() {
        ImageIcon icon = IconThemeHelper.getImageIcon((String)"legend-overview-vector-filter-expression");
        return icon;
    }

    private void fillTableSkipDefault(VectorFilterExpressionLegend leg) {
        Object[] src_expr = leg.getValues();
        ArrayList<Integer> rem_ind = new ArrayList<Integer>();
        for (int i = 0; i < src_expr.length; ++i) {
            if (VectorFilterExpressionLegend.I18N_DEFAULT.compareToIgnoreCase((String)src_expr[i]) != 0) continue;
            rem_ind.add(i);
        }
        ISymbol[] src_syms = leg.getSymbols();
        String[] src_descs = leg.getDescriptions();
        ArrayList<ISymbol> syms = new ArrayList<ISymbol>();
        ArrayList<Object> vals = new ArrayList<Object>();
        ArrayList<String> descs = new ArrayList<String>();
        for (int i = 0; i < src_expr.length; ++i) {
            if (this.isIn(i, rem_ind)) continue;
            syms.add(src_syms[i]);
            vals.add(src_expr[i]);
            descs.add(src_descs[i]);
        }
        this.symbolTable.fillTableFromSymbolList(syms.toArray(new ISymbol[0]), vals.toArray(new Object[0]), descs.toArray(new String[0]));
    }

    private boolean isIn(int n, List<Integer> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Integer item : list) {
            if (item == null || item != n) continue;
            return true;
        }
        return false;
    }
}

