/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.rendering;

import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ZSort;
import org.gvsig.fmap.mapcontext.rendering.legend.events.IntervalLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LabelLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendClearEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.ValueLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.VectorialUniqueValueLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.MarkerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.MultiLayerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMarkerFillPropertiesStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.SimpleMarkerFillPropertiesStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProportionalSymbolsLegend
extends VectorialUniqueValueLegend {
    private static Logger logger = LoggerFactory.getLogger(ProportionalSymbolsLegend.class);
    public static final String PROPORTIONAL_SYMBOL_LEGEND_NAME = "PROPORTIONAL_SYMBOL_LEGEND";
    public static final String PROPORTIONAL_SYMBOL_LEGEND_PERSISTENCE_DEFINITION_NAME = "PROPORTIONAL_SYMBOL_LEGEND_PERSISTENCE_DEFINITION";
    private ISymbol backgroundSymbol;
    private String valueField;
    private String normalizationField;
    private double minSize;
    private double maxSize;
    private int templateShapeType;
    private boolean useNormalization;
    private double maxFeature;
    private double minFeature;
    private ZSort zSort = null;

    public void setClassifyingFieldNames(String[] fNames) {
        super.setClassifyingFieldNames(fNames);
        this.valueField = fNames[0];
        this.normalizationField = fNames[1];
    }

    public ISymbol getSymbolByValue(Object key) {
        return null;
    }

    public ISymbol getSymbolByFeature(Feature feat) {
        double size;
        ISymbol theSymbol = this.getDefaultSymbol();
        double value = 0.0;
        double normValue = 0.0;
        double separation = this.maxSize - this.minSize;
        if (separation == 0.0) {
            separation = 1.0;
        }
        try {
            value = feat.getDouble(this.valueField);
            if (this.useNormalization) {
                normValue = feat.getDouble(this.normalizationField);
                size = normValue == 0.0 ? (value >= 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : this.minSize + (value /= normValue) * separation;
            } else {
                double difFeat = this.maxFeature - this.minFeature;
                double step = difFeat / separation;
                size = this.minSize + (value - this.minFeature) / step;
            }
        }
        catch (Exception e) {
            logger.info("Error while getting value in ProportionalSymbolsLegend.", (Throwable)e);
            return null;
        }
        if (size == Double.NaN || size == Double.POSITIVE_INFINITY || size == Double.NEGATIVE_INFINITY) {
            return null;
        }
        Geometry defgeom = feat.getDefaultGeometry();
        int def_geom_type = defgeom.getGeometryType().getType();
        if (ProportionalSymbolsLegend.isPolygonal(def_geom_type) && theSymbol instanceof IMarkerSymbol) {
            MarkerFillSymbol aux = new MarkerFillSymbol();
            ((IMarkerSymbol)theSymbol).setSize(size);
            aux.setMarker((IMarkerSymbol)theSymbol);
            SimpleMarkerFillPropertiesStyle p = new SimpleMarkerFillPropertiesStyle();
            p.setFillStyle(2);
            aux.setMarkerFillProperties((IMarkerFillPropertiesStyle)p);
            theSymbol = aux;
        } else if (ProportionalSymbolsLegend.isLinear(def_geom_type)) {
            ILineSymbol line = (ILineSymbol)theSymbol;
            line.setLineWidth(size);
            theSymbol = line;
        } else if (ProportionalSymbolsLegend.isPoint(def_geom_type)) {
            IMarkerSymbol marker = (IMarkerSymbol)theSymbol;
            marker.setSize(size);
            theSymbol = marker;
        }
        if (this.backgroundSymbol != null) {
            MultiLayerFillSymbol multi = new MultiLayerFillSymbol();
            multi.addLayer(this.backgroundSymbol);
            multi.addLayer(theSymbol);
            return multi;
        }
        ISymbol auxSymbol = theSymbol;
        return auxSymbol;
    }

    public static boolean isPolygonal(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(9, ty) || geomManager.isSubtype(3, ty);
    }

    public static boolean isLinear(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(8, ty) || geomManager.isSubtype(2, ty);
    }

    public static boolean isPoint(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(7, ty) || geomManager.isSubtype(1, ty);
    }

    public ISymbol getBackgroundSymbol() {
        return this.backgroundSymbol;
    }

    public void setBackgroundSymbol(ISymbol backgroundSymbol) {
        this.backgroundSymbol = backgroundSymbol;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public String getNormalizationField() {
        return this.normalizationField;
    }

    public void setNormalizationField(String normalizationField) {
        this.normalizationField = normalizationField;
    }

    public double getMinSize() {
        return this.minSize;
    }

    public void setMinSize(double minSize) {
        this.minSize = minSize;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(double maxSize) {
        this.maxSize = maxSize;
    }

    public int getTemplateShapeType() {
        return this.templateShapeType;
    }

    public void setTemplateShapeType(int tst) {
        if (ProportionalSymbolsLegend.isPolygonal(this.getShapeType())) {
            if (ProportionalSymbolsLegend.isPoint(tst) || ProportionalSymbolsLegend.isPolygonal(tst)) {
                this.templateShapeType = tst;
            }
        } else if (ProportionalSymbolsLegend.isPoint(tst) && ProportionalSymbolsLegend.isPoint(this.getShapeType()) || ProportionalSymbolsLegend.isLinear(tst) && ProportionalSymbolsLegend.isLinear(this.getShapeType())) {
            this.templateShapeType = tst;
        }
    }

    public boolean getUseNormalization() {
        return this.useNormalization;
    }

    public void setUseNormalization(boolean useNormalization) {
        this.useNormalization = useNormalization;
    }

    public double getMaxFeature() {
        return this.maxFeature;
    }

    public void setMaxFeature(double maxFeature) {
        this.maxFeature = maxFeature;
    }

    public double getMinFeature() {
        return this.minFeature;
    }

    public void setMinFeature(double minFeature) {
        this.minFeature = minFeature;
    }

    public ISymbol[] getSymbols() {
        ISymbol[] auxSymbols = super.getSymbols();
        if (this.backgroundSymbol != null) {
            ISymbol[] symbols = new ISymbol[auxSymbols.length + 1];
            for (int i = 0; i < auxSymbols.length; ++i) {
                symbols[i] = auxSymbols[i];
            }
            symbols[symbols.length - 1] = this.backgroundSymbol;
            return symbols;
        }
        return auxSymbols;
    }

    public ZSort getZSort() {
        if (this.zSort == null) {
            this.zSort = new MyZSort((ILegend)this);
        }
        return this.zSort;
    }

    public void setZSort(ZSort zSort) {
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        String[] fieldNames;
        int[] ft = state.getIntArray("fieldTypes");
        this.setClassifyingFieldTypes(ft);
        this.valueField = state.getString("valueField");
        this.normalizationField = state.getString("normalizationField");
        this.templateShapeType = state.getInt("templateShapeType");
        this.maxSize = state.getDouble("maxSize");
        this.minSize = state.getDouble("minSize");
        this.maxFeature = state.getDouble("maxFeature");
        this.minFeature = state.getDouble("minFeature");
        this.useNormalization = state.getBoolean("useNormalization");
        ISymbol sym = (ISymbol)state.get("defaultSymbol");
        this.setDefaultSymbol(sym);
        sym = (ISymbol)state.get("backgroundSymbol");
        this.setBackgroundSymbol(sym);
        fieldNames = new String[]{this.valueField, this.normalizationField.compareTo(Messages.getText((String)"none")) == 0 ? fieldNames[0] : this.normalizationField};
        this.setClassifyingFieldNames(fieldNames);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        int[] ft = this.getClassifyingFieldTypes();
        state.set("fieldTypes", ft);
        state.set("valueField", this.valueField);
        state.set("normalizationField", this.normalizationField);
        state.set("templateShapeType", this.templateShapeType);
        state.set("maxSize", this.maxSize);
        state.set("minSize", this.minSize);
        state.set("maxFeature", this.maxFeature);
        state.set("minFeature", this.minFeature);
        state.set("useNormalization", this.useNormalization);
        state.set("defaultSymbol", (Persistent)this.getDefaultSymbol());
        state.set("backgroundSymbol", (Persistent)this.backgroundSymbol);
    }

    public static class RegisterLegend
    implements Callable {
        public Object call() throws Exception {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            manager.registerLegend(ProportionalSymbolsLegend.PROPORTIONAL_SYMBOL_LEGEND_NAME, ProportionalSymbolsLegend.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(ProportionalSymbolsLegend.PROPORTIONAL_SYMBOL_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(ProportionalSymbolsLegend.class, ProportionalSymbolsLegend.PROPORTIONAL_SYMBOL_LEGEND_PERSISTENCE_DEFINITION_NAME, "PROPORTIONAL_SYMBOL_LEGEND_PERSISTENCE_DEFINITION Persistence definition", null, null);
                definition.addDynFieldString("valueField").setMandatory(true);
                definition.addDynFieldString("normalizationField").setMandatory(true);
                definition.addDynFieldInt("templateShapeType").setMandatory(true);
                definition.addDynFieldArray("fieldTypes").setClassOfItems(Integer.class).setMandatory(true);
                definition.addDynFieldDouble("maxSize").setMandatory(true);
                definition.addDynFieldDouble("minSize").setMandatory(true);
                definition.addDynFieldDouble("maxFeature").setMandatory(true);
                definition.addDynFieldDouble("minFeature").setMandatory(true);
                definition.addDynFieldBoolean("useNormalization").setMandatory(true);
                definition.addDynFieldObject("defaultSymbol").setClassOfValue(ISymbol.class).setMandatory(true);
                definition.addDynFieldObject("backgroundSymbol").setClassOfValue(ISymbol.class).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }

    private class MyZSort
    extends ZSort {
        public MyZSort(ILegend legend) {
            super(legend);
        }

        public void legendChanged(LegendChangedEvent e) {
        }

        public String getClassName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public int getLevelCount() {
            int levels = 0;
            if (ProportionalSymbolsLegend.this.backgroundSymbol != null) {
                levels = ProportionalSymbolsLegend.this.backgroundSymbol instanceof IMultiLayerSymbol ? (levels += ((IMultiLayerSymbol)ProportionalSymbolsLegend.this.backgroundSymbol).getLayerCount()) : ++levels;
            }
            ISymbol sym = ProportionalSymbolsLegend.this.getDefaultSymbol();
            levels = ProportionalSymbolsLegend.this.getDefaultSymbol() instanceof IMultiLayerSymbol ? (levels += ((IMultiLayerSymbol)sym).getLayerCount()) : ++levels;
            return levels + 1;
        }

        public void setUsingZSort(boolean usingZSort) {
        }

        public void setLevels(ISymbol sym, int[] values) {
        }

        public void setLevels(int row, int[] values) {
        }

        public int[] getLevels(ISymbol sym) {
            return this.getLevels(0);
        }

        public int[] getLevels(int row) {
            int levelsCount = this.getLevelCount();
            int[] levels = new int[levelsCount];
            int bgLevels = 1;
            if (ProportionalSymbolsLegend.this.backgroundSymbol != null) {
                if (ProportionalSymbolsLegend.this.backgroundSymbol instanceof IMultiLayerSymbol) {
                    bgLevels = ((IMultiLayerSymbol)ProportionalSymbolsLegend.this.backgroundSymbol).getLayerCount();
                }
                for (int i = 0; i < bgLevels; ++i) {
                    levels[i] = i;
                }
            }
            ISymbol sym = ProportionalSymbolsLegend.this.getDefaultSymbol();
            int frLevels = 1;
            if (ProportionalSymbolsLegend.this.getDefaultSymbol() instanceof IMultiLayerSymbol) {
                frLevels = ((IMultiLayerSymbol)sym).getLayerCount();
            }
            for (int i = 0; i < frLevels; ++i) {
                levels[i + bgLevels] = i + bgLevels;
            }
            levels[frLevels + bgLevels] = frLevels + bgLevels;
            return levels;
        }

        public boolean isUsingZSort() {
            return ProportionalSymbolsLegend.this.backgroundSymbol != null;
        }

        public ISymbol[] getSymbols() {
            return this.getSymbols();
        }

        public String[] getDescriptions() {
            return this.getDescriptions();
        }

        public int getTopLevelIndexAllowed() {
            return this.getLevelCount();
        }

        public String toString() {
            String out = "ZSort for ProportionalSymbolLegend";
            return out;
        }

        public boolean symbolChanged(SymbolLegendEvent e) {
            return true;
        }

        public boolean classifiedSymbolChange(SymbolLegendEvent e) {
            return true;
        }

        public boolean intervalChange(IntervalLegendEvent e) {
            return false;
        }

        public boolean valueChange(ValueLegendEvent e) {
            return false;
        }

        public boolean labelFieldChange(LabelLegendEvent e) {
            return false;
        }

        public void legendCleared(LegendClearEvent event) {
        }
    }
}

