/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.JSymbolPreviewButton;
import org.gvsig.app.project.documents.view.legend.gui.Quantities;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.ClassifiableVectorial;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.MarkerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl.SimpleLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.SimpleMarkerSymbol;
import org.gvsig.symbology.fmap.rendering.ProportionalSymbolsLegend;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProportionalSymbolsPanel
extends JPanel
implements ILegendPanel {
    private static Logger logger = LoggerFactory.getLogger(ProportionalSymbolsPanel.class);
    private static final long serialVersionUID = 7394720230276170902L;
    private JPanel symbolPanel;
    private JPanel backgroundPanel;
    private JSymbolPreviewButton tmplateSymbol;
    private JSymbolPreviewButton backSymbol;
    private JComboBox cmbValue;
    private JComboBox cmbNormalization;
    private JNumberSpinner txtMinSize;
    private JNumberSpinner txtMaxSize;
    private ClassifiableVectorial myLayer;
    private ProportionalSymbolsLegend auxLegend;
    private String[] fieldNames;
    private int templateShapeType = 0;
    private String noNormalization = Messages.getText((String)"none");
    private boolean useNormalization = true;
    private ActionListener action = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb;
            if (e.getSource().equals(ProportionalSymbolsPanel.this.cmbValue)) {
                cb = (JComboBox)e.getSource();
                ProportionalSymbolsPanel.this.auxLegend.setValueField(cb.getSelectedItem().toString());
            }
            if (e.getSource().equals(ProportionalSymbolsPanel.this.cmbNormalization)) {
                cb = (JComboBox)e.getSource();
                if (cb.getSelectedItem().toString().compareTo(ProportionalSymbolsPanel.this.noNormalization) == 0) {
                    ProportionalSymbolsPanel.this.useNormalization = false;
                    ProportionalSymbolsPanel.this.auxLegend.setNormalizationField(ProportionalSymbolsPanel.this.cmbValue.getSelectedItem().toString());
                } else {
                    ProportionalSymbolsPanel.this.useNormalization = true;
                    ProportionalSymbolsPanel.this.auxLegend.setNormalizationField(cb.getSelectedItem().toString());
                }
                ProportionalSymbolsPanel.this.auxLegend.setUseNormalization(ProportionalSymbolsPanel.this.useNormalization);
            }
            if (e.getSource().equals(ProportionalSymbolsPanel.this.txtMinSize) && ProportionalSymbolsPanel.this.txtMaxSize.getDouble() < ProportionalSymbolsPanel.this.txtMinSize.getDouble()) {
                ProportionalSymbolsPanel.this.txtMaxSize.setDouble(ProportionalSymbolsPanel.this.txtMinSize.getDouble());
            }
            if (e.getSource().equals(ProportionalSymbolsPanel.this.txtMaxSize) && ProportionalSymbolsPanel.this.txtMaxSize.getDouble() < ProportionalSymbolsPanel.this.txtMinSize.getDouble()) {
                ProportionalSymbolsPanel.this.txtMinSize.setDouble(ProportionalSymbolsPanel.this.txtMaxSize.getDouble());
            }
        }
    };

    public ProportionalSymbolsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel aux = new JPanel(new BorderLayout());
        JPanel fieldsPanel = new JPanel(new FlowLayout());
        fieldsPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"fields")));
        fieldsPanel.setPreferredSize(new Dimension(300, 60));
        this.cmbValue = new JComboBox();
        this.cmbValue.setActionCommand("VALUE_SELECTED");
        this.cmbNormalization = new JComboBox();
        this.cmbNormalization.setActionCommand("NORMALIZATION_SELECTED");
        fieldsPanel.add(new JLabel(Messages.getText((String)"value") + ":"));
        fieldsPanel.add(this.cmbValue);
        fieldsPanel.add(new JLabel(Messages.getText((String)"normalization") + ":"));
        fieldsPanel.add(this.cmbNormalization);
        this.symbolPanel = new JPanel(new FlowLayout(3, 3, 2));
        this.symbolPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"symbol")));
        GridBagLayoutPanel aux2 = new GridBagLayoutPanel();
        aux2.addComponent((Component)new JLabel(Messages.getText((String)"size")));
        aux2.addComponent((Component)new JBlank(10, 10));
        aux2.addComponent(Messages.getText((String)"from") + ":", (Component)this.getTxtMinSize());
        aux2.addComponent(Messages.getText((String)"to") + ":", (Component)this.getTxtMaxSize());
        JPanel templatePanel = new JPanel();
        templatePanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"template")));
        templatePanel.add((Component)this.getTemplSymbol());
        this.symbolPanel.add((Component)new JBlank(10, 10));
        this.symbolPanel.add((Component)aux2);
        this.symbolPanel.add((Component)new JBlank(10, 10));
        this.symbolPanel.add(templatePanel);
        aux.add((Component)fieldsPanel, "North");
        aux.add((Component)this.symbolPanel, "Center");
        this.add((Component)aux, "Center");
        this.cmbValue.addActionListener(this.action);
        this.cmbNormalization.addActionListener(this.action);
        this.tmplateSymbol.addActionListener(this.action);
    }

    private JPanel getBackgroundPanel() {
        this.backgroundPanel = new JPanel();
        this.backgroundPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"background")));
        this.backgroundPanel.add((Component)this.getBtnBackground());
        return this.backgroundPanel;
    }

    private JNumberSpinner getTxtMaxSize() {
        if (this.txtMaxSize == null) {
            this.txtMaxSize = new JNumberSpinner(25.0, 7, 0.0, 100.0, 1.0, 2);
            this.txtMaxSize.addActionListener(this.action);
        }
        return this.txtMaxSize;
    }

    private JNumberSpinner getTxtMinSize() {
        if (this.txtMinSize == null) {
            this.txtMinSize = new JNumberSpinner(3.0, 7, 0.0, 100.0, 1.0, 2);
            this.txtMinSize.addActionListener(this.action);
        }
        return this.txtMinSize;
    }

    private JSymbolPreviewButton getTemplSymbol() {
        if (this.tmplateSymbol == null) {
            int tst = ProportionalSymbolsLegend.isPolygonal(this.templateShapeType) ? 1 : this.templateShapeType;
            this.tmplateSymbol = new JSymbolPreviewButton(tst);
        }
        this.tmplateSymbol.setPreferredSize(new Dimension(100, 45));
        return this.tmplateSymbol;
    }

    private JSymbolPreviewButton getBtnBackground() {
        if (this.backSymbol == null) {
            this.backSymbol = new JSymbolPreviewButton(3);
            this.backSymbol.setPreferredSize(new Dimension(100, 45));
            ISymbol fillsym = MapContextLocator.getSymbolManager().createSymbol(3, Color.ORANGE);
            this.backSymbol.setSymbol(fillsym);
        }
        return this.backSymbol;
    }

    private ISymbol newSymbol(int shapeType, double size) {
        if (this.getTemplSymbol().getSymbol() == null) {
            SimpleMarkerSymbol templateSymbol;
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            if (geomManager.isSubtype(1, shapeType) || geomManager.isSubtype(7, shapeType) || geomManager.isSubtype(3, shapeType) || geomManager.isSubtype(9, shapeType)) {
                templateSymbol = new SimpleMarkerSymbol();
                templateSymbol.setSize(size);
                templateSymbol.setColor(Color.DARK_GRAY);
            } else if (geomManager.isSubtype(2, shapeType) || geomManager.isSubtype(8, shapeType)) {
                templateSymbol = new SimpleLineSymbol();
                ((SimpleLineSymbol)templateSymbol).setLineWidth(size);
                ((SimpleLineSymbol)templateSymbol).setLineColor(Color.DARK_GRAY);
            } else {
                throw new RuntimeException("Unknown symbol type");
            }
            this.getTemplSymbol().setSymbol((ISymbol)templateSymbol);
            return this.newSymbol(shapeType, size);
        }
        ISymbol mySymbol = this.getTemplSymbol().getSymbol();
        try {
            mySymbol = (ISymbol)mySymbol.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.info("Error while cloning symbol", (Throwable)e);
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"_Unable_to_clone_symbol"), Messages.getText((String)"error"), 0);
        }
        if (mySymbol instanceof ILineSymbol) {
            ILineSymbol lSym = (ILineSymbol)mySymbol;
            lSym.setLineWidth(size);
        }
        if (mySymbol instanceof IMarkerSymbol) {
            IMarkerSymbol mSym = (IMarkerSymbol)mySymbol;
            mSym.setSize(size);
            if (ProportionalSymbolsLegend.isPolygonal(shapeType)) {
                MarkerFillSymbol fillSymbol = new MarkerFillSymbol();
                fillSymbol.setOutline(null);
                fillSymbol.setFillColor(null);
                fillSymbol.getMarkerFillProperties().setFillStyle(2);
                fillSymbol.setMarker(mSym);
            }
        }
        return mySymbol;
    }

    private void fillFieldNames() {
        try {
            FeatureStore fsto = (FeatureStore)((FLyrVect)this.myLayer).getDataStore();
            FeatureType fty = fsto.getDefaultFeatureType();
            FeatureAttributeDescriptor[] atts = fty.getAttributeDescriptors();
            int cont = 0;
            for (int i = 0; i < atts.length; ++i) {
                if (!atts[i].getDataType().isNumeric()) continue;
                ++cont;
            }
            String[] nomFields = new String[cont];
            cont = 0;
            for (int i = 0; i < atts.length; ++i) {
                if (!atts[i].getDataType().isNumeric()) continue;
                nomFields[cont] = atts[i].getName();
                ++cont;
            }
            this.fieldNames = nomFields;
            DefaultComboBoxModel<String> cMValue = new DefaultComboBoxModel<String>(this.fieldNames);
            DefaultComboBoxModel<String> cMNormalization = new DefaultComboBoxModel<String>(this.fieldNames);
            this.cmbValue.setModel(cMValue);
            this.cmbNormalization.setModel(cMNormalization);
            this.cmbNormalization.addItem(this.noNormalization);
        }
        catch (DataException e) {
            logger.info("Error while getting fields", (Throwable)e);
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"_Error_while_getting_fields"), Messages.getText((String)"error"), 0);
        }
    }

    public void setData(FLayer lyr, ILegend legend) {
        this.myLayer = (ClassifiableVectorial)lyr;
        this.fillFieldNames();
        int myt = 0;
        try {
            myt = this.myLayer.getGeometryType().getType();
        }
        catch (ReadException re) {
            logger.info("Error while getting geometry type", (Throwable)re);
            ApplicationLocator.getManager().message("Error getting geometry type", 0);
        }
        this.templateShapeType = ProportionalSymbolsLegend.isPolygonal(myt) ? 1 : myt;
        this.getTemplSymbol().setShapeType(this.templateShapeType);
        if (ProportionalSymbolsLegend.isPolygonal(myt) && this.backgroundPanel == null) {
            this.symbolPanel.add(this.getBackgroundPanel());
        }
        if (ProportionalSymbolsLegend.class.equals(legend.getClass())) {
            this.auxLegend = (ProportionalSymbolsLegend)legend.cloneLegend();
            this.cmbValue.setSelectedItem(this.auxLegend.getClassifyingFieldNames()[0]);
            ISymbol defSymbol = this.auxLegend.getDefaultSymbol();
            if (this.auxLegend.getUseNormalization()) {
                this.cmbNormalization.setSelectedItem(this.auxLegend.getClassifyingFieldNames()[1]);
            } else {
                this.cmbNormalization.setSelectedItem(this.noNormalization);
            }
            this.txtMaxSize.setDouble(this.auxLegend.getMaxSize());
            this.txtMinSize.setDouble(this.auxLegend.getMinSize());
            if (ProportionalSymbolsLegend.isLinear(this.templateShapeType)) {
                ((ILineSymbol)defSymbol).setLineWidth(2.0);
            } else {
                ((IMarkerSymbol)defSymbol).setSize(15.0);
            }
            this.getTemplSymbol().setSymbol(defSymbol);
            if (this.auxLegend.getBackgroundSymbol() != null) {
                this.getBtnBackground().setSymbol(this.auxLegend.getBackgroundSymbol());
            }
        } else {
            this.auxLegend = new ProportionalSymbolsLegend();
            this.auxLegend.setTemplateShapeType(this.templateShapeType);
            if (ProportionalSymbolsLegend.isLinear(this.templateShapeType)) {
                this.auxLegend.setDefaultSymbol(this.newSymbol(this.templateShapeType, 2.0));
            } else {
                this.auxLegend.setDefaultSymbol(this.newSymbol(this.templateShapeType, 15.0));
            }
            this.getTemplSymbol().setSymbol(this.auxLegend.getDefaultSymbol());
            if (ProportionalSymbolsLegend.isLinear(this.templateShapeType)) {
                this.txtMinSize.setDouble(3.0);
                this.txtMaxSize.setDouble(3.0);
            } else {
                this.txtMinSize.setDouble(10.0);
                this.txtMaxSize.setDouble(10.0);
            }
        }
    }

    public ILegend getLegend() {
        String[] fieldNames;
        ProportionalSymbolsLegend theLegend = new ProportionalSymbolsLegend();
        fieldNames = new String[]{this.cmbValue.getSelectedItem().toString(), !this.useNormalization ? fieldNames[0] : this.cmbNormalization.getSelectedItem().toString()};
        this.auxLegend.setTemplateShapeType(this.templateShapeType);
        this.auxLegend.setValueField(this.cmbValue.getSelectedItem().toString());
        this.auxLegend.setNormalizationField(this.cmbNormalization.getSelectedItem().toString());
        this.auxLegend.setUseNormalization(this.useNormalization);
        this.auxLegend.setMinSize(this.txtMinSize.getDouble());
        this.auxLegend.setMaxSize(this.txtMaxSize.getDouble());
        this.auxLegend.clear();
        ISymbol symbol = this.getTemplSymbol().getSymbol();
        symbol.setDescription(this.getSymbolDescription());
        this.auxLegend.setDefaultSymbol(symbol);
        this.auxLegend.setClassifyingFieldNames(fieldNames);
        FLyrVect vect = (FLyrVect)this.myLayer;
        FeatureStore fsto = null;
        FeatureType fty = null;
        Object atts = null;
        try {
            fsto = (FeatureStore)vect.getDataStore();
            fty = fsto.getDefaultFeatureType();
            int[] fieldTyp = new int[]{fty.getAttributeDescriptor(fieldNames[0]).getType(), fty.getAttributeDescriptor(fieldNames[1]).getType()};
            this.auxLegend.setClassifyingFieldTypes(fieldTyp);
            FeatureSet fset = fsto.getFeatureSet();
            DisposableIterator diter = fset.fastIterator();
            Feature fitem = null;
            double[] maxs = new double[fieldNames.length];
            double[] mins = new double[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                maxs[i] = -1.7976931348623157E308;
                mins[i] = Double.MAX_VALUE;
            }
            double aux_dob = 0.0;
            while (diter.hasNext()) {
                fitem = (Feature)diter.next();
                for (int i = 0; i < fieldNames.length; ++i) {
                    aux_dob = fitem.getDouble(fieldNames[i]);
                    if (aux_dob > maxs[i]) {
                        maxs[i] = aux_dob;
                    }
                    if (!(aux_dob < mins[i])) continue;
                    mins[i] = aux_dob;
                }
            }
            this.auxLegend.setMinFeature(mins[0]);
            this.auxLegend.setMaxFeature(maxs[0]);
        }
        catch (DataException e) {
            logger.info("Error while creating ProportionalSymbols legend", (Throwable)e);
            ApplicationLocator.getManager().message(Messages.getText((String)"_Error_while_creating_legend"), 0);
        }
        this.auxLegend.addSymbol(-1.7976931348623157E308, symbol);
        if (ProportionalSymbolsLegend.isPolygonal(this.templateShapeType)) {
            this.auxLegend.setBackgroundSymbol(this.getBtnBackground().getSymbol());
        }
        theLegend = (ProportionalSymbolsLegend)this.auxLegend.cloneLegend();
        return theLegend;
    }

    private String getSymbolDescription() {
        String description = "";
        if (this.cmbValue.getSelectedItem() != null) {
            description = description + this.cmbValue.getSelectedItem().toString();
        }
        if (this.cmbNormalization.getSelectedItem().toString().compareTo(this.noNormalization) != 0) {
            description = description + " / " + this.cmbNormalization.getSelectedItem().toString();
        }
        return description;
    }

    public String getDescription() {
        return Messages.getText((String)"draw_quantities_using_symbol_size_to_show_exact_values");
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"legend-overview-proportional-symbols");
    }

    public Class getParentClass() {
        return Quantities.class;
    }

    public String getTitle() {
        return Messages.getText((String)"proportional_symbols");
    }

    public Class getLegendClass() {
        return ProportionalSymbolsLegend.class;
    }

    public boolean isSuitableFor(FLayer layer) {
        if (layer instanceof FLyrVect) {
            FLyrVect lyr = (FLyrVect)layer;
            try {
                if (lyr.getShapeType() == 0) {
                    return false;
                }
                FeatureStore fsto = (FeatureStore)lyr.getDataStore();
                FeatureType fty = fsto.getDefaultFeatureType();
                FeatureAttributeDescriptor[] atts = fty.getAttributeDescriptors();
                for (int i = 0; i < atts.length; ++i) {
                    if (!atts[i].getDataType().isNumeric()) continue;
                    return true;
                }
            }
            catch (DataException e) {
                logger.info("Error in isSuitableFor", (Throwable)e);
                ApplicationLocator.getManager().message(Messages.getText((String)"_Error_while_checking_suitability"), 0);
                return false;
            }
        }
        return false;
    }

    public JPanel getPanel() {
        return this;
    }
}

