/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.simplehttpserver.commands;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.htmlbuilder.HTMLBuilder;
import org.gvsig.simplehttpserver.SimpleServer;
import org.gvsig.simplehttpserver.commands.AbstractCommand;
import org.gvsig.simplehttpserver.commands.Command;
import org.gvsig.simplehttpserver.commands.CommandFactory;
import org.gvsig.tools.util.ToolsUtilLocator;

public class Help
extends AbstractCommand {
    public Help(CommandFactory factory, SimpleServer server) {
        super(factory, server);
    }

    @Override
    public Object call(int argc, List<String> args, InputStream contents) {
        Map<String, Command> commands = this.getServer().getCommands();
        if (argc > 0 && StringUtils.equalsIgnoreCase((CharSequence)"asjson", (CharSequence)args.get(1))) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (Command command : commands.values()) {
                builder.add((JsonValue)this.getCommandDescription(command));
            }
            return builder.toString();
        }
        HTMLBuilder builder = ToolsUtilLocator.getToolsUtilManager().createHTMLBuilder();
        HTMLBuilder.HTMLComplexElement table = builder.table(0, 1, 4, builder.thead(builder.tr(builder.th("Return type"), builder.th("Name"), builder.th("Description"))));
        for (Command command : commands.values()) {
            HTMLBuilder.HTMLComplexElement tr = builder.tr("top").contents(builder.td(command.getMimeType()), builder.td(command.getName()), builder.td(builder.plainWithNl(command.getDescription() + "\n\n")));
            table.contents(tr);
        }
        return table.toHTML();
    }

    public JsonObject getCommandDescription(Command command) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Name", command.getName());
        builder.add("NumArgs", command.getNumArgs().toString());
        builder.add("MimeType", StringUtils.defaultString((String)command.getMimeType()));
        builder.add("Description", StringUtils.defaultString((String)command.getDescription()));
        return builder.build();
    }
}

