/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.annotation.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.annotation.AnnotationCreationException;
import org.gvsig.annotation.AnnotationCreationFinishAction;
import org.gvsig.annotation.AnnotationCreationService;
import org.gvsig.annotation.AnnotationDataTypes;
import org.gvsig.annotation.AnnotationManager;
import org.gvsig.annotation.calculator.AnnotationPositionCalculationException;
import org.gvsig.annotation.calculator.AnnotationPositionCalculator;
import org.gvsig.annotation.calculator.AnnotationPositionCalculatorCreationException;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationCreationService
extends AbstractMonitorableTask
implements AnnotationCreationService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAnnotationCreationService.class);
    private static final String TEMPLATE_NAME = "template.gvslab";
    private static DataManager dataManager = DALLocator.getDataManager();
    private AnnotationManager manager;
    private FeatureStore sourceStore;
    private int sourceFontTypeAttribute = -1;
    private int sourceFontStyleAttribute = -1;
    private int sourceFontColorAttribute = -1;
    private int sourceRotationAttribute = -1;
    private int sourceHeigthAttribute = -1;
    private AnnotationPositionCalculator annotationPositionCalculator = null;
    private String destinationGeometryAttributeName = null;
    private AnnotationCreationFinishAction annotationCreationFinishAction = null;

    public DefaultAnnotationCreationService(FeatureStore featureStore, AnnotationManager manager) throws DataException {
        super("annotation");
        this.sourceStore = featureStore;
        this.manager = manager;
        this.destinationGeometryAttributeName = featureStore.getDefaultFeatureType().getDefaultGeometryAttributeName();
    }

    public AnnotationManager getManager() {
        return this.manager;
    }

    public FeatureStore createAnnotationStore(String destinationShapeFile, int textValueAttribute) throws AnnotationCreationException {
        try {
            if (destinationShapeFile == null) {
                throw new AnnotationCreationException("File can not be null");
            }
            String destinationShapeFileWithoutExtension = destinationShapeFile.toLowerCase().replaceAll("\\.shp", "");
            destinationShapeFileWithoutExtension = destinationShapeFileWithoutExtension.length() == destinationShapeFile.length() - 4 ? destinationShapeFile.substring(0, destinationShapeFile.length() - 4) : destinationShapeFile;
            NewFeatureStoreParameters newFeatureStoreParameters = (NewFeatureStoreParameters)dataManager.createNewStoreParameters("FilesystemExplorer", "Shape");
            newFeatureStoreParameters.setDynValue("shpfile", (Object)(destinationShapeFileWithoutExtension + ".shp"));
            newFeatureStoreParameters.setDynValue("dbffile", (Object)(destinationShapeFileWithoutExtension + ".dbf"));
            newFeatureStoreParameters.setDynValue("shxfile", (Object)(destinationShapeFileWithoutExtension + ".shx"));
            newFeatureStoreParameters.setDynValue("crs", (Object)this.sourceStore.getDefaultFeatureType().getDefaultSRS());
            EditableFeatureType editableFeatureType = this.sourceStore.getDefaultFeatureType().getEditable();
            FeatureAttributeDescriptor[] featureAttributeDescriptors = editableFeatureType.getAttributeDescriptors();
            for (int i = featureAttributeDescriptors.length - 1; i >= 0; --i) {
                editableFeatureType.remove(i);
            }
            this.initializeFeatureType(editableFeatureType);
            newFeatureStoreParameters.setDefaultFeatureType((FeatureType)editableFeatureType);
            dataManager.newStore("FilesystemExplorer", "Shape", (NewDataStoreParameters)newFeatureStoreParameters, true);
            if (this.annotationPositionCalculator == null) {
                this.annotationPositionCalculator = this.manager.getDefaultAnnotationPositionCalculator();
            }
            FeatureStore destinationStore = (FeatureStore)dataManager.openStore("Shape", (DataStoreParameters)newFeatureStoreParameters);
            this.copyFeatureStore(this.sourceStore, destinationStore, textValueAttribute);
            try {
                this.copyLegend(destinationStore);
            }
            catch (IOException e) {
                LOG.error("Error copying the legend");
            }
            if (this.annotationCreationFinishAction != null) {
                this.annotationCreationFinishAction.finished(destinationStore);
            }
            return destinationStore;
        }
        catch (InitializeException e) {
            throw new AnnotationCreationException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new AnnotationCreationException((Throwable)e);
        }
        catch (ValidateDataParametersException e) {
            throw new AnnotationCreationException((Throwable)e);
        }
        catch (DynFieldNotFoundException e) {
            throw new AnnotationCreationException((Throwable)e);
        }
        catch (DataException e) {
            throw new AnnotationCreationException((Throwable)e);
        }
        catch (AnnotationPositionCalculatorCreationException e) {
            throw new AnnotationCreationException((Throwable)e);
        }
    }

    public FeatureStore createAnnotationStore(String destinationShapeFile, String textValueAttributeName) throws AnnotationCreationException {
        try {
            return this.createAnnotationStore(destinationShapeFile, this.getIndex(textValueAttributeName));
        }
        catch (DataException e) {
            throw new AnnotationCreationException((Throwable)e);
        }
    }

    private void initializeFeatureType(EditableFeatureType editableFeatureType) throws DataException {
        EditableFeatureAttributeDescriptor geometryType = editableFeatureType.add(this.destinationGeometryAttributeName, 66);
        geometryType.setAllowNull(false);
        geometryType.setGeometryType(1).setGeometrySubType(0);
        geometryType.setSRS(this.sourceStore.getDefaultFeatureType().getDefaultSRS());
        geometryType.setObjectClass(Geometry.class);
        editableFeatureType.setDefaultGeometryAttributeName(this.destinationGeometryAttributeName);
        editableFeatureType.add("Text", AnnotationDataTypes.TEXT, 256).setAllowNull(true);
        editableFeatureType.add("FontType", AnnotationDataTypes.FONTTYPE, 30).setAllowNull(true);
        editableFeatureType.add("FontStyle", AnnotationDataTypes.FONTSTYLE, 30).setAllowNull(true);
        editableFeatureType.add("FontColor", AnnotationDataTypes.FONTCOLOR, 20).setAllowNull(true);
        editableFeatureType.add("Rotation", AnnotationDataTypes.FONTROTATION, 5).setAllowNull(true);
        editableFeatureType.add("Heigth", AnnotationDataTypes.FONTHEIGHT, 5).setAllowNull(true);
    }

    private AttributeInserter createInserter(int attributePosition, Object defaultValue) {
        if (attributePosition > -1) {
            return new StoreAttributeInserter(attributePosition);
        }
        return new DefaultAttributeInserter(defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFeatureStore(FeatureStore sourceStore, FeatureStore destinationStore, int textAttribute) throws AnnotationCreationException, DataException {
        FeatureSet featureSet = null;
        DisposableIterator iterator = null;
        try {
            destinationStore.edit();
            featureSet = sourceStore.getFeatureSet();
            iterator = featureSet.fastIterator();
            this.taskStatus.setRangeOfValues(0L, featureSet.getSize());
            AttributeInserter fontTypeAttributeInserter = this.createInserter(this.sourceFontTypeAttribute, this.manager.getDefaultFontType());
            AttributeInserter fontStyleAttributeInserter = this.createInserter(this.sourceFontStyleAttribute, this.manager.getDefaultFontStyle());
            AttributeInserter fontColorAttributeInserter = this.createInserter(this.sourceFontColorAttribute, this.manager.getDefaultFontColor());
            AttributeInserter fontRotationAttributeInserter = this.createInserter(this.sourceRotationAttribute, this.manager.getDefaultFontRotation());
            AttributeInserter fontHeigthAttributeInserter = this.createInserter(this.sourceHeigthAttribute, this.manager.getDefaultFontHeight());
            long featureCount = 0L;
            while (iterator.hasNext()) {
                Feature sourceFeature = (Feature)iterator.next();
                EditableFeature destinationFeature = destinationStore.createNewFeature().getEditable();
                try {
                    destinationFeature.set(this.destinationGeometryAttributeName, (Object)this.annotationPositionCalculator.getAnnotationPosition(sourceFeature));
                }
                catch (AnnotationPositionCalculationException e) {
                    LOG.error("Not possible to get the point for the geometry", (Throwable)e);
                }
                String s = (String)sourceFeature.get(textAttribute);
                if (StringUtils.isEmpty((CharSequence)s)) {
                    s = this.getManager().getDefaultTextValue();
                }
                destinationFeature.set("Text", (Object)s);
                destinationFeature.set("FontType", fontTypeAttributeInserter.getValue(sourceFeature));
                destinationFeature.set("FontStyle", fontStyleAttributeInserter.getValue(sourceFeature));
                destinationFeature.set("FontColor", fontColorAttributeInserter.getValue(sourceFeature));
                destinationFeature.set("Rotation", fontRotationAttributeInserter.getValue(sourceFeature));
                destinationFeature.set("Heigth", fontHeigthAttributeInserter.getValue(sourceFeature));
                destinationStore.insert(destinationFeature);
                this.taskStatus.setCurValue(++featureCount);
                if (!this.taskStatus.isCancellationRequested()) continue;
                destinationStore.cancelEditing();
                this.taskStatus.cancel();
                return;
            }
        }
        finally {
            if (destinationStore.isEditing()) {
                destinationStore.finishEditing();
            }
            if (iterator != null) {
                iterator.dispose();
            }
            if (featureSet != null) {
                featureSet.dispose();
            }
            if (this.taskStatus.isRunning()) {
                this.taskStatus.terminate();
            }
        }
    }

    private void copyLegend(FeatureStore destinationStore) throws ValidateDataParametersException, DataException, IOException {
        int len;
        FilesystemServerExplorer filesystemServerExplorer = (FilesystemServerExplorer)destinationStore.getExplorer();
        File target = filesystemServerExplorer.getResourcePath((DataStore)destinationStore, "gvslab");
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(TEMPLATE_NAME);
        FileOutputStream out = null;
        out = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    private void checkAttribute(int index, int[] type) throws DataException {
        if (index >= this.sourceStore.getDefaultFeatureType().size()) {
            throw new IllegalArgumentException("Attribute not found");
        }
        int datatype = this.sourceStore.getDefaultFeatureType().getAttributeDescriptor(index).getDataType().getType();
        boolean validType = false;
        if (type != null) {
            for (int i = 0; i < type.length; ++i) {
                if (datatype != type[i]) continue;
                validType = true;
            }
        }
        if (!validType) {
            throw new IllegalArgumentException("The Attribute has not have the fine type");
        }
    }

    public void setFontTypeAttribute(int index) throws DataException {
        this.checkAttribute(index, new int[]{AnnotationDataTypes.FONTTYPE});
        this.sourceFontTypeAttribute = index;
    }

    public void setFontStyleAttribute(int index) throws DataException {
        this.checkAttribute(index, new int[]{AnnotationDataTypes.FONTSTYLE});
        this.sourceFontStyleAttribute = index;
    }

    public void setFontColorAttribute(int index) throws DataException {
        this.checkAttribute(index, new int[]{AnnotationDataTypes.FONTCOLOR});
        this.sourceFontColorAttribute = index;
    }

    public void setFontHeigthAttribute(int index) throws DataException {
        this.checkAttribute(index, new int[]{AnnotationDataTypes.FONTHEIGHT, 4, 5, 6});
        this.sourceHeigthAttribute = index;
    }

    public void setFontRotationAttribute(int index) throws DataException {
        this.checkAttribute(index, new int[]{AnnotationDataTypes.FONTROTATION});
        this.sourceRotationAttribute = index;
    }

    public void setAnnotationPositionCalculator(AnnotationPositionCalculator annotationPositionCalculator) {
        this.annotationPositionCalculator = annotationPositionCalculator;
    }

    public int getIndex(String attributeName) throws DataException {
        FeatureAttributeDescriptor featureAttributeDescriptor = this.sourceStore.getDefaultFeatureType().getAttributeDescriptor(attributeName);
        if (featureAttributeDescriptor != null) {
            return featureAttributeDescriptor.getIndex();
        }
        return -1;
    }

    public void setFontColorAttribute(String attributeName) throws DataException {
        this.setFontColorAttribute(this.getIndex(attributeName));
    }

    public void setFontHeigthAttribute(String attributeName) throws DataException {
        this.setFontHeigthAttribute(this.getIndex(attributeName));
    }

    public void setFontRotationAttribute(String attributeName) throws DataException {
        this.setFontRotationAttribute(this.getIndex(attributeName));
    }

    public void setFontStyleAttribute(String attributeName) throws DataException {
        this.setFontStyleAttribute(this.getIndex(attributeName));
    }

    public void setFontTypeAttribute(String attributeName) throws DataException {
        this.setFontTypeAttribute(this.getIndex(attributeName));
    }

    public FeatureStore getFeatureStore() {
        return this.sourceStore;
    }

    public AnnotationCreationFinishAction getAnnotationCreationFinishAction() {
        return this.annotationCreationFinishAction;
    }

    public void setAnnotationCreationFinishAction(AnnotationCreationFinishAction annotationCreationFinishAction) {
        this.annotationCreationFinishAction = annotationCreationFinishAction;
    }

    private class DefaultAttributeInserter
    implements AttributeInserter {
        private Object defaultValue = null;

        public DefaultAttributeInserter(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public Object getValue(Feature feature) {
            return this.defaultValue;
        }
    }

    private class StoreAttributeInserter
    implements AttributeInserter {
        private int attributePosition = -1;

        public StoreAttributeInserter(int attributePosition) {
            this.attributePosition = attributePosition;
        }

        @Override
        public Object getValue(Feature feature) {
            return feature.get(this.attributePosition);
        }
    }

    private static interface AttributeInserter {
        public Object getValue(Feature var1);
    }
}

