/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.jaxrpc.LocalJaxRpcServiceFactory;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;

public class JaxRpcPortClientInterceptor
extends LocalJaxRpcServiceFactory
implements MethodInterceptor,
InitializingBean {
    private Service jaxRpcService;
    private String portName;
    private String username;
    private String password;
    private String endpointAddress;
    private boolean maintainSession;
    private Properties customProperties;
    private Class serviceInterface;
    private Class portInterface;
    private boolean lookupServiceOnStartup = true;
    private QName portQName;
    private Remote portStub;
    static /* synthetic */ Class class$java$rmi$Remote;

    public void setJaxRpcService(Service jaxRpcService) {
        this.jaxRpcService = jaxRpcService;
    }

    public Service getJaxRpcService() {
        return this.jaxRpcService;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
    }

    public boolean isMaintainSession() {
        return this.maintainSession;
    }

    public void setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setPortInterface(Class portInterface) {
        if (!(portInterface == null || portInterface.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = JaxRpcPortClientInterceptor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(portInterface))) {
            throw new IllegalArgumentException("portInterface must be an interface derived from [java.rmi.Remote]");
        }
        this.portInterface = portInterface;
    }

    public Class getPortInterface() {
        return this.portInterface;
    }

    public void setLookupServiceOnStartup(boolean lookupServiceOnStartup) {
        this.lookupServiceOnStartup = lookupServiceOnStartup;
    }

    public void afterPropertiesSet() throws ServiceException {
        if (this.lookupServiceOnStartup) {
            this.prepare();
        }
    }

    public void prepare() throws ServiceException {
        Class actualInterface;
        if (this.portName == null) {
            throw new IllegalArgumentException("portName is required");
        }
        this.portQName = this.getQName(this.portName);
        if (this.jaxRpcService == null) {
            this.jaxRpcService = this.createJaxRpcService();
        } else {
            this.postProcessJaxRpcService(this.jaxRpcService);
        }
        Class clazz = actualInterface = this.portInterface != null ? this.portInterface : this.serviceInterface;
        if (actualInterface != null && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = JaxRpcPortClientInterceptor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(actualInterface) && !this.alwaysUseJaxRpcCall()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Creating JAX-RPC proxy for JAX-RPC port [" + this.portQName + "], using port interface [" + actualInterface.getName() + "]"));
            }
            Remote remoteObj = this.jaxRpcService.getPort(this.portQName, actualInterface);
            if (this.logger.isInfoEnabled() && this.serviceInterface != null) {
                boolean isImpl = this.serviceInterface.isInstance(remoteObj);
                this.logger.info((Object)("Using service interface [" + this.serviceInterface.getName() + "] for JAX-RPC port [" + this.portQName + "] - " + (!isImpl ? "not" : "") + " directly implemented"));
            }
            if (!(remoteObj instanceof Stub)) {
                throw new ServiceException("Port stub of class [" + remoteObj.getClass().getName() + "] is not a valid JAX-RPC stub: it does not implement interface [javax.xml.rpc.Stub]");
            }
            Stub stub = (Stub)remoteObj;
            this.preparePortStub(stub);
            this.postProcessPortStub(stub);
            this.portStub = remoteObj;
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Using JAX-RPC dynamic calls for JAX-RPC port [" + this.portQName + "]"));
        }
    }

    protected boolean isPrepared() {
        return this.portQName != null;
    }

    protected QName getPortQName() {
        return this.portQName;
    }

    protected boolean alwaysUseJaxRpcCall() {
        return false;
    }

    protected void preparePortStub(Stub stub) {
        if (this.username != null) {
            stub._setProperty("javax.xml.rpc.security.auth.username", (Object)this.username);
        }
        if (this.password != null) {
            stub._setProperty("javax.xml.rpc.security.auth.password", (Object)this.password);
        }
        if (this.endpointAddress != null) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.endpointAddress);
        }
        if (this.maintainSession) {
            stub._setProperty("javax.xml.rpc.session.maintain", (Object)Boolean.TRUE);
        }
        if (this.customProperties != null) {
            Enumeration<?> en = this.customProperties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                stub._setProperty(key, (Object)this.customProperties.getProperty(key));
            }
        }
    }

    protected void postProcessPortStub(Stub stub) {
    }

    protected Remote getPortStub() {
        return this.portStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Remote stub;
        if (AopUtils.isToStringMethod(invocation.getMethod())) {
            return "JAX-RPC proxy for port [" + this.getPortName() + "] of service [" + this.getServiceName() + "]";
        }
        if (!this.lookupServiceOnStartup) {
            JaxRpcPortClientInterceptor jaxRpcPortClientInterceptor = this;
            synchronized (jaxRpcPortClientInterceptor) {
                if (!this.isPrepared()) {
                    try {
                        this.prepare();
                    }
                    catch (ServiceException ex) {
                        throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), ex, this.portName);
                    }
                }
            }
        }
        if (!this.isPrepared()) {
            throw new IllegalStateException("JaxRpcClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        if ((stub = this.getPortStub()) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking operation '" + invocation.getMethod().getName() + "' on JAX-RPC port stub"));
            }
            return RmiClientInterceptorUtils.invoke(invocation, stub, this.getPortQName().toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking operation '" + invocation.getMethod().getName() + "' as JAX-RPC dynamic call"));
        }
        return this.performJaxRpcCall(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performJaxRpcCall(MethodInvocation invocation) throws Throwable {
        Service service = this.getJaxRpcService();
        QName portQName = this.getPortQName();
        Call call = null;
        Service service2 = service;
        synchronized (service2) {
            call = service.createCall(portQName, invocation.getMethod().getName());
        }
        this.prepareJaxRpcCall(call);
        this.postProcessJaxRpcCall(call, invocation);
        try {
            return call.invoke(invocation.getArguments());
        }
        catch (RemoteException ex) {
            throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), ex, portQName.toString());
        }
    }

    protected void prepareJaxRpcCall(Call call) {
        if (this.username != null) {
            call.setProperty("javax.xml.rpc.security.auth.username", (Object)this.username);
        }
        if (this.password != null) {
            call.setProperty("javax.xml.rpc.security.auth.password", (Object)this.password);
        }
        if (this.endpointAddress != null) {
            call.setTargetEndpointAddress(this.endpointAddress);
        }
        if (this.maintainSession) {
            call.setProperty("javax.xml.rpc.session.maintain", (Object)Boolean.TRUE);
        }
        if (this.customProperties != null) {
            Enumeration<?> en = this.customProperties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                call.setProperty(key, (Object)this.customProperties.getProperty(key));
            }
        }
    }

    protected void postProcessJaxRpcCall(Call call, MethodInvocation invocation) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

