/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.coverage.grid;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.GridCell;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.exception.OutOfGridException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.props.BasicStats;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.tools.dispose.Disposable;

public interface Grid
extends Disposable {
    public void applyFilters() throws ProcessInterruptedException, FilterAddException;

    public void loadWriterData() throws GridException;

    public Buffer getRasterBuf();

    public void setBandToOperate(int var1);

    public int getBandCount();

    public BasicStats getStatistics();

    public byte getCellValueAsByte(int var1, int var2) throws GridException;

    public short getCellValueAsShort(int var1, int var2) throws GridException;

    public int getCellValueAsInt(int var1, int var2) throws GridException;

    public float getCellValueAsFloat(int var1, int var2) throws GridException;

    public double getCellValueAsDouble(int var1, int var2) throws GridException;

    public void setInterpolationMethod(int var1);

    public boolean isNoDataValue(double var1);

    public GridExtent getGridExtent();

    public boolean isInGrid(int var1, int var2);

    public int getNX();

    public int getNY();

    public int getLayerNX();

    public int getLayerNY();

    public double getCellSize();

    public int getDataType();

    public NoData getNoDataValue();

    public ColorTable getPalette();

    public double getSlope(int var1, int var2) throws GridException;

    public double getAspect(int var1, int var2) throws GridException;

    public double getDistToNeighborInDir(int var1);

    public int getDirToNextDownslopeCell(int var1, int var2) throws GridException;

    public int getDirToNextDownslopeCell(int var1, int var2, boolean var3) throws GridException;

    public GridCell[] getSortedArrayOfCells() throws GridException;

    public void assign(byte var1) throws GridException;

    public void assign(short var1) throws GridException;

    public void assign(int var1) throws GridException;

    public void assign(float var1) throws GridException;

    public void assign(double var1) throws GridException;

    public void assign(Grid var1) throws GridException;

    public void addToCellValue(int var1, int var2, byte var3) throws GridException;

    public void addToCellValue(int var1, int var2, short var3) throws GridException;

    public void addToCellValue(int var1, int var2, int var3) throws GridException;

    public void addToCellValue(int var1, int var2, float var3) throws GridException;

    public void addToCellValue(int var1, int var2, double var3) throws GridException;

    public void assignNoData();

    public void setCellValue(int var1, int var2, byte var3) throws OutOfGridException;

    public void setCellValue(int var1, int var2, short var3) throws OutOfGridException;

    public void setCellValue(int var1, int var2, int var3) throws OutOfGridException;

    public void setCellValue(int var1, int var2, float var3) throws OutOfGridException;

    public void setCellValue(int var1, int var2, double var3) throws OutOfGridException;

    public void add(Grid var1) throws GridException;

    public void multiply(double var1) throws GridException;

    public void setNoDataValue(NoData var1);

    public void setNoData(int var1, int var2);

    public RasterFilterList getFilterList();

    public void setFilterList(RasterFilterList var1);

    public GridCell getGridCell(int var1, int var2) throws GridException;
}

