/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.coverage.grid.filter;

import java.util.Hashtable;
import java.util.TreeMap;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.BufferCreationException;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.process.TaskEventManager;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.tools.locator.LocatorException;

public abstract class BaseRasterFilter
implements RasterFilter,
Cloneable {
    public static final String PERSISTENT_NAME = "BaseRasterFilter";
    public static final String PERSISTENT_DESCRIPTION = "BaseRasterFilter Persistent";
    protected Buffer raster = null;
    protected Buffer rasterResult = null;
    protected int height = 0;
    protected int width = 0;
    protected Hashtable<String, Object> params = new Hashtable();
    protected TreeMap<String, Object> environment = new TreeMap();
    protected Extent extent = null;
    private int percent = 0;
    private String fName = "";
    protected boolean exec = true;
    protected RasterUtils util = null;
    protected TaskEventManager taskEventManager = null;
    protected String managername = null;
    protected Transparency transparency = null;
    private boolean hasInputTransparency = false;
    protected int nBandsToProcess = 0;
    protected ColorInterpretation colorInterpretation = null;
    private boolean argbOutput = false;

    public BaseRasterFilter() {
        if (RasterLocator.getManager() != null) {
            this.util = RasterLocator.getManager().getRasterUtils();
        }
    }

    @Override
    public void execute() throws ProcessInterruptedException, FilterAddException {
        this.taskEventManager = RasterLocator.getManager().createRasterTask(this);
        this.pre();
        if (this.raster != null && this.raster.getDataType() != this.getInRasterDataType()) {
            this.exec = false;
        }
        this.percent = 0;
        if (this.exec) {
            for (int row = 0; row < this.height; ++row) {
                for (int col = 0; col < this.width; ++col) {
                    try {
                        this.process(col, row);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                if (this.taskEventManager.getEvent() != null) {
                    this.taskEventManager.manageEvent(this.taskEventManager.getEvent());
                }
                this.percent = row * 100 / this.height;
            }
        }
        this.percent = 100;
        this.post();
    }

    @Override
    public void addParam(String name, Object param) {
        if (param != null) {
            this.params.put(name, param);
        } else {
            this.params.remove(name);
        }
    }

    public void removeParam(String name) {
        this.params.remove(name);
    }

    @Override
    public Object getParam(String name) {
        return this.params.get(name);
    }

    @Override
    public Hashtable<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setParams(Hashtable<String, Object> params) {
        this.params = params;
    }

    public void setExtent(Extent extent) {
        this.extent = extent;
    }

    @Override
    public boolean isToConvertToRGB() {
        return false;
    }

    public boolean isExec() {
        return this.exec;
    }

    public void setExec(boolean exec) {
        this.exec = exec;
    }

    public void resetPercent() {
        this.percent = 0;
    }

    public int getPercent() {
        return this.percent;
    }

    @Override
    public abstract void post();

    @Override
    public abstract void process(int var1, int var2);

    @Override
    public abstract int getInRasterDataType();

    @Override
    public abstract int getOutRasterDataType();

    @Override
    public Object getResult(String name) {
        if (name.equals("raster")) {
            if (this.exec) {
                return this.rasterResult;
            }
            return this.raster;
        }
        if (name.equals("transparency")) {
            if (this.transparency == null) {
                return null;
            }
            ColorInterpretation ci = null;
            if (this.rasterResult.getDataType() == 0) {
                if (this.argbOutput || this.rasterResult.getBandCount() == 4 && this.hasInputTransparency()) {
                    ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue", "Alpha"});
                    this.transparency.setColorInterpretation(ci);
                    this.transparency.activeTransparency();
                    return this.transparency;
                }
                if (this.rasterResult.getBandCount() == 3) {
                    ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue"});
                    this.transparency.setColorInterpretation(ci);
                    this.transparency.activeTransparency();
                    return this.transparency;
                }
                if (this.rasterResult.getBandCount() == 1) {
                    ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Gray"});
                    this.transparency.setColorInterpretation(ci);
                    this.transparency.activeTransparency();
                    return this.transparency;
                }
            }
            String[] values = new String[this.rasterResult.getBandCount()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = "Undefined";
            }
            ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(values);
            this.transparency.setColorInterpretation(ci);
            this.transparency.activeTransparency();
            return this.transparency;
        }
        return null;
    }

    @Override
    public abstract String getGroup();

    @Override
    public abstract Params getUIParams(String var1);

    @Override
    public abstract String[] getNames();

    @Override
    public boolean isVisible() {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public TreeMap<String, Object> getEnv() {
        return this.environment;
    }

    @Override
    public void setEnv(TreeMap<String, Object> env) {
        this.environment = env;
    }

    @Override
    public String getManagerName() {
        return this.managername;
    }

    public void dispose() {
    }

    protected Buffer getOutputBuffer() {
        return this.rasterResult;
    }

    protected Buffer getInputBuffer() {
        return this.raster;
    }

    protected void finalize() throws Throwable {
        this.rasterResult = null;
        this.raster = null;
        this.extent = null;
        this.fName = null;
        super.finalize();
    }

    @Override
    public void pre() throws FilterAddException {
        this.exec = true;
        this.raster = (Buffer)this.params.get("raster");
        this.transparency = (Transparency)this.environment.get("Transparency");
        this.height = this.raster.getHeight();
        this.width = this.raster.getWidth();
        if (this.raster != null && this.transparency != null && this.raster.getDataType() == 0 && this.transparency.existAlphaBand()) {
            this.nBandsToProcess = this.raster.getBandCount() - 1;
            this.hasInputTransparency = true;
        } else {
            this.nBandsToProcess = this.raster.getBandCount();
        }
    }

    protected void createARGBBufferResult() throws FilterAddException {
        BufferParam param = RasterLocator.getManager().getBufferFactory().createBufferParams(this.width, this.height, 4, 0, true);
        try {
            this.rasterResult = RasterLocator.getManager().getBufferFactory().createBuffer(param);
            if (this.raster != null) {
                this.rasterResult.setDataExtent(this.raster.getDataExtent());
            }
            this.argbOutput = true;
        }
        catch (LocatorException e) {
            throw new FilterAddException("Error creating buffer", (Exception)((Object)e));
        }
        catch (BufferCreationException e) {
            throw new FilterAddException("Error creating buffer", (Exception)((Object)e));
        }
    }

    protected void createBufferResult(int dataType, int bandCount) throws FilterAddException {
        BufferParam param = RasterLocator.getManager().getBufferFactory().createBufferParams(this.width, this.height, bandCount, dataType, true);
        try {
            this.rasterResult = RasterLocator.getManager().getBufferFactory().createBuffer(param);
            if (this.raster != null) {
                this.rasterResult.setDataExtent(this.raster.getDataExtent());
            }
        }
        catch (LocatorException e) {
            throw new FilterAddException("Error creating buffer", (Exception)((Object)e));
        }
        catch (BufferCreationException e) {
            throw new FilterAddException("Error creating buffer", (Exception)((Object)e));
        }
    }

    protected void writeAlphaBand(int line, int col) {
        if (this.hasInputTransparency) {
            this.rasterResult.setElem(line, col, this.rasterResult.getBandCount() - 1, this.raster.getElemByte(line, col, this.raster.getBandCount() - 1));
        }
    }

    protected boolean hasInputTransparency() {
        return this.hasInputTransparency;
    }

    protected int numberOfBandsToProcess() {
        return this.nBandsToProcess;
    }

    protected ColorInterpretation getColorInterpretation() {
        if (this.transparency != null) {
            return this.transparency.getColorInterpretation();
        }
        if (this.raster.getBandCount() >= 4) {
            return RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue", "Alpha"});
        }
        if (this.raster.getBandCount() == 3) {
            return RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue"});
        }
        return RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Gray"});
    }
}

