/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.coverage.util;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.List;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.roi.ROI;

public interface RasterUtils {
    public boolean loadInMemory(RasterDataStore var1);

    public boolean isBufferTooBig(double[] var1, int var2);

    public boolean isBufferTooBig(double[] var1, double var2, int var4);

    public int getRasterBufTypeFromMrSIDType(int var1);

    public int getBytesFromRasterBufType(int var1);

    public long getBytesFromRaster(int var1, int var2, int var3, int var4);

    public String typesToString(int var1);

    public String parserGdalProj(String var1);

    public Rectangle2D getPxRectFromMapRect(Rectangle2D var1, double var2, double var4, Rectangle2D var6);

    public Rectangle2D getMapRectFromPxRect(Rectangle2D var1, double var2, double var4, Rectangle2D var6);

    public Point2D worldPointToRaster(Point2D var1, Extent var2, int var3, int var4);

    public boolean intersects(Extent var1, Extent var2, AffineTransform var3) throws NoninvertibleTransformException;

    public Extent intersection(Extent var1, Extent var2);

    public boolean isInside(Point2D var1, Extent var2, AffineTransform var3);

    public boolean isInside(Extent var1, Extent var2);

    public boolean isInside(Point2D var1, Extent var2);

    public boolean isOutside(Extent var1, Extent var2);

    public boolean compareExtents(Extent var1, Extent var2);

    public double[] cornersToWorldFile(Point2D[] var1, Dimension var2);

    public void adjustToPixelSize(Point2D[] var1, Point2D var2);

    public String getTrace(Exception var1);

    public String formatTime(long var1);

    public String[] getCoord(double var1, double var3, double var5, double var7, int var9);

    public Extent calculateAdjustedView(Extent var1, AffineTransform var2, double var3, double var5);

    public void saveGeoInfo(String var1, AffineTransform var2, Point2D var3) throws IOException;

    public Extent calculateAdjustedView(Extent var1, Extent var2);

    public Extent getROIsMaximunExtent(List<ROI> var1);

    public BufferHistogram convertHistogramToRGB(BufferHistogram var1);

    public void copyToBuffer(Buffer var1, Extent var2, Buffer var3, Extent var4, double var5, boolean var7);
}

