/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.export.app.extension.ExportTable;
import org.gvsig.export.app.extension.FeatureStoreSearchExportAction;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class ExportTableExtension
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"table-export", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"storeaction", (String)"storeaction-export", (Object)((Object)this));
    }

    public void postInitialize() {
        super.postInitialize();
        FeatureStoreSearchExportAction.FeatureStoreSearchExportActionFactory.selfRegister();
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String command, Object[] args) {
        TableDocument tableDoc;
        ApplicationManager application = ApplicationLocator.getManager();
        Arguments arguments = Arguments.create((Object[])args);
        Object table = arguments.get(0, FLyrVect.class, null);
        WindowManager.MODE mode = WindowManager.MODE.WINDOW;
        if (table instanceof TableDocument) {
            tableDoc = (TableDocument)table;
            mode = WindowManager.MODE.fromInteger((int)((Integer)arguments.get(1, Integer.class, (Object)0)));
        } else {
            tableDoc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        }
        if (tableDoc == null) {
            return;
        }
        FeatureTableDocumentPanel tablePanel = (FeatureTableDocumentPanel)tableDoc.getMainComponent();
        ExportTable exportTable = new ExportTable();
        exportTable.showExport(tablePanel.getFeatureStore(), null, mode);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument tableDoc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        return tableDoc != null;
    }
}

