/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.app.extension;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gvsig.export.app.extension.ExportTable;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureStoreSearchExportAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureStoreSearchExportAction.class);
    private final DALActionFactory.DALActionContext context;

    public FeatureStoreSearchExportAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "Export");
        this.putValue("ShortDescription", i18n.getTranslation("_Export"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("storeaction-export"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WindowManager.MODE windowMode;
        if (!(this.context.getStore() instanceof FeatureStore)) {
            return;
        }
        ExportTable exportTable = new ExportTable();
        try {
            windowMode = (WindowManager.MODE)this.context.get("WindowMode");
        }
        catch (Throwable t) {
            windowMode = null;
        }
        FeatureStore store = (FeatureStore)this.context.getStore();
        Expression filterForSelecteds = this.context.getFilterForSelecteds();
        if (filterForSelecteds == null) {
            exportTable.showExport(store, this.context.getQuery(), windowMode);
        } else {
            FeatureQuery query = store.createFeatureQuery(filterForSelecteds);
            exportTable.showExport(store, query, windowMode);
        }
    }

    public static class FeatureStoreSearchExportActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "Export";

        public FeatureStoreSearchExportActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new FeatureStoreSearchExportAction(context);
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new FeatureStoreSearchExportActionFactory());
        }
    }
}

