/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.app.extension.preferences;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.app.extension.ExportPreferences;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.export.swing.ExportSwingLocator;
import org.gvsig.export.swing.ExportSwingManager;
import org.gvsig.export.swing.JExportConfigPanel;
import org.gvsig.i18n.Messages;

public class ExportPreferencesPage
extends AbstractPreferencePage {
    private static final long serialVersionUID = -5751805016601819817L;
    private final JExportConfigPanel config;

    public ExportPreferencesPage() {
        ExportSwingManager manager = ExportSwingLocator.getSwingManager();
        this.config = manager.createJExportConfigPanel();
        this.config.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExportPreferencesPage.this.setChanged(true);
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.config.asJComponent(), "Center");
    }

    public boolean isResizeable() {
        return true;
    }

    public String getID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getTitle() {
        return Messages.getText((String)"exportto_preferences");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        this.config.reset();
    }

    public void initializeDefaults() {
        this.config.reset();
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"export-to-preferences");
    }

    public boolean isValueChanged() {
        return this.hasChanged();
    }

    public void storeValues() throws StoreException {
        this.config.apply();
        List selecteds = this.config.getSelectedNames();
        ExportPreferences preferences = new ExportPreferences();
        ExportServiceManager manager = ExportLocator.getServiceManager();
        for (ExportServiceFactory factory : manager.getAllServiceFactories()) {
            if (selecteds.contains(factory.getName())) {
                preferences.setEnabled(factory.getName(), true);
                continue;
            }
            preferences.setEnabled(factory.getName(), false);
        }
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }
}

