/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.polyline;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.prov.polyline.PolylineEditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProvider;

public class PolygonEditingProvider
extends PolylineEditingProvider
implements EditingProvider {
    public PolygonEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices, parameters);
    }

    @Override
    public Geometry finish() throws FinishServiceException {
        try {
            GeometryType storeGeomType = this.editingProviderServices.getGeomType(this.featureStore);
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            Line line = this.calculatePolyline(null);
            if (line == null) {
                return null;
            }
            MultiPolygon polygons = line.toPolygons();
            if (storeGeomType.isTypeOf(9)) {
                return polygons;
            }
            return polygons.getPrimitiveAt(0);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "insert-polygon";
    }
}

