/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSShort
extends XSPatternBase {
    Short maxInclusive = null;
    Short maxExclusive = null;
    Short minInclusive = null;
    Short minExclusive = null;
    private static JType jType = JType.Short;
    private boolean _asWrapper = false;

    public XSShort() {
        this(false);
    }

    public XSShort(boolean asWrapper) {
        super((short)37);
        this._asWrapper = asWrapper;
        jType = asWrapper ? new JClass("java.lang.Short") : JType.Short;
    }

    public JType getJType() {
        return jType;
    }

    public Short getMaxExclusive() {
        return this.maxExclusive;
    }

    public Short getMaxInclusive() {
        return this.maxInclusive;
    }

    public Short getMinExclusive() {
        return this.minExclusive;
    }

    public Short getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(short max) {
        this.maxExclusive = new Short(max);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Short max) {
        this.maxExclusive = max;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(short max) {
        this.maxInclusive = new Short(max);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Short max) {
        this.maxInclusive = max;
        this.maxExclusive = null;
    }

    public void setMinExclusive(short min) {
        this.minExclusive = new Short(min);
        this.minInclusive = null;
    }

    public void setMinExclusive(Short min) {
        this.minExclusive = min;
        this.minInclusive = null;
    }

    public void setMinInclusive(short min) {
        this.minInclusive = new Short(min);
        this.minExclusive = null;
    }

    public void setMinInclusive(Short min) {
        this.minInclusive = min;
        this.minExclusive = null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSShort.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toShort());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toShort());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toShort());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toShort());
                continue;
            }
            if (!"pattern".equals(name)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("new java.lang.Short(");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Short)");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".shortValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        String pattern;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("ShortValidator typeValidator = new ShortValidator();");
        if (this.hasMinimum()) {
            Short min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(");
            }
            jsc.append("(short)");
            jsc.append(min.toString());
            jsc.append(");");
        }
        if (this.hasMaximum()) {
            Short max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(");
            }
            jsc.append("(short)");
            jsc.append(max.toString());
            jsc.append(");");
        }
        if (fixedValue != null) {
            Short.parseShort(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append("(short)");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        if ((pattern = this.getPattern()) != null) {
            jsc.add("typeValidator.setPattern(\"");
            jsc.append(XSShort.escapePattern(pattern));
            jsc.append("\");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

