/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.api.operations;

import java.util.List;

public class InvalidLookupParametersException
extends Exception {
    private static final long serialVersionUID = -3346605304349172330L;
    private List<Problem> problems;

    public InvalidLookupParametersException(List<Problem> problems) {
        this.setProblems(problems);
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    private void setProblems(List<Problem> problems) {
        this.problems = problems;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder("Problems to validate lookup parameters:\n");
        for (Problem problem : this.problems) {
            message.append("The parameter ");
            message.append(problem.parameterName);
            message.append("of the operation ");
            message.append(problem.operation);
            message.append(" can't be set because can't lookup the parameter ");
            message.append(problem.lookupParameterName);
            message.append(" .\n");
        }
        return message.toString();
    }

    public static class Problem {
        private final String operation;
        private final String parameterName;
        private final String lookupParameterName;

        public Problem(String operation, String parameterName, String lookupParameterName) {
            this.operation = operation;
            this.parameterName = parameterName;
            this.lookupParameterName = lookupParameterName;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getLookupParameterName() {
            return this.lookupParameterName;
        }
    }
}

