/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.ogr;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.GeomFieldDefn;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ReadRuntimeException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.file.FileResource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceManagerProviderServices;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorer;
import org.gvsig.fmap.dal.spi.DataServerExplorerProvider;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.gdal.prov.ogr.OGRConverter;
import org.gvsig.gdal.prov.ogr.OGRDataExplorerParameters;
import org.gvsig.gdal.prov.ogr.OGRDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRFetureSetProvider;
import org.gvsig.gdal.prov.ogr.OGRNewDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRResource;
import org.gvsig.gdal.prov.ogr.OGRUnsupportedFormatException;
import org.gvsig.tools.dynobject.DynField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OGRDataExplorer
extends AbstractDataServerExplorer
implements DataServerExplorerProvider,
ResourceConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OGRDataExplorer.class);
    public static final String NAME = "OGRDataExplorer";
    private DataServerExplorerProviderServices providerServives;
    protected OGRDataExplorerParameters parameters;
    private ResourceProvider resourceProvider;
    protected DataSource dataSource;
    protected Boolean updateSupport;
    private List<Layer> layerList;

    public OGRDataExplorer(OGRDataExplorerParameters parameters, DataServerExplorerProviderServices providerServices) throws InitializeException {
        super((DataServerExplorerParameters)parameters, providerServices);
        this.providerServives = providerServices;
        this.parameters = parameters;
        this.getResourceProvider().addConsumer((ResourceConsumer)this);
    }

    private ResourceProvider getResourceProvider() {
        if (this.resourceProvider == null) {
            ResourceManagerProviderServices manager = (ResourceManagerProviderServices)DALLocator.getResourceManager();
            if (StringUtils.isBlank((CharSequence)this.parameters.getConnectionString())) {
                try {
                    this.resourceProvider = (FileResource)manager.createAddResource("file", new Object[]{this.parameters.getFile().getAbsolutePath()});
                }
                catch (InitializeException e) {
                    throw new ReadRuntimeException(this.getProviderName(), (Throwable)e);
                }
            }
            try {
                this.resourceProvider = (OGRResource)manager.createAddResource("OGRResource", new Object[]{this.parameters.getConnectionString()});
            }
            catch (InitializeException e) {
                throw new ReadRuntimeException(this.getProviderName(), (Throwable)e);
            }
        }
        return this.resourceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected DataSource getDataSource() throws OGRUnsupportedFormatException {
        if (this.dataSource == null) {
            Class<OGRFetureSetProvider> clazz = OGRFetureSetProvider.class;
            // MONITORENTER : org.gvsig.gdal.prov.ogr.OGRFetureSetProvider.class
            if (StringUtils.isNotBlank((CharSequence)this.parameters.getConnectionString())) {
                this.dataSource = ogr.Open((String)this.parameters.getConnectionString(), (int)1);
                if (this.dataSource == null) {
                    this.dataSource = ogr.Open((String)this.parameters.getConnectionString());
                    this.updateSupport = false;
                } else {
                    this.updateSupport = true;
                }
            } else {
                if (this.parameters.getFile() == null) throw new IllegalStateException("Invalid parameters. Connection string must not be blank or file must exists");
                if (!this.parameters.getFile().exists()) throw new IllegalStateException("Invalid parameters. Connection string must not be blank or file must exists");
                this.dataSource = ogr.Open((String)this.parameters.getFile().getAbsolutePath(), (int)1);
                if (this.dataSource == null) {
                    this.dataSource = ogr.Open((String)this.parameters.getFile().getAbsolutePath());
                    this.updateSupport = false;
                } else {
                    this.updateSupport = true;
                }
            }
            // MONITOREXIT : clazz
        }
        if (this.dataSource != null) return this.dataSource;
        if (!StringUtils.isNotBlank((CharSequence)this.parameters.getConnectionString())) return this.dataSource;
        throw new OGRUnsupportedFormatException(this.parameters.getConnectionString());
    }

    protected List<Layer> getLayerList() {
        if (this.layerList == null) {
            this.layerList = (List)this.getResourceProvider().execute(new ResourceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    DataSource ds;
                    DataSource dataSource = ds = OGRDataExplorer.this.getDataSource();
                    synchronized (dataSource) {
                        ArrayList<Layer> layers = new ArrayList<Layer>();
                        for (int i = 0; i < ds.GetLayerCount(); ++i) {
                            layers.add(ds.GetLayer(i));
                        }
                        return layers;
                    }
                }
            });
        }
        return this.layerList;
    }

    private Boolean hasUpdateSupport() throws OGRUnsupportedFormatException {
        if (this.updateSupport == null) {
            this.getDataSource();
        }
        return this.updateSupport;
    }

    public String getProviderName() {
        return NAME;
    }

    public boolean canAdd() {
        return (Boolean)this.getResourceProvider().execute(new ResourceAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                DataSource ds;
                DataSource dataSource = ds = OGRDataExplorer.this.getDataSource();
                synchronized (dataSource) {
                    return ds.TestCapability("CreateLayer") && ds.TestCapability("DeleteLayer") && OGRDataExplorer.this.hasUpdateSupport() != false;
                }
            }
        });
    }

    public boolean canAdd(String storeName) throws DataException {
        return this.getDataStoreProviderNames().contains(storeName) && this.canAdd();
    }

    public List list() throws DataException {
        return this.list(0);
    }

    public List list(int mode) throws DataException {
        List<Layer> layerList = this.getLayerList();
        DataManager dataManager = DALLocator.getDataManager();
        ArrayList<OGRDataStoreParameters> parametersList = new ArrayList<OGRDataStoreParameters>();
        for (Layer layer : layerList) {
            OGRDataStoreParameters storeParameters = (OGRDataStoreParameters)dataManager.createStoreParameters("OGRDataStoreProvider");
            String connectionString = this.parameters.getConnectionString();
            File file = this.parameters.getFile();
            storeParameters.setConnectionString(connectionString);
            storeParameters.setFile(file);
            storeParameters.setLayerName(layer.GetName());
            parametersList.add(storeParameters);
        }
        return parametersList;
    }

    public boolean add(String provider, final NewDataStoreParameters parameters, final boolean overwrite) throws DataException {
        if (this.canAdd()) {
            return (Boolean)this.getResourceProvider().execute(new ResourceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    DataSource ds;
                    DataSource dataSource = ds = OGRDataExplorer.this.getDataSource();
                    synchronized (dataSource) {
                        if (parameters instanceof OGRNewDataStoreParameters) {
                            OGRNewDataStoreParameters ogrParameters = (OGRNewDataStoreParameters)parameters;
                            String layerName = ogrParameters.getLayerName();
                            if (overwrite) {
                                for (int i = 0; i < OGRDataExplorer.this.getLayerList().size(); ++i) {
                                    if (!OGRDataExplorer.this.getLayerList().get(i).GetName().equals(layerName)) continue;
                                    ds.DeleteLayer(i);
                                }
                            } else {
                                for (Layer layer : OGRDataExplorer.this.getLayerList()) {
                                    if (!layer.GetName().equals(layerName)) continue;
                                    return false;
                                }
                            }
                            EditableFeatureType editableFeatureType = ogrParameters.getDefaultFeatureType();
                            OGRConverter converter = new OGRConverter();
                            IProjection projection = editableFeatureType.getDefaultSRS();
                            SpatialReference srs = null;
                            if (projection != null) {
                                srs = new SpatialReference(projection.export("proj4"));
                            }
                            Integer ogrGeometryType = null;
                            if (editableFeatureType.getDefaultGeometryAttribute() != null) {
                                int geomType = editableFeatureType.getDefaultGeometryAttribute().getGeomType().getType();
                                ogrGeometryType = converter.convertToOGRGeomType(geomType);
                            }
                            Layer newlayer = srs == null ? ds.CreateLayer(layerName) : (ogrGeometryType == null ? ds.CreateLayer(layerName, srs) : ds.CreateLayer(layerName, srs, ogrGeometryType.intValue()));
                            List<FieldDefn> fields = converter.convertFields(editableFeatureType.getNotEditableCopy());
                            for (FieldDefn fieldDefn : fields) {
                                newlayer.CreateField(fieldDefn);
                            }
                            List<GeomFieldDefn> geometryFields = converter.convertGeometryFields(editableFeatureType.getNotEditableCopy(), false);
                            for (GeomFieldDefn geomFieldDefn : geometryFields) {
                                newlayer.CreateGeomField(geomFieldDefn);
                            }
                            return true;
                        }
                        return false;
                    }
                }
            });
        }
        return false;
    }

    public void remove(final DataStoreParameters parameters) throws DataException {
        if (this.canAdd()) {
            this.getResourceProvider().execute(new ResourceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    if (parameters instanceof OGRNewDataStoreParameters) {
                        DataSource ds;
                        DataSource dataSource = ds = OGRDataExplorer.this.getDataSource();
                        synchronized (dataSource) {
                            OGRNewDataStoreParameters ogrParameters = (OGRNewDataStoreParameters)parameters;
                            String layerName = ogrParameters.getLayerName();
                            for (int i = 0; i < OGRDataExplorer.this.getLayerList().size(); ++i) {
                                if (!OGRDataExplorer.this.getLayerList().get(i).GetName().equals(layerName)) continue;
                                ds.DeleteLayer(i);
                                return true;
                            }
                        }
                    }
                    return false;
                }
            });
        }
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        if (this.getDataStoreProviderNames().contains(storeName)) {
            OGRNewDataStoreParameters newParameters = new OGRNewDataStoreParameters();
            newParameters.setFile(this.parameters.getFile());
            newParameters.setConnectionString(this.parameters.getConnectionString());
            return newParameters;
        }
        return null;
    }

    public DataServerExplorerParameters getParameters() {
        return this.parameters;
    }

    public List getDataStoreProviderNames() {
        ArrayList<String> providerNames = new ArrayList<String>();
        providerNames.add("OGRDataStoreProvider");
        return providerNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDispose() {
        try {
            DataSource ds;
            DataSource dataSource = ds = this.getDataSource();
            synchronized (dataSource) {
                ds.SyncToDisk();
                ds.delete();
            }
        }
        catch (Exception e) {
            LOG.warn("Can not dispose OGRDataExplorer", (Throwable)e);
        }
        this.dataSource = null;
        this.layerList = null;
        this.getResourceProvider().removeConsumer((ResourceConsumer)this);
        this.resourceProvider = null;
    }

    public DataServerExplorerProviderServices getServerExplorerProviderServices() {
        return this.providerServives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeResourceRequested(ResourceProvider resource) {
        try {
            DataSource ds;
            DataSource dataSource = ds = this.getDataSource();
            synchronized (dataSource) {
                ds.SyncToDisk();
                ds.delete();
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("Can not close requested resource %1s", resource), (Throwable)e);
        }
        this.dataSource = null;
        this.layerList = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(ResourceProvider resource) {
        try {
            DataSource ds;
            DataSource dataSource = ds = this.getDataSource();
            synchronized (dataSource) {
                ds.SyncToDisk();
                ds.delete();
            }
        }
        catch (Exception e) {
            LOG.warn("Can not sync to disk or release native resources to reopen data source", (Throwable)e);
        }
        this.dataSource = null;
        this.layerList = null;
    }

    public DataStoreParameters get(String name) throws DataException {
        OGRDataStoreParameters params = new OGRDataStoreParameters();
        for (DynField field : params.getDynClass().getDynFields()) {
            String fieldName = field.getName();
            if (!this.parameters.hasDynValue(fieldName)) continue;
            params.setDynValue(fieldName, this.parameters.getDynValue(fieldName));
        }
        if (this.parameters.getFile().isDirectory()) {
            params.setFile(new File(this.parameters.getFile(), name));
        } else {
            params.setFile(new File(this.parameters.getFile().getParentFile(), name));
        }
        params.setLayerName(name);
        return params;
    }
}

