/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.ogr;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynStruct;

public class OGRDataStoreParameters
extends AbstractDataStoreParameters
implements OpenFeatureStoreParameters,
FilesystemStoreParameters {
    public static final String PARAMETERS_DEFINITION_NAME = "OGRDataStoreParameters";
    public static final String FILE_PARAMTER_NAME = "file";
    public static final String LAYER_NAME_PARAMTER_NAME = "layerName";
    public static final String CONNECTION_STRING_PARAMETER_NAME = "connectionString";
    public static final String DEFAULT_GEOMETRY_PARAMETER_NAME = "defaultGeometryField";
    public static final String CRS_PARAMETER_NAME = "crs";
    public static final String IGNORE_SPATIAL_FILTER = "ignoreSpatialFilter";
    protected DelegatedDynObject parameters;

    public OGRDataStoreParameters() {
        this(PARAMETERS_DEFINITION_NAME, "OGRDataStoreProvider");
    }

    public OGRDataStoreParameters(String parametersDefinitionName, String providerName) {
        DynStruct paramsDef = ToolsLocator.getPersistenceManager().getDefinition(parametersDefinitionName);
        this.parameters = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(paramsDef);
        this.setDynValue("ProviderName", providerName);
    }

    public String getDataStoreName() {
        return "OGRDataStoreProvider";
    }

    public String getDescription() {
        return "OGR provider to open vectorial resources";
    }

    public File getFile() {
        return (File)this.getDynValue(FILE_PARAMTER_NAME);
    }

    public String getLayerName() {
        return (String)this.getDynValue(LAYER_NAME_PARAMTER_NAME);
    }

    public String getConnectionString() {
        return (String)this.getDynValue(CONNECTION_STRING_PARAMETER_NAME);
    }

    public String getDefaultGeometryField() {
        return (String)this.getDynValue(DEFAULT_GEOMETRY_PARAMETER_NAME);
    }

    public IProjection getCRS() {
        return (IProjection)this.getDynValue(CRS_PARAMETER_NAME);
    }

    public void setFile(File file) {
        this.setDynValue(FILE_PARAMTER_NAME, file);
    }

    public void setLayerName(String layerName) {
        this.setDynValue(LAYER_NAME_PARAMTER_NAME, layerName);
    }

    public void setConnectionString(String connectionString) {
        this.setDynValue(CONNECTION_STRING_PARAMETER_NAME, connectionString);
    }

    public void setDefaultGeometryField(String defaultGeoemtryField) {
        this.setDynValue(DEFAULT_GEOMETRY_PARAMETER_NAME, defaultGeoemtryField);
    }

    public void setCRS(IProjection crs) {
        this.setDynValue(CRS_PARAMETER_NAME, crs);
    }

    public boolean isValid() {
        return this.getFile() != null && this.getFile().exists() || StringUtils.isNotBlank((CharSequence)this.getConnectionString());
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }
}

