/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.base.core;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalableUnionOperation
extends GeometryOperation {
    private static final Logger LOG = LoggerFactory.getLogger(ScalableUnionOperation.class);
    private Geometry geometry = null;

    public ScalableUnionOperation() {
        super(null);
    }

    public ScalableUnionOperation(AbstractSextanteGeoProcess p) {
        super(p);
    }

    @Override
    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature featureInput) {
        if (g == null) {
            return null;
        }
        if (g.getGeometryType().getType() != 3) {
            return null;
        }
        Geometry actualGeometry = GeometryUtil.geomToJTS(g);
        if (this.geometry == null) {
            this.geometry = actualGeometry;
        } else {
            Geometry[] geoms = new Geometry[]{this.geometry, actualGeometry};
            this.geometry = JTSFacade.union(geoms, g.getType());
        }
        return null;
    }

    @Override
    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature featureInput) {
        this.invoke(g, featureInput);
    }

    @Override
    public void setFeatureStore(FeatureStore out, String[] attrNames) throws DataException {
    }

    @Override
    public Object getResult() {
        return this.getGeometry();
    }

    private org.gvsig.fmap.geom.Geometry getGeometry() {
        return GeometryUtil.jtsToGeom(this.geometry);
    }

    private void union(org.gvsig.fmap.geom.Geometry g, int geometryType) {
        Date time1 = new Date();
        if (g == null) {
            return;
        }
        if (!g.getGeometryType().isTypeOf(3) && !g.getGeometryType().isTypeOf(9)) {
            return;
        }
        Geometry actualGeometry = GeometryUtil.geomToJTS(g);
        if (this.geometry == null) {
            this.geometry = actualGeometry;
        } else {
            Geometry[] geoms = new Geometry[]{this.geometry, actualGeometry};
            this.geometry = JTSFacade.union(geoms, geometryType);
        }
        Date time2 = new Date();
        LOG.info("scalableUnion time = " + (time2.getTime() - time1.getTime()) + " ms");
    }

    private void union(org.gvsig.fmap.geom.Geometry[] geoms) {
        Date time1 = new Date();
        if (geoms == null) {
            return;
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.geometry != null) {
            geometries.add(this.geometry);
        }
        for (int i = 0; i < geoms.length; ++i) {
            org.gvsig.fmap.geom.Geometry geom = geoms[i];
            if (!geom.getGeometryType().isTypeOf(3) && !geom.getGeometryType().isTypeOf(9)) continue;
            geometries.add(GeometryUtil.geomToJTS(geom));
        }
        this.geometry = JTSFacade.union(geometries.toArray(new Geometry[0]), 3);
        Date time2 = new Date();
        LOG.info("scalableUnion time = " + (time2.getTime() - time1.getTime()) + " ms");
    }

    public static org.gvsig.fmap.geom.Geometry joinLayerGeometries(IVectorLayer input, boolean selectedGeom) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        FeatureStore store = null;
        if (!(input instanceof FlyrVectIVectorLayer)) {
            return null;
        }
        store = ((FlyrVectIVectorLayer)input).getFeatureStore();
        return ScalableUnionOperation.joinLayerGeometries(store, selectedGeom);
    }

    public static org.gvsig.fmap.geom.Geometry joinLayerGeometries(FeatureStore store, boolean selectedGeom) throws WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        ScalableUnionOperation operation = new ScalableUnionOperation();
        FeatureSet features = null;
        try {
            features = selectedGeom ? (FeatureSet)store.getSelection() : store.getFeatureSet();
            DisposableIterator it = features.iterator();
            int i = 0;
            ArrayList<org.gvsig.fmap.geom.Geometry> geometries = new ArrayList<org.gvsig.fmap.geom.Geometry>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            while (it.hasNext()) {
                ++i;
                Feature feature = (Feature)it.next();
                List geomList = feature.getGeometries();
                if (geomList == null) {
                    org.gvsig.fmap.geom.Geometry geom = feature.getDefaultGeometry();
                    if (geom == null) continue;
                    geometries.add(geom);
                    types.add(geom.getType());
                    continue;
                }
                for (org.gvsig.fmap.geom.Geometry g : geomList) {
                    geometries.add(g);
                    types.add(g.getType());
                }
            }
            operation.union(geometries.toArray(new org.gvsig.fmap.geom.Geometry[0]));
            return operation.getGeometry();
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
    }
}

