/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.StyleTreeModel;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSLayerNode;

public class StyleTree
extends JTree {
    public boolean showLayerNames = false;

    public StyleTree() {
        this.initialize();
    }

    private void initialize() {
        this.setToggleClickCount(1);
        this.setRowHeight(22);
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (leaf) {
                    JPanel leafComponent = new JPanel();
                    leafComponent.setBackground(Color.WHITE);
                    JRadioButton leafRadioButton = new JRadioButton("", ((StyleTreeModel)StyleTree.this.getModel()).isSelected((RemoteWMSStyle)value));
                    leafRadioButton.setBackground(Color.WHITE);
                    leafComponent.add(leafRadioButton);
                    leafComponent.add(new JLabel(((RemoteWMSStyle)value).getTitle()));
                    return leafComponent;
                }
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof WMSLayerNode) {
                    WMSLayerNode layer = (WMSLayerNode)value;
                    if (!(StyleTree.this.showLayerNames || layer.getName() == null && layer.getName() != "")) {
                        String text = layer.toString();
                        text = text.substring(text.indexOf(93) + 2, text.length());
                        this.setText(text);
                    }
                }
                return this;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((StyleTreeModel)StyleTree.this.getModel()).setSelectedLeaf(StyleTree.this.getSelectionPath());
                StyleTree.this.clearSelection();
                StyleTree.this.repaint();
            }
        });
    }

    public void expandAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    public Vector getStyleSelectionTitles() {
        if (this.getModel() instanceof StyleTreeModel) {
            return ((StyleTreeModel)this.getModel()).getStyleSelectionTitles();
        }
        return null;
    }

    public void initSelections(Vector styleNames) {
        if (styleNames != null) {
            StyleTreeModel model = (StyleTreeModel)this.getModel();
            model.setStylesSelection(styleNames);
        }
    }
}

