/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.wizards.FormatListModel;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.gui.beans.controls.dnd.JDnDListModel;
import org.gvsig.gui.beans.listeners.BeanListener;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.DimensionPanel;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.InfoPanel;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.LayerList;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.LayerTree;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.StyleTree;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.StyleTreeModel;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.StylesPanel;
import org.gvsig.raster.wms.app.wmsclient.gui.wizard.LayerTreeModel;
import org.gvsig.raster.wms.app.wmsclient.gui.wizard.SRSListModel;
import org.gvsig.raster.wms.app.wmsclient.layer.FLyrWMS;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSLayerNode;
import org.gvsig.raster.wms.io.WMSServerExplorer;
import org.gvsig.raster.wms.io.WMSServerExplorerParameters;
import org.gvsig.raster.wms.io.time.RemoteTimeDimension;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;

public class WMSParamsPanel
extends WizardPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane1 = null;
    private JScrollPane jScrollPane2 = null;
    private JScrollPane jScrollPane3 = null;
    private JScrollPane selectedLayersJScrollPaneJScrollPane = null;
    private JButton btnAdd = null;
    private JButton btnDel = null;
    private JScrollPane jScrollPane6 = null;
    private JPanel layersJPanel = null;
    private JPanel tabFormats = null;
    private JPanel jPanel4 = null;
    private JTextField jTxtNomCapa = null;
    private LayerList lstSelectedLayers = null;
    private ArrayList<TreePath> selectedPaths = new ArrayList();
    private JList lstSRSs = null;
    private JList lstInfoFormats = null;
    private LayerTree treeLayers = null;
    private JList lstFormats = null;
    private WizardListenerSupport listenerSupport;
    private JTabbedPane jTabbedPane = null;
    private JPanel tabLayers = null;
    private JPanel jPanelFormats = null;
    private JPanel jPanelAxisOrder = null;
    private JPanel jPanelSrsSelection = null;
    private JPanel jPanelInfoByPointFormat = null;
    private StylesPanel tabStyle = null;
    private JCheckBox chkTransparency = null;
    private JCheckBox chkAxisOrder = null;
    private InfoPanel tabInfo = null;
    private DimensionPanel tabDimensions = null;
    private int dimensionTabIndex;
    private int stylesTabIndex;
    private String oldSRS = null;
    private AbstractCollection oldDimensions = null;
    private Dimension sizeFixed;
    private JCheckBox chkExtendedNames = null;
    private JButton btnUp = null;
    private JButton btnDown = null;
    protected WMSServerExplorer explorer = null;
    private boolean updating = fPrefs.getBoolean("refresh_capabilities", false);
    public static Preferences fPrefs = Preferences.userRoot().node("gvsig.wms-wizard");
    private JCheckBox chkDisagregate = null;
    private boolean lastCached;
    private String groupName = "WMS Group";
    private JButton btnSrsToView;

    public WMSParamsPanel() {
        this.initialize();
    }

    public WMSParamsPanel(WMSServerExplorer data) {
        this.setWizardData(data);
        this.initialize();
        this.setListenerSupport(new WizardListenerSupport());
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this.add(this.getJTabbedPane(), "Center");
        ToolsSwingUtils.ensureRowsCols((JComponent)((Object)this), (int)20, (int)100, (int)40, (int)200);
    }

    public boolean isUpdatingCache() {
        return this.updating;
    }

    public void setUpdatingCache(boolean updating) {
        this.updating = updating;
    }

    private JPanel getLayersJPanel() {
        if (this.layersJPanel == null) {
            this.layersJPanel = new JPanel();
            this.layersJPanel.setLayout(new GridBagLayout());
            this.layersJPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"select_layers"), 0, 0, null, null));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.layersJPanel.add((Component)this.getTreeLayersJScrollPane(), c);
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 1;
            c.gridwidth = 1;
            c.gridheight = 4;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.layersJPanel.add((Component)this.getSelectedLayersJScrollPane(), c);
            c.gridx = 1;
            c.gridy = 1;
            c.fill = 0;
            c.anchor = 15;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.layersJPanel.add((Component)this.getBtnAdd(), c);
            c.gridx = 1;
            c.gridy = 2;
            c.fill = 0;
            c.anchor = 11;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.layersJPanel.add((Component)this.getBtnDel(), c);
            c.gridx = 1;
            c.gridy = 3;
            c.fill = 0;
            c.anchor = 15;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.layersJPanel.add((Component)this.getBtnUp(), c);
            c.gridx = 1;
            c.gridy = 4;
            c.fill = 0;
            c.anchor = 11;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.layersJPanel.add((Component)this.getBtnDown(), c);
            c.gridx = 0;
            c.gridy = 5;
            c.fill = 1;
            c.anchor = 17;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.layersJPanel.add((Component)this.getChkDisagregate(), c);
            c.gridx = 0;
            c.gridy = 6;
            c.fill = 1;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.layersJPanel.add((Component)this.getChkExtendedNames(), c);
        }
        return this.layersJPanel;
    }

    private JPanel getJPanelLayerName() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"layer_name"), 0, 0, null, null));
            this.jPanel4.add((Component)this.getJTxtNomCapa(), "Center");
        }
        return this.jPanel4;
    }

    private JPanel getTabFormats() {
        if (this.tabFormats == null) {
            this.tabFormats = new JPanel();
            BorderLayout bl = new BorderLayout();
            this.tabFormats.setLayout(bl);
            this.tabFormats.add((Component)this.getJPanelFormats(), "North");
            this.tabFormats.add((Component)this.getJPanelSrsSelection(), "Center");
            this.tabFormats.add((Component)this.getJPanelInfoByPointFormat(), "South");
        }
        return this.tabFormats;
    }

    private JScrollPane getTreeLayersJScrollPane() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getTreeLayers());
            this.jScrollPane1.setPreferredSize(new Dimension(205, 75));
        }
        return this.jScrollPane1;
    }

    private JButton getBtnDel() {
        if (this.btnDel == null) {
            this.btnDel = new JButton();
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnDel, (String)"_Delete_layer", (String)"common-remove", e -> this.delLayer(), null);
        }
        return this.btnDel;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnAdd, (String)"_Add_layer", (String)"common-add", e -> this.addLayer(), null);
        }
        return this.btnAdd;
    }

    private JScrollPane getSelectedLayersJScrollPane() {
        if (this.selectedLayersJScrollPaneJScrollPane == null) {
            this.selectedLayersJScrollPaneJScrollPane = new JScrollPane();
            this.selectedLayersJScrollPaneJScrollPane.setViewportView((Component)((Object)this.getLstSelectedLayers()));
            this.selectedLayersJScrollPaneJScrollPane.setPreferredSize(new Dimension(205, 75));
        }
        return this.selectedLayersJScrollPaneJScrollPane;
    }

    private JTextField getJTxtNomCapa() {
        if (this.jTxtNomCapa == null) {
            this.jTxtNomCapa = new JTextField();
            this.jTxtNomCapa.setText(PluginServices.getText((Object)((Object)this), (String)"WMSLayer"));
            this.jTxtNomCapa.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
        }
        return this.jTxtNomCapa;
    }

    private JPanel getJPanelFormats() {
        if (this.jPanelFormats == null) {
            this.jPanelFormats = new JPanel();
            this.jPanelFormats.setLayout(new BorderLayout());
            this.jPanelFormats.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"select_formats"), 0, 0, null, null));
            this.jPanelFormats.add((Component)this.getJScrollPaneFormats(), "Center");
            this.jPanelFormats.add((Component)this.getChkTransparency(), "South");
        }
        return this.jPanelFormats;
    }

    private JPanel getJPanelSrsSelection() {
        if (this.jPanelSrsSelection == null) {
            this.jPanelSrsSelection = new JPanel();
            this.jPanelSrsSelection.setLayout(new BorderLayout());
            this.jPanelSrsSelection.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"seleccionar_srs"), 0, 0, null, null));
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            JTextField txtFilter = new JTextField();
            JButton btnFilter = new JButton();
            panel.add((Component)txtFilter, c);
            c.gridx = 1;
            c.weightx = 0.0;
            panel.add((Component)btnFilter, c);
            c.gridx = 2;
            panel.add((Component)this.getBtnSrsToView(), c);
            this.jPanelSrsSelection.add((Component)panel, "North");
            this.jPanelSrsSelection.add((Component)this.getJScrollPane2(), "Center");
            ToolsSwingLocator.getToolsSwingManager().createFilteredListController(this.lstSRSs, (JTextComponent)txtFilter, btnFilter);
        }
        return this.jPanelSrsSelection;
    }

    private JPanel getJPanelInfoByPointFormat() {
        if (this.jPanelInfoByPointFormat == null) {
            this.jPanelInfoByPointFormat = new JPanel();
            this.jPanelInfoByPointFormat.setLayout(new BorderLayout());
            this.jPanelInfoByPointFormat.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"seleccionar_infobypoint_format"), 0, 0, null, null));
            this.jPanelInfoByPointFormat.add((Component)this.getInfoFormatsJScrollPane(), "Center");
        }
        return this.jPanelInfoByPointFormat;
    }

    private JScrollPane getJScrollPaneFormats() {
        if (this.jScrollPane6 == null) {
            this.jScrollPane6 = new JScrollPane();
            this.jScrollPane6.setViewportView(this.getLstFormats());
            this.jScrollPane6.setPreferredSize(new Dimension(250, 85));
        }
        return this.jScrollPane6;
    }

    private JCheckBox getChkTransparency() {
        if (this.chkTransparency == null) {
            this.chkTransparency = new JCheckBox();
            this.chkTransparency.setText(PluginServices.getText((Object)((Object)this), (String)"wms_transparency"));
            this.chkTransparency.setSelected(true);
            this.chkTransparency.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
            this.chkTransparency.setVisible(true);
        }
        return this.chkTransparency;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getLstSRSs());
            this.jScrollPane2.setPreferredSize(new Dimension(250, 91));
        }
        return this.jScrollPane2;
    }

    private JScrollPane getInfoFormatsJScrollPane() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setViewportView(this.getLstInfoFormats());
            this.jScrollPane3.setPreferredSize(new Dimension(250, 120));
        }
        return this.jScrollPane3;
    }

    public LayerTree getLayerStructure() {
        return this.treeLayers;
    }

    private LayerTree getTreeLayers() {
        if (this.treeLayers == null) {
            this.treeLayers = new LayerTree();
            this.treeLayers.setRootVisible(true);
            this.treeLayers.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        WMSParamsPanel.this.addLayer();
                    }
                }
            });
            this.treeLayers.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    boolean isGetMapable = false;
                    TreePath[] selecciones = WMSParamsPanel.this.getTreeLayers().getSelectionPaths();
                    if (selecciones != null) {
                        for (int i = 0; i < selecciones.length && !isGetMapable; ++i) {
                            WMSLayerNode layer = (WMSLayerNode)selecciones[i].getLastPathComponent();
                            isGetMapable = layer.getChildren().size() == 0 || layer.getName() != null;
                        }
                    }
                    WMSParamsPanel.this.getBtnAdd().setEnabled(isGetMapable);
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
        }
        return this.treeLayers;
    }

    public boolean isCorrectlyConfigured() {
        this.repaint();
        boolean infoFormatOk = this.getLstInfoFormats().getModel().getSize() != 0 && this.getLstInfoFormats().getSelectedIndex() != -1 || this.getLstInfoFormats().getModel().getSize() == 0;
        boolean b = this.getLstSRSs().getSelectedIndex() != -1 && this.getLstFormats().getSelectedIndex() != -1 && infoFormatOk && this.getLstSelectedLayers().getModel().getSize() > 0;
        int[] selectedIndices = this.getLstSelectedLayers().getSelectedIndices();
        this.getBtnDel().setEnabled(selectedIndices != null && selectedIndices.length > 0);
        return b;
    }

    public WMSLayerNode[] selectedLayersToArray() {
        JDnDListModel modelo = (JDnDListModel)this.lstSelectedLayers.getModel();
        ArrayList elements = modelo.getElements();
        WMSLayerNode[] layers = elements.toArray(new WMSLayerNode[0]);
        return layers;
    }

    private void delLayer() {
        int[] indices = this.lstSelectedLayers.getSelectedIndices();
        try {
            ArrayList<WMSLayerNode> removeList = new ArrayList<WMSLayerNode>();
            WMSLayerNode[] infos = this.selectedLayersToArray();
            JDnDListModel modelo = (JDnDListModel)this.lstSelectedLayers.getModel();
            for (int i = 0; i < indices.length; ++i) {
                removeList.add(infos[indices[i]]);
            }
            modelo.delIndices(indices);
            this.lstSelectedLayers.clearSelection();
            this.fireWizardComplete(this.isCorrectlyConfigured());
            WMSLayerNode elemento = null;
            WMSLayerNode last = null;
            TreePath path = null;
            for (int i = removeList.size() - 1; i >= 0; --i) {
                elemento = (WMSLayerNode)removeList.get(i);
                for (int j = 0; j < this.selectedPaths.size(); ++j) {
                    path = this.selectedPaths.get(j);
                    last = (WMSLayerNode)path.getLastPathComponent();
                    if (last.getTitle().compareTo(elemento.getTitle()) != 0) continue;
                    this.selectedPaths.remove(path);
                }
            }
            this.refreshData();
            this.refreshInfo();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    private void fireWizardComplete(boolean b) {
        this.listenerSupport.callStateChanged(b);
        this.callStateChanged(b);
    }

    public void refreshData() {
        JDnDListModel model = (JDnDListModel)this.lstSelectedLayers.getModel();
        if (model.getSize() > 1) {
            this.setLayerName(this.groupName);
        } else if (model.getSize() == 1) {
            this.setLayerName(model.getElementAt(0).toString());
        } else {
            this.setLayerName(PluginServices.getText((Object)((Object)this), (String)"WMSLayer"));
        }
        this.refreshSRS();
        this.getLstSelectedLayers().repaint();
        this.refreshStyleTree();
        this.refreshDimensions();
    }

    public void refreshInfo() {
        this.getTabInfo().refresh(this.explorer, this.selectedLayersVector(), this.getStyleTitles(), this.getFormat(), this.getInfoFormat(), this.getSRS(), this.getDimensions());
    }

    private void refreshDimensions() {
        int size = this.getLstSelectedLayers().getModel().getSize();
        boolean enable = false;
        for (int i = 0; i < size; ++i) {
            WMSLayerNode node = (WMSLayerNode)this.getLstSelectedLayers().getModel().getElementAt(i);
            if (node.getDimensions() == null) continue;
            for (int j = 0; j < node.getDimensions().size(); ++j) {
                RemoteTimeDimension dim = (RemoteTimeDimension)node.getDimensions().get(j);
                try {
                    this.getTabDimensions().addDimension(dim);
                    enable = true;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    NotificationManager.addWarning((String)("Unrecognized dimension expression: " + dim.getExpression() + " (for " + dim.getName() + " in layer '" + node.getName() + "')"), null);
                }
            }
        }
        this.jTabbedPane.setEnabledAt(this.dimensionTabIndex, enable);
    }

    private void refreshStyleTree() {
        int size = this.getLstSelectedLayers().getModel().getSize();
        WMSLayerNode styleRoot = new WMSLayerNode();
        styleRoot.setTitle(PluginServices.getText((Object)((Object)this), (String)"selected_layers"));
        StyleTreeModel model = new StyleTreeModel(styleRoot);
        this.jTabbedPane.setEnabledAt(this.stylesTabIndex, false);
        for (int i = 0; i < size; ++i) {
            WMSLayerNode node = (WMSLayerNode)this.getLstSelectedLayers().getModel().getElementAt(i);
            if (!model.addLayerBranch(node)) continue;
            this.jTabbedPane.setEnabledAt(this.stylesTabIndex, true);
        }
        this.getStyleTree().setModel(model);
        this.getStyleTree().expandAll();
        this.getStyleTree().repaint();
    }

    public void setStyleSelections(List<RemoteWMSStyle> styles) {
        WMSLayerNode[] layers = this.selectedLayersToArray();
        int length = layers.length;
        for (int i = 0; i < length; ++i) {
            String styleName = styles.get(i).getName();
            layers[length - i - 1].setSelectedStyleByName(styleName);
        }
    }

    private StyleTree getStyleTree() {
        return this.getTabStyle().getStyleTree();
    }

    public void addLayer() {
        boolean alguno = false;
        TreePath[] selecciones = this.getTreeLayers().getSelectionPaths();
        if (selecciones == null) {
            return;
        }
        for (int i = 0; i < selecciones.length; ++i) {
            this.selectedPaths.add(selecciones[i]);
            WMSLayerNode nodo = (WMSLayerNode)selecciones[i].getLastPathComponent();
            if (nodo.getName() == null || nodo.getName().equals("")) continue;
            if (nodo.isSizeFixed()) {
                if (this.sizeFixed == null) {
                    this.sizeFixed = nodo.getFixedSize();
                } else if (this.sizeFixed.getHeight() != nodo.getFixedSize().getHeight() || this.sizeFixed.getWidth() != nodo.getFixedSize().getWidth()) {
                    JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)((Object)this), (String)"server_cant_render_layers"));
                    continue;
                }
            }
            JDnDListModel modelo = (JDnDListModel)this.lstSelectedLayers.getModel();
            try {
                if (!modelo.addElement(modelo.getSize(), nodo.clone())) continue;
                alguno = true;
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if (alguno) {
            this.refreshData();
        }
        this.refreshInfo();
    }

    public LayerList getLstSelectedLayers() {
        if (this.lstSelectedLayers == null) {
            this.lstSelectedLayers = new LayerList();
            this.lstSelectedLayers.setModel((ListModel)new JDnDListModel());
            this.lstSelectedLayers.setSelectionMode(2);
            this.lstSelectedLayers.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
            this.lstSelectedLayers.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    WMSParamsPanel.this.refreshData();
                }
            });
        }
        return this.lstSelectedLayers;
    }

    public JList getLstSRSs() {
        if (this.lstSRSs == null) {
            this.lstSRSs = new JList();
            this.lstSRSs.setModel(new SRSListModel());
            this.lstSRSs.setSelectionMode(0);
            this.lstSRSs.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int i = WMSParamsPanel.this.lstSRSs.getSelectedIndex();
                    if (i != -1) {
                        WMSParamsPanel.this.oldSRS = Objects.toString(WMSParamsPanel.this.lstSRSs.getModel().getElementAt(i), null);
                    }
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
        }
        return this.lstSRSs;
    }

    public JList getLstInfoFormats() {
        if (this.lstInfoFormats == null) {
            this.lstInfoFormats = new JList();
            this.lstInfoFormats.setModel(new SRSListModel());
            this.lstInfoFormats.setSelectionMode(0);
            this.lstInfoFormats.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
        }
        return this.lstInfoFormats;
    }

    public JList getLstFormats() {
        if (this.lstFormats == null) {
            this.lstFormats = new JList();
            this.lstFormats.setSelectionMode(0);
            this.lstFormats.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
        }
        return this.lstFormats;
    }

    private void refreshSRS() {
        ArrayList elements = ((JDnDListModel)this.lstSelectedLayers.getModel()).getElements();
        WMSLayerNode[] layers = elements.toArray(new WMSLayerNode[0]);
        SRSList srsList = new SRSList();
        if (layers.length == 0) {
            this.sizeFixed = null;
        } else {
            TreeSet<String> srsSet = new TreeSet<String>();
            srsSet.addAll(layers[0].getAllSrs());
            srsList.setAll(srsSet);
            for (int i = 1; i < layers.length; ++i) {
                srsList.setAll(srsList.intersect(layers[i].getAllSrs()));
            }
        }
        FilteredListModel model = ToolsSwingLocator.getToolsSwingManager().createFilteredListModel();
        for (String str : srsList) {
            model.addElement((Object)str);
        }
        this.lstSRSs.setModel(model);
        int srsIndex = this.getSRSIndex(this.oldSRS);
        if (srsIndex != -1) {
            this.getLstSRSs().setSelectedIndex(srsIndex);
        }
    }

    public void setListenerSupport(WizardListenerSupport support) {
        this.listenerSupport = support;
    }

    public void setWizardData(WMSServerExplorer data) {
        this.explorer = data;
        ((JDnDListModel)this.getLstSelectedLayers().getModel()).clear();
        this.getLstSelectedLayers().repaint();
        this.getLstFormats().setModel(new FormatListModel(this.explorer.getFormats()));
        this.getLstInfoFormats().setModel(new FormatListModel(this.explorer.getInfoFormats()));
        this.getTreeLayers().setModel(new LayerTreeModel(this.explorer.getLayerTree()));
        this.refreshInfo();
    }

    private Vector getStyleTitles() {
        return this.getTabStyle().getStyleTree().getStyleSelectionTitles();
    }

    private Vector selectedLayersVector() {
        JDnDListModel mod = (JDnDListModel)this.getLstSelectedLayers().getModel();
        Vector<Object> lyrs = new Vector<Object>();
        for (int i = 0; i < mod.getSize(); ++i) {
            lyrs.add(mod.getElementAt(i));
        }
        return lyrs;
    }

    public String getFormat() {
        return (String)this.getLstFormats().getSelectedValue();
    }

    public String getInfoFormat() {
        return (String)this.getLstInfoFormats().getSelectedValue();
    }

    public String getLayersQuery() {
        ArrayList elements = ((JDnDListModel)this.getLstSelectedLayers().getModel()).getElements();
        WMSLayerNode[] layers = elements.toArray(new WMSLayerNode[0]);
        String layersQuery = layers[layers.length - 1].getName();
        for (int i = layers.length - 2; i >= 0; --i) {
            layersQuery = layersQuery + "," + layers[i].getName();
        }
        return layersQuery;
    }

    public String getSRS() {
        return Objects.toString(this.getLstSRSs().getSelectedValue(), null);
    }

    public String getLayerName() {
        return this.getJTxtNomCapa().getText();
    }

    public void setLayerName(String name) {
        this.getJTxtNomCapa().setText(name);
    }

    public TreePath[] getSelectedLayers() {
        return this.getTreeLayers().getSelectionPaths();
    }

    public Hashtable getOnlineResources() {
        return this.explorer.getOnlineResources();
    }

    public String getQueryableLayerQuery() {
        ArrayList elements = ((JDnDListModel)this.getLstSelectedLayers().getModel()).getElements();
        WMSLayerNode[] layers = elements.toArray(new WMSLayerNode[0]);
        String layersQuery = "";
        for (int i = 0; i < layers.length; ++i) {
            if (!layers[i].isQueryable()) continue;
            layersQuery = layers[i].getName();
            break;
        }
        for (int j = i + 1; j < layers.length; ++j) {
            if (!layers[j].isQueryable()) continue;
            layersQuery = layersQuery + "," + layers[j].getName();
        }
        return layersQuery;
    }

    public int getSRSIndex(String crs) {
        for (int i = 0; i < this.getLstSRSs().getModel().getSize(); ++i) {
            if (crs == null || !StringUtils.equals((CharSequence)crs, (CharSequence)Objects.toString(this.getLstSRSs().getModel().getElementAt(i), null))) continue;
            return i;
        }
        return -1;
    }

    public int getFormatIndex(String format) {
        for (int i = 0; i < this.getLstFormats().getModel().getSize(); ++i) {
            if (format == null || !format.equals(this.getLstFormats().getModel().getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int getInfoFormatIndex(String infoformat) {
        for (int i = 0; i < this.getLstInfoFormats().getModel().getSize(); ++i) {
            if (infoformat == null || !infoformat.equals(this.getLstInfoFormats().getModel().getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            InfoPanel ip = this.getTabInfo();
            ip.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    WMSParamsPanel.this.refreshInfo();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            StylesPanel sp = this.getTabStyle();
            DimensionPanel dp = this.getTabDimensions();
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"info"), null, ip, null);
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"capas"), null, this.getTabLayers(), null);
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"estilos"), null, (Component)((Object)sp), null);
            this.stylesTabIndex = this.jTabbedPane.getTabCount() - 1;
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"dimensiones"), null, (Component)((Object)dp), null);
            this.dimensionTabIndex = this.jTabbedPane.getTabCount() - 1;
            this.jTabbedPane.addTab(PluginServices.getText((Object)((Object)this), (String)"formatos"), null, this.getTabFormats(), null);
            this.jTabbedPane.setEnabledAt(this.dimensionTabIndex, false);
            this.jTabbedPane.setEnabledAt(this.stylesTabIndex, false);
        }
        return this.jTabbedPane;
    }

    private JPanel getTabLayers() {
        if (this.tabLayers == null) {
            this.tabLayers = new JPanel();
            this.tabLayers.setLayout(new BorderLayout());
            this.tabLayers.add((Component)this.getJPanelLayerName(), "North");
            this.tabLayers.add((Component)this.getLayersJPanel(), "Center");
        }
        return this.tabLayers;
    }

    private StylesPanel getTabStyle() {
        if (this.tabStyle == null) {
            this.tabStyle = new StylesPanel(this);
            this.tabStyle.setEnabled(false);
            this.tabStyle.addListener(new BeanListener(){

                public void beanValueChanged(Object value) {
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
            this.tabStyle.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    WMSParamsPanel.this.refreshStyleTree();
                }
            });
        }
        return this.tabStyle;
    }

    public void avanzaTab() {
        int currentPage = this.currentPage();
        int nPages = this.getNumTabs();
        if (nPages - 1 > currentPage) {
            this.getJTabbedPane().setSelectedIndex(this.nextEnabledPage());
        }
    }

    public void retrocedeTab() {
        this.getJTabbedPane().setSelectedIndex(this.previousEnabledPage());
    }

    public int currentPage() {
        return this.getJTabbedPane().getSelectedIndex();
    }

    public int getNumTabs() {
        return this.getJTabbedPane().getTabCount();
    }

    public int previousEnabledPage() {
        int currentPage = this.currentPage();
        int j = 0;
        if (currentPage == 0) {
            j = -1;
        }
        for (int i = currentPage - 1; i > -1; --i) {
            if (!this.getJTabbedPane().isEnabledAt(i)) continue;
            j = i;
            break;
        }
        return j;
    }

    public int nextEnabledPage() {
        int nPages;
        int currentPage = this.currentPage();
        if (currentPage == (nPages = this.getNumTabs())) {
            return -1;
        }
        for (int i = currentPage + 1; i < nPages; ++i) {
            if (!this.getJTabbedPane().isEnabledAt(i)) continue;
            return i;
        }
        return -1;
    }

    public void setTransparent(boolean b) {
        this.getChkTransparency().setSelected(b);
    }

    private boolean checkAxisVersion() {
        try {
            if (this.explorer != null && this.explorer.getVersion() != null) {
                int major;
                String version = this.explorer.getVersion();
                String[] parts = version.split("\\.");
                if (parts.length >= 2) {
                    int major2 = Integer.parseInt(parts[0]);
                    int minor = Integer.parseInt(parts[1]);
                    if (major2 == 1 && minor < 3 || major2 < 1) {
                        return false;
                    }
                } else if (parts.length > 0 && (major = Integer.parseInt(parts[0])) < 2) {
                    return false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    public Vector<RemoteWMSStyle> getStyles() {
        WMSLayerNode[] layers = this.selectedLayersToArray();
        Vector<RemoteWMSStyle> v = new Vector<RemoteWMSStyle>(layers.length);
        int posInsertion = 0;
        for (int i = layers.length - 1; i >= 0; --i) {
            RemoteWMSStyle sty = layers[i].getSelectedStyle();
            if (sty != null) {
                v.add(posInsertion, sty);
            } else {
                RemoteWMSStyle s = new RemoteWMSStyle();
                s.name = "";
                v.add(posInsertion, s);
            }
            ++posInsertion;
        }
        return v;
    }

    public Vector<RemoteWMSStyle> getLayerStyle(String layerName) {
        Vector<RemoteWMSStyle> v = new Vector<RemoteWMSStyle>();
        WMSLayerNode[] layers = this.selectedLayersToArray();
        for (int i = 0; i < layers.length; ++i) {
            if (!layers[i].getName().equalsIgnoreCase(layerName)) continue;
            RemoteWMSStyle sty = layers[i].getSelectedStyle();
            v.add(sty);
            return v;
        }
        return v;
    }

    private InfoPanel getTabInfo() {
        if (this.tabInfo == null) {
            this.tabInfo = new InfoPanel();
        }
        return this.tabInfo;
    }

    public void setDimensions(Vector dimensions) {
        for (int i = 0; i < dimensions.size(); ++i) {
            String st = (String)dimensions.get(i);
            if (st.split("=").length != 2) continue;
            String[] s = st.split("=");
            this.getTabDimensions().setDimensionValue(s[0], s[1]);
        }
    }

    private DimensionPanel getTabDimensions() {
        if (this.tabDimensions == null) {
            this.tabDimensions = new DimensionPanel();
            this.tabDimensions.setEnabled(false);
            this.tabDimensions.addListener(new BeanListener(){

                public void beanValueChanged(Object value) {
                    Vector myDimensions = (Vector)value;
                    if (!(value == null || WMSParamsPanel.this.oldDimensions != null && WMSParamsPanel.this.oldDimensions.size() == myDimensions.size() && WMSParamsPanel.this.oldDimensions.containsAll(myDimensions))) {
                        WMSParamsPanel.this.oldDimensions = myDimensions;
                    }
                    WMSParamsPanel.this.fireWizardComplete(WMSParamsPanel.this.isCorrectlyConfigured());
                }
            });
        }
        return this.tabDimensions;
    }

    public boolean getTransparency() {
        return this.getChkTransparency().isSelected();
    }

    public Vector<String> getDimensions() {
        return this.getTabDimensions().getDimensions();
    }

    public void initWizard() {
    }

    public void execute() {
    }

    protected FLayer getAllSubTree(WMSLayerNode node) throws LoadLayerException {
        DataParameters p;
        if (node.getChildren().size() > 0) {
            FLayers l = null;
            if (this.getMapCtrl() == null) {
                AbstractViewPanel v = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
                l = new FLayers();
                l.setMapContext(v.getMapControl().getMapContext());
            } else {
                l = new FLayers();
                l.setMapContext(this.getMapCtrl().getMapContext());
            }
            l.setName(node.getTitle());
            l.setVisible(false);
            for (int i = 0; i < node.getChildren().size(); ++i) {
                FLayer lyr = this.getAllSubTree((WMSLayerNode)node.getChildren().get(i));
                if (lyr == null) continue;
                l.addLayer(lyr);
            }
            return l;
        }
        DataStoreParameters parameters = this.explorer.getStoredParameters();
        WMSDataParameters par = null;
        if (parameters instanceof WMSDataParameters) {
            par = (WMSDataParameters)parameters;
        }
        if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof WMSDataParameters) {
            par = (WMSDataParameters)p;
        }
        par.setFormat(this.getFormat());
        par.setInfoFormat(this.getInfoFormat());
        par.setLayerQuery(node.getName());
        par.setInfoLayerQuery(this.getQueryableLayerQuery());
        par.setSRS(this.getSRS());
        par.setWmsTransparency(this.getTransparency());
        par.setStyles(this.getLayerStyle(node.getName()));
        par.setDimensions(this.getDimensions());
        par.setOnlineResources((Map)this.getOnlineResources());
        par.setFixedSize(this.getFixedSize());
        par.setQueryable(this.explorer.isQueryable());
        par.setName(node.getTitle());
        try {
            par.setURI(new URI(this.explorer.getHost()));
        }
        catch (URISyntaxException e1) {
            throw new LoadLayerException("Can't create URI from " + this.explorer.getHost(), (Throwable)e1);
        }
        par.deleteCache(this.updating);
        par.setXyAxisOrder(this.getXYAxisorder());
        FLyrWMS layer = new FLyrWMS();
        try {
            layer.setParameters(parameters);
            layer.setExplorer(this.explorer);
        }
        catch (InitializeException e) {
            throw new LoadLayerException("Error initializating layer", (Throwable)e);
        }
        layer.setVisible(false);
        return layer;
    }

    public FLayer getAllLayers() throws LoadLayerException {
        LayerTree layerTree = this.getLayerStructure();
        return this.getAllSubTree((WMSLayerNode)layerTree.getModel().getRoot());
    }

    public FLayer getLayer(boolean cached) throws InitializeException {
        this.lastCached = cached;
        if (this.getDisagregatedLayers()) {
            return this.getLayerTree();
        }
        return this.getLayerPlain(cached);
    }

    public FLayer getLayer() throws InitializeException {
        return this.getLayer(this.lastCached);
    }

    protected FLayer getLayerTree() throws InitializeException {
        LayerTree layerTree = this.getLayerStructure();
        TreePath[] selection = this.getSelectedPaths().toArray(new TreePath[0]);
        if (selection != null) {
            return this.getSubTree((WMSLayerNode)layerTree.getModel().getRoot(), selection);
        }
        return null;
    }

    protected boolean nodeSelected(TreePath[] selection, WMSLayerNode node) {
        for (int i = 0; i < selection.length; ++i) {
            Object[] components = selection[i].getPath();
            for (int j = 0; j < components.length; ++j) {
                if (!(components[j] instanceof WMSLayerNode) || ((WMSLayerNode)components[j]).getTitle().compareTo(node.getTitle()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected FLayer getSubTree(WMSLayerNode node, TreePath[] selection) throws InitializeException {
        if (node.getChildren().size() > 0) {
            FLayers l = null;
            if (this.getMapCtrl() == null) {
                AbstractViewPanel v = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
                l = new FLayers();
                l.setMapContext(v.getMapControl().getMapContext());
            } else {
                l = new FLayers();
                l.setMapContext(this.getMapCtrl().getMapContext());
            }
            l.setName(node.getTitle());
            for (int i = 0; i < node.getChildren().size(); ++i) {
                FLayer lyr;
                if (!this.nodeSelected(selection, (WMSLayerNode)node.getChildren().get(i)) || (lyr = this.getSubTree((WMSLayerNode)node.getChildren().get(i), selection)) == null) continue;
                l.addLayer(lyr);
            }
            return l;
        }
        if (this.nodeSelected(selection, node)) {
            DataParameters p;
            DataStoreParameters parameters = this.explorer.getStoredParameters();
            WMSDataParameters par = null;
            if (parameters instanceof WMSDataParameters) {
                par = (WMSDataParameters)parameters;
            }
            if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof WMSDataParameters) {
                par = (WMSDataParameters)p;
            }
            par.setFormat(this.getFormat());
            par.setInfoFormat(this.getInfoFormat());
            par.setLayerQuery(node.getName());
            par.setInfoLayerQuery(this.getQueryableLayerQuery());
            par.setSRS(this.getSRS());
            par.setWmsTransparency(this.getTransparency());
            par.setStyles(this.getLayerStyle(node.getName()));
            par.setDimensions(this.getDimensions());
            par.setOnlineResources((Map)this.explorer.getOnlineResources());
            par.setFixedSize(this.getFixedSize());
            par.setQueryable(node.isQueryable());
            par.setName(node.getTitle());
            try {
                par.setURI(new URI(this.explorer.getHost()));
            }
            catch (URISyntaxException e1) {
                throw new InitializeException("Can't create URI from " + this.explorer.getHost(), (Throwable)e1);
            }
            par.deleteCache(this.updating);
            par.setXyAxisOrder(this.getXYAxisorder());
            FLyrWMS layer = new FLyrWMS();
            layer.setParameters(parameters);
            layer.setName(node.getName());
            layer.setExplorer(this.explorer);
            return layer;
        }
        return null;
    }

    private boolean getXYAxisorder() {
        WMSServerExplorerParameters dsExplParams = this.explorer.getParameters();
        if (dsExplParams instanceof WMSServerExplorerParameters) {
            return dsExplParams.isXyAxisOrder();
        }
        return false;
    }

    protected FLayer getLayerPlain(boolean cached) throws InitializeException {
        WMSDataParameters par;
        WMSDataParameters parameters = par = (WMSDataParameters)this.explorer.getStoredParameters();
        if (cached) {
            DataManager manager = DALLocator.getDataManager();
            TileDataParameters tileParams = null;
            try {
                tileParams = (TileDataParameters)manager.createStoreParameters("Tile Store");
            }
            catch (ProviderNotRegisteredException e) {
                throw new InitializeException(e.getMessage(), (Throwable)e);
            }
            tileParams.setDataParameters((DataParameters)par);
            parameters = tileParams;
        }
        par.setFormat(this.getFormat());
        par.setInfoFormat(this.getInfoFormat());
        par.setLayerQuery(this.getLayersQuery());
        par.setInfoLayerQuery(this.getQueryableLayerQuery());
        par.setSRS(this.getSRS());
        par.setWmsTransparency(this.getTransparency());
        par.setStyles(this.getStyles());
        par.setDimensions(this.getDimensions());
        par.setOnlineResources((Map)this.explorer.getOnlineResources());
        par.setFixedSize(this.getFixedSize());
        par.setQueryable(this.explorer.isQueryable());
        par.setName(this.getLayerName());
        try {
            par.setURI(new URI(this.explorer.getHost()));
        }
        catch (URISyntaxException e1) {
            throw new InitializeException("Can't create URI from " + this.explorer.getHost(), (Throwable)e1);
        }
        par.deleteCache(this.updating);
        par.setXyAxisOrder(this.getXYAxisorder());
        FLyrWMS layer = new FLyrWMS();
        layer.setParameters((DataStoreParameters)parameters);
        layer.setExplorer(this.explorer);
        layer.setName(this.getLayerName());
        return layer;
    }

    private String getDriverExceptionMessage(InitializeException e) {
        Throwable ex = e;
        int MAX_DEEP = 10;
        for (int deep = 0; deep < 10; ++deep) {
            Throwable t = null;
            if (ex instanceof RasterDriverException) {
                return ex.getMessage();
            }
            if (ex instanceof InitializeException) {
                t = ex.getCause();
            } else if (ex instanceof InvocationTargetException) {
                t = ((InvocationTargetException)ex).getTargetException();
            }
            if (t == null) {
                return null;
            }
            ex = t;
        }
        return null;
    }

    public Dimension getFixedSize() {
        return this.sizeFixed;
    }

    private JCheckBox getChkExtendedNames() {
        if (this.chkExtendedNames == null) {
            this.chkExtendedNames = new JCheckBox();
            this.chkExtendedNames.setText(PluginServices.getText((Object)((Object)this), (String)"show_layer_names"));
            this.chkExtendedNames.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean b;
                    ((WMSParamsPanel)WMSParamsPanel.this).getTreeLayers().showLayerNames = b = WMSParamsPanel.this.chkExtendedNames.isSelected();
                    WMSParamsPanel.this.getTreeLayers().repaint();
                    WMSParamsPanel.this.getLstSelectedLayers().showLayerNames = b;
                    WMSParamsPanel.this.getLstSelectedLayers().repaint();
                    ((WMSParamsPanel)WMSParamsPanel.this).getStyleTree().showLayerNames = b;
                }
            });
            this.chkExtendedNames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fPrefs.putBoolean("show_layer_names", WMSParamsPanel.this.chkExtendedNames.isSelected());
                }
            });
            this.chkExtendedNames.setSelected(fPrefs.getBoolean("show_layer_names", true));
        }
        return this.chkExtendedNames;
    }

    private JButton getBtnUp() {
        if (this.btnUp == null) {
            this.btnUp = new JButton();
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnUp, (String)"_Up", (String)"common-arrow-up", e -> {
                LayerList list = this.getLstSelectedLayers();
                int[] selectedIndices = list.getSelectedIndices();
                int index = list.getSelectedIndex();
                if (selectedIndices != null && selectedIndices.length == 1 && index > 0) {
                    JDnDListModel m = (JDnDListModel)list.getModel();
                    m.itemsMoved(index - 1, new int[]{index});
                    list.setSelectedIndex(index - 1);
                }
            }, null);
        }
        return this.btnUp;
    }

    private JButton getBtnDown() {
        if (this.btnDown == null) {
            this.btnDown = new JButton();
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnDown, (String)"_Down", (String)"common-arrow-down", e -> {
                LayerList list = this.getLstSelectedLayers();
                int[] selectedIndices = list.getSelectedIndices();
                int index = list.getSelectedIndex();
                if (selectedIndices != null && selectedIndices.length == 1 && index < this.getLstSelectedLayers().getModel().getSize() - 1) {
                    JDnDListModel m = (JDnDListModel)list.getModel();
                    m.itemsMoved(index + 1, new int[]{index});
                    list.setSelectedIndex(index + 1);
                }
            }, null);
        }
        return this.btnDown;
    }

    public void setFixedSize(Dimension sz) {
        this.sizeFixed = sz;
    }

    public ArrayList<TreePath> getSelectedPaths() {
        return this.selectedPaths;
    }

    public LayerTree getJustTreeLayer() {
        return this.treeLayers;
    }

    private JCheckBox getChkDisagregate() {
        if (this.chkDisagregate == null) {
            this.chkDisagregate = new JCheckBox();
            this.chkDisagregate.setText(PluginServices.getText((Object)((Object)this), (String)"disagregate_layers"));
            this.chkDisagregate.setSelected(false);
        }
        return this.chkDisagregate;
    }

    public boolean getDisagregatedLayers() {
        return this.chkDisagregate.isSelected();
    }

    public void disableDisagregatedLayers() {
        this.chkDisagregate.setEnabled(false);
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void close() {
    }

    public WMSServerExplorer getExplorer() {
        return this.explorer;
    }

    private JButton getBtnSrsToView() {
        if (this.btnSrsToView == null) {
            Image icon = IconThemeHelper.getImage((String)"addlayer-crstoview");
            this.btnSrsToView = new JButton();
            this.btnSrsToView.setIcon(new ImageIcon(icon));
            this.btnSrsToView.setEnabled(false);
            IWindow wi = PluginServices.getMDIManager().getActiveWindow();
            if (wi instanceof IView) {
                MapContext mapContext = ((IView)wi).getMapControl().getMapContext();
                this.btnSrsToView.setEnabled(!mapContext.hasLayers());
                this.btnSrsToView.addActionListener(e -> {
                    IProjection proj;
                    String srs;
                    if (!mapContext.hasLayers() && StringUtils.isNotBlank((CharSequence)(srs = this.getSRS())) && (proj = CRSFactory.getCRS((String)this.getSRS())) != null) {
                        mapContext.setProjection(proj);
                    }
                });
            }
        }
        return this.btnSrsToView;
    }

    public class SRSList
    extends ArrayList<String> {
        public void setAll(Collection<String> c) {
            this.clear();
            this.addAll(c);
        }

        public Collection intersect(Collection<String> c) {
            TreeSet resul = new TreeSet();
            for (int i = 0; i < this.size(); ++i) {
                if (!c.contains(this.get(i))) continue;
                resul.add(this.get(i));
            }
            return resul;
        }
    }
}

