/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.wms.app.wmsclient.wmc.ExportWebMapContextExtension;
import org.gvsig.raster.wms.app.wmsclient.wmc.WebMapContext;

public class WebMapContextSettingsPanel
extends JPanel
implements SingletonWindow {
    private static final long serialVersionUID = 1L;
    public static Preferences fPrefs = Preferences.userRoot().node("gvsig.mapcontext-settingspanel");
    private JPanel simplePanel = null;
    private JPanel advancedPanel = null;
    private JPanel buttonsPanel = null;
    private JComboBox cmbVersion = null;
    private JLabel lblTitle = null;
    private JButton btnBrowseFileSystem = null;
    private JTextField txtTitle = null;
    private JLabel lblVersion = null;
    private JLabel lblId = null;
    private JTextField txtId = null;
    private JLabel lblFile = null;
    private JTextField txtFile = null;
    private JButton btnAdvanced = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private JLabel lblAbstract = null;
    private JLabel lblLogoURL = null;
    private JLabel lblDescriptionURL = null;
    private JTextArea txtAbstract = null;
    private JScrollPane scrlAbstract = null;
    private JTextField txtLogoURL = null;
    private JTextField txtDescriptionURL = null;
    private JPanel pnlMapSize = null;
    private JRadioButton rdBtnUseViewSize = null;
    private JRadioButton rdBtnCustomSize = null;
    private JLabel lblWidth = null;
    private JLabel lblHeight = null;
    private JTextField txtWidth = null;
    private JTextField txtHeight = null;
    private JPanel pnlContactInfo = null;
    private JTextField txtKeyWords = null;
    private JLabel lblKeyWords = null;
    private JLabel lblContactPerson = null;
    private JTextField txtContactPerson = null;
    private JLabel lblContactOrganization = null;
    private JTextField txtOrganization = null;
    private JLabel lblContactPosition = null;
    private JTextField txtContactPosition = null;
    private JLabel lblAddress = null;
    private JTextField txtAddress = null;
    private JLabel lblCity = null;
    private JTextField txtCity = null;
    private JLabel lblStateProvince = null;
    private JTextField txtStateOrProvince = null;
    private JLabel lblPostCode = null;
    private JTextField txtPostCode = null;
    private JLabel lblCountry = null;
    private JComboBox cmbCountries = null;
    private JLabel lblPhone = null;
    private JTextField txtTelephone = null;
    private JLabel lblFax = null;
    private JTextField txtFax = null;
    private JLabel lblEMail = null;
    private JTextField txtEMail = null;
    private boolean first = true;
    private boolean advanced = fPrefs.getBoolean("advanced-panel", false);
    private WindowInfo m_viewInfo;
    private String strAdvanced = Messages.getText((String)"advanced");
    private File targetFile;
    private WebMapContext wmc;
    private DefaultViewDocument[] exportableViews;
    private JLabel lblView = null;
    private JComboBox cmbViews = null;
    private String lastWidth;
    private String lastHeight;
    private int defaultWidth = 500;
    private int defaultHeight = 450;
    private JLabel lblExtent = null;
    private JRadioButton rdBtnCurrentViewExtent = null;
    private JRadioButton rdBtnFullExtent = null;
    private static String lastPath = null;
    protected boolean useFullExtent = fPrefs.getBoolean("use_full_extent", false);

    public WebMapContextSettingsPanel(DefaultViewDocument[] views) {
        this.exportableViews = views;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.switchPanels();
    }

    private void switchPanels() {
        Dimension sz;
        this.removeAll();
        this.add((Component)this.getSimplePanel(), "North");
        if (this.advanced) {
            this.add((Component)this.getAdvancedPanel(), "Center");
            sz = new Dimension(535, 640);
            this.btnAdvanced.setText(this.strAdvanced + "  <<");
        } else {
            sz = new Dimension(535, 260);
            this.btnAdvanced.setText(this.strAdvanced + "  >>");
        }
        this.setSize(sz);
        this.add((Component)this.getButtonsPanel(), "South");
        fPrefs.putBoolean("advanced-panel", this.advanced);
        if (!this.first) {
            PluginServices.getMDIManager().changeWindowInfo((IWindow)this, this.getWindowInfo());
            PluginServices.getMDIManager().closeWindow((IWindow)this);
            PluginServices.getMDIManager().addWindow((IWindow)this);
        }
        this.first = false;
    }

    public WindowInfo getWindowInfo() {
        this.m_viewInfo = new WindowInfo(4);
        this.m_viewInfo.setTitle(Messages.getText((String)"web_map_context_settings"));
        this.m_viewInfo.setWidth(this.getWidth() + 8);
        this.m_viewInfo.setHeight(this.getHeight());
        return this.m_viewInfo;
    }

    private JPanel getSimplePanel() {
        if (this.simplePanel == null) {
            ButtonGroup group = new ButtonGroup();
            this.lblExtent = new JLabel();
            this.lblExtent.setBounds(9, 146, 79, 20);
            this.lblExtent.setHorizontalTextPosition(4);
            this.lblExtent.setHorizontalAlignment(4);
            this.lblExtent.setText(Messages.getText((String)"map_extent") + ":");
            this.lblView = new JLabel();
            this.lblView.setBounds(9, 24, 79, 20);
            this.lblView.setHorizontalTextPosition(4);
            this.lblView.setHorizontalAlignment(4);
            this.lblView.setText(Messages.getText((String)ViewManager.TYPENAME) + ":");
            this.lblTitle = new JLabel();
            this.lblTitle.setHorizontalAlignment(4);
            this.lblTitle.setBounds(9, 48, 79, 20);
            this.lblTitle.setHorizontalTextPosition(4);
            this.lblTitle.setText(Messages.getText((String)"title") + ":");
            this.lblId = new JLabel();
            this.lblId.setBounds(9, 72, 79, 20);
            this.lblId.setHorizontalTextPosition(4);
            this.lblId.setHorizontalAlignment(4);
            this.lblId.setText(Messages.getText((String)"id") + ":");
            this.lblVersion = new JLabel();
            this.lblVersion.setBounds(9, 120, 79, 20);
            this.lblVersion.setHorizontalTextPosition(4);
            this.lblVersion.setHorizontalAlignment(4);
            this.lblVersion.setText(Messages.getText((String)"version") + ":");
            this.lblFile = new JLabel();
            this.lblFile.setBounds(9, 96, 79, 20);
            this.lblFile.setHorizontalTextPosition(4);
            this.lblFile.setHorizontalAlignment(4);
            this.lblFile.setText(Messages.getText((String)"file_name") + ":");
            this.simplePanel = new JPanel();
            this.simplePanel.setLayout(null);
            this.simplePanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"options"), 0, 0, null, null));
            this.simplePanel.setBounds(new Rectangle(0, 0, 535, 196));
            this.simplePanel.add((Component)this.lblView, null);
            this.simplePanel.add((Component)this.getCmbViews(), null);
            this.simplePanel.add((Component)this.getTxtTitle(), null);
            this.simplePanel.add((Component)this.lblTitle, null);
            this.simplePanel.add((Component)this.getBtnBrowseFileSystem(), null);
            this.simplePanel.add((Component)this.lblVersion, null);
            this.simplePanel.add((Component)this.lblId, null);
            this.simplePanel.add((Component)this.getTxtId(), null);
            this.simplePanel.add((Component)this.lblFile, null);
            this.simplePanel.add((Component)this.getTxtFile(), null);
            this.simplePanel.add((Component)this.getBtnAdvanced(), null);
            this.simplePanel.add((Component)this.getCmbVersion(), null);
            this.simplePanel.add((Component)this.lblExtent, null);
            this.simplePanel.add((Component)this.getRdBtnCurrentViewExtent(), null);
            this.simplePanel.add((Component)this.getRdBtnFullExtent(), null);
            group.add(this.getRdBtnCurrentViewExtent());
            group.add(this.getRdBtnFullExtent());
        }
        return this.simplePanel;
    }

    private JPanel getAdvancedPanel() {
        if (this.advancedPanel == null) {
            this.lblKeyWords = new JLabel();
            this.lblKeyWords.setBounds(10, 79, 99, 20);
            this.lblKeyWords.setHorizontalTextPosition(4);
            this.lblKeyWords.setHorizontalAlignment(4);
            this.lblKeyWords.setText(Messages.getText((String)"keywords") + ":");
            this.lblDescriptionURL = new JLabel();
            this.lblDescriptionURL.setBounds(10, 104, 99, 20);
            this.lblDescriptionURL.setHorizontalTextPosition(4);
            this.lblDescriptionURL.setText(Messages.getText((String)"description_URL") + ":");
            this.lblDescriptionURL.setHorizontalAlignment(4);
            this.lblLogoURL = new JLabel();
            this.lblLogoURL.setBounds(10, 130, 99, 20);
            this.lblLogoURL.setHorizontalTextPosition(4);
            this.lblLogoURL.setHorizontalAlignment(4);
            this.lblLogoURL.setText(Messages.getText((String)"logo_URL") + ":");
            this.lblAbstract = new JLabel();
            this.lblAbstract.setText(Messages.getText((String)"abstract") + ":");
            this.lblAbstract.setHorizontalTextPosition(4);
            this.lblAbstract.setHorizontalAlignment(4);
            this.lblAbstract.setBounds(10, 27, 99, 20);
            this.advancedPanel = new JPanel();
            this.advancedPanel.setLayout(null);
            this.advancedPanel.setBounds(0, 194, 535, 386);
            this.advancedPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"advanced_settings"), 0, 0, null, null));
            this.advancedPanel.add((Component)this.lblAbstract, null);
            this.advancedPanel.add((Component)this.lblKeyWords, null);
            this.advancedPanel.add((Component)this.lblLogoURL, null);
            this.advancedPanel.add((Component)this.lblDescriptionURL, null);
            this.advancedPanel.add((Component)this.getScrlAbstract(), null);
            this.advancedPanel.add((Component)this.getTxtLogoURL(), null);
            this.advancedPanel.add((Component)this.getTxtDescriptionURL(), null);
            this.advancedPanel.add((Component)this.getPnlMapSize(), null);
            this.advancedPanel.add((Component)this.getPnlContactInfo(), null);
            this.advancedPanel.add((Component)this.getTxtKeyWords(), null);
        }
        return this.advancedPanel;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            flowLayout.setVgap(1);
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(flowLayout);
            this.buttonsPanel.add((Component)this.getBtnOk(), null);
            this.buttonsPanel.add((Component)this.getBtnCancel(), null);
        }
        this.buttonsPanel.setBounds(0, this.getHeight() - 60, 535, 38);
        return this.buttonsPanel;
    }

    private JComboBox getCmbVersion() {
        if (this.cmbVersion == null) {
            this.cmbVersion = new JComboBox();
            this.cmbVersion.setSize(89, 20);
            this.cmbVersion.setLocation(91, 120);
            for (int i = 0; i < WebMapContext.exportVersions.size(); ++i) {
                this.cmbVersion.addItem(WebMapContext.exportVersions.get(i));
            }
        }
        return this.cmbVersion;
    }

    private JButton getBtnBrowseFileSystem() {
        if (this.btnBrowseFileSystem == null) {
            this.btnBrowseFileSystem = new JButton();
            this.btnBrowseFileSystem.setBounds(403, 95, 120, 22);
            this.btnBrowseFileSystem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser("WMC_FILECHOOSER_ID", lastPath);
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".cml");
                        }

                        @Override
                        public String getDescription() {
                            return Messages.getText((String)"ogc_mapcontext_file") + " (*.cml)";
                        }
                    });
                    if (fc.showOpenDialog((Component)PluginServices.getMainFrame()) == 0) {
                        String fileName = fc.getSelectedFile().getAbsolutePath();
                        if (!fileName.toLowerCase().endsWith(".cml")) {
                            fileName = fileName + ".cml";
                        }
                        WebMapContextSettingsPanel.this.targetFile = new File(fileName);
                        WebMapContextSettingsPanel.this.getTxtFile().setText(fileName);
                        lastPath = fileName.substring(0, fileName.lastIndexOf(File.separatorChar));
                    }
                    fc = null;
                }
            });
            this.btnBrowseFileSystem.setText(Messages.getText((String)"browse"));
        }
        return this.btnBrowseFileSystem;
    }

    private JTextField getTxtTitle() {
        if (this.txtTitle == null) {
            this.txtTitle = new JTextField();
            this.txtTitle.setBounds(91, 48, 432, 20);
            this.txtTitle.setName(Messages.getText((String)"title"));
        }
        return this.txtTitle;
    }

    private JTextField getTxtId() {
        if (this.txtId == null) {
            this.txtId = new JTextField();
            this.txtId.setBounds(91, 72, 432, 20);
            this.txtId.setName(Messages.getText((String)"id"));
        }
        return this.txtId;
    }

    private JTextField getTxtFile() {
        if (this.txtFile == null) {
            this.txtFile = new JTextField();
            this.txtFile.setBounds(91, 96, 308, 20);
        }
        return this.txtFile;
    }

    private JButton getBtnAdvanced() {
        if (this.btnAdvanced == null) {
            this.btnAdvanced = new JButton();
            this.btnAdvanced.setLocation(403, 160);
            this.btnAdvanced.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebMapContextSettingsPanel.this.advanced = !WebMapContextSettingsPanel.this.advanced;
                    WebMapContextSettingsPanel.this.switchPanels();
                }
            });
        }
        return this.btnAdvanced;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText(Messages.getText((String)"Ok"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebMapContextSettingsPanel.this.execute("OK");
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Messages.getText((String)"cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebMapContextSettingsPanel.this.execute("CANCEL");
                }
            });
        }
        return this.btnCancel;
    }

    private JTextArea getTxtAbstract() {
        if (this.txtAbstract == null) {
            this.txtAbstract = new JTextArea();
        }
        return this.txtAbstract;
    }

    private JScrollPane getScrlAbstract() {
        if (this.scrlAbstract == null) {
            this.scrlAbstract = new JScrollPane();
            this.scrlAbstract.setBounds(115, 27, 232, 48);
            this.scrlAbstract.setViewportView(this.getTxtAbstract());
        }
        return this.scrlAbstract;
    }

    private JTextField getTxtLogoURL() {
        if (this.txtLogoURL == null) {
            this.txtLogoURL = new JTextField();
            this.txtLogoURL.setBounds(115, 130, 407, 20);
        }
        return this.txtLogoURL;
    }

    private JTextField getTxtDescriptionURL() {
        if (this.txtDescriptionURL == null) {
            this.txtDescriptionURL = new JTextField();
            this.txtDescriptionURL.setBounds(115, 104, 232, 20);
        }
        return this.txtDescriptionURL;
    }

    private JPanel getPnlMapSize() {
        if (this.pnlMapSize == null) {
            ButtonGroup group = new ButtonGroup();
            this.lblHeight = new JLabel();
            this.lblHeight.setText(Messages.getText((String)"height"));
            this.lblHeight.setBounds(11, 79, 52, 20);
            this.lblHeight.setHorizontalTextPosition(4);
            this.lblHeight.setEnabled(false);
            this.lblHeight.setHorizontalAlignment(4);
            this.lblWidth = new JLabel();
            this.lblWidth.setText(Messages.getText((String)"width"));
            this.lblWidth.setBounds(11, 56, 52, 20);
            this.lblWidth.setHorizontalAlignment(4);
            this.lblWidth.setEnabled(false);
            this.lblWidth.setHorizontalTextPosition(4);
            this.pnlMapSize = new JPanel();
            this.pnlMapSize.setLayout(null);
            this.pnlMapSize.setBounds(351, 19, 179, 108);
            this.pnlMapSize.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"map_size_in_pixels"), 0, 0, null, null));
            this.pnlMapSize.add((Component)this.getRdBtnUseViewSize(), null);
            this.pnlMapSize.add((Component)this.getRdBtnCustomSize(), null);
            this.pnlMapSize.add((Component)this.lblWidth, null);
            this.pnlMapSize.add((Component)this.lblHeight, null);
            this.pnlMapSize.add((Component)this.getTxtWidth(), null);
            this.pnlMapSize.add((Component)this.getTxtHeight(), null);
            group.add(this.getRdBtnUseViewSize());
            group.add(this.getRdBtnCustomSize());
        }
        return this.pnlMapSize;
    }

    private JRadioButton getRdBtnUseViewSize() {
        if (this.rdBtnUseViewSize == null) {
            this.rdBtnUseViewSize = new JRadioButton();
            this.rdBtnUseViewSize.setBounds(8, 16, 142, 20);
            this.rdBtnUseViewSize.setText(Messages.getText((String)"use_view_size"));
            this.rdBtnUseViewSize.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean b = !WebMapContextSettingsPanel.this.getRdBtnUseViewSize().isSelected();
                    WebMapContextSettingsPanel.this.getTxtWidth().setEnabled(b);
                    WebMapContextSettingsPanel.this.getTxtHeight().setEnabled(b);
                }
            });
            this.rdBtnUseViewSize.setSelected(true);
        }
        return this.rdBtnUseViewSize;
    }

    private JRadioButton getRdBtnCustomSize() {
        if (this.rdBtnCustomSize == null) {
            this.rdBtnCustomSize = new JRadioButton();
            this.rdBtnCustomSize.setBounds(8, 34, 142, 20);
            this.rdBtnCustomSize.setText(Messages.getText((String)"use_custom_size"));
        }
        return this.rdBtnCustomSize;
    }

    private JTextField getTxtWidth() {
        if (this.txtWidth == null) {
            this.txtWidth = new JTextField();
            this.txtWidth.setBounds(66, 56, 105, 20);
            this.txtWidth.setEnabled(false);
            this.txtWidth.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    try {
                        String text = WebMapContextSettingsPanel.this.getTxtWidth().getText();
                        Integer.parseInt(text);
                        WebMapContextSettingsPanel.this.lastWidth = text;
                    }
                    catch (Exception ex) {
                        WebMapContextSettingsPanel.this.getTxtWidth().setText(WebMapContextSettingsPanel.this.lastWidth);
                    }
                }
            });
            Dimension sz = this.exportableViews[this.getCmbViews().getSelectedIndex()].getMapContext().getViewPort().getImageSize();
            this.lastWidth = sz != null ? (int)sz.getWidth() + "" : this.defaultWidth + "";
            this.txtWidth.setText(this.lastWidth);
        }
        return this.txtWidth;
    }

    private JTextField getTxtHeight() {
        if (this.txtHeight == null) {
            this.txtHeight = new JTextField();
            this.txtHeight.setBounds(66, 79, 105, 20);
            this.txtHeight.setEnabled(false);
            this.txtHeight.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    try {
                        String text = WebMapContextSettingsPanel.this.getTxtHeight().getText();
                        Integer.parseInt(text);
                        WebMapContextSettingsPanel.this.lastHeight = text;
                    }
                    catch (Exception ex) {
                        WebMapContextSettingsPanel.this.getTxtHeight().setText(WebMapContextSettingsPanel.this.lastHeight);
                    }
                }
            });
            Dimension sz = this.exportableViews[this.getCmbViews().getSelectedIndex()].getMapContext().getViewPort().getImageSize();
            this.lastHeight = sz != null ? (int)sz.getHeight() + "" : this.defaultHeight + "";
            this.txtHeight.setText(this.lastHeight);
        }
        return this.txtHeight;
    }

    private JPanel getPnlContactInfo() {
        if (this.pnlContactInfo == null) {
            this.lblEMail = new JLabel();
            this.lblEMail.setBounds(7, 193, 98, 20);
            this.lblEMail.setHorizontalTextPosition(4);
            this.lblEMail.setHorizontalAlignment(4);
            this.lblEMail.setText(Messages.getText((String)"e-mail") + ":");
            this.lblFax = new JLabel();
            this.lblFax.setBounds(274, 168, 57, 20);
            this.lblFax.setHorizontalTextPosition(4);
            this.lblFax.setHorizontalAlignment(4);
            this.lblFax.setText(Messages.getText((String)"fax") + ":");
            this.lblPostCode = new JLabel();
            this.lblPostCode.setBounds(7, 143, 98, 20);
            this.lblPostCode.setHorizontalTextPosition(4);
            this.lblPostCode.setHorizontalAlignment(4);
            this.lblPostCode.setText(Messages.getText((String)"postcode") + ":");
            this.lblPhone = new JLabel();
            this.lblPhone.setBounds(7, 168, 98, 20);
            this.lblPhone.setHorizontalTextPosition(4);
            this.lblPhone.setHorizontalAlignment(4);
            this.lblPhone.setText(Messages.getText((String)"telephone") + ":");
            this.lblCountry = new JLabel();
            this.lblCountry.setBounds(274, 143, 57, 20);
            this.lblCountry.setText(Messages.getText((String)"country") + ":");
            this.lblCountry.setHorizontalTextPosition(4);
            this.lblCountry.setHorizontalAlignment(4);
            this.lblStateProvince = new JLabel();
            this.lblStateProvince.setBounds(252, 119, 111, 20);
            this.lblStateProvince.setText(Messages.getText((String)"state_or_province") + ":");
            this.lblStateProvince.setHorizontalAlignment(4);
            this.lblStateProvince.setHorizontalTextPosition(4);
            this.lblCity = new JLabel();
            this.lblCity.setBounds(7, 119, 98, 20);
            this.lblCity.setText(Messages.getText((String)"city") + ":");
            this.lblCity.setHorizontalAlignment(4);
            this.lblCity.setHorizontalTextPosition(4);
            this.lblContactPosition = new JLabel();
            this.lblContactPosition.setBounds(6, 69, 99, 20);
            this.lblContactPosition.setHorizontalTextPosition(4);
            this.lblContactPosition.setHorizontalAlignment(4);
            this.lblContactPosition.setText(Messages.getText((String)"contact_position"));
            this.lblContactOrganization = new JLabel();
            this.lblContactOrganization.setBounds(6, 44, 99, 20);
            this.lblContactOrganization.setHorizontalTextPosition(4);
            this.lblContactOrganization.setHorizontalAlignment(4);
            this.lblContactOrganization.setText(Messages.getText((String)"contact_organization") + ":");
            this.lblAddress = new JLabel();
            this.lblAddress.setBounds(6, 94, 99, 20);
            this.lblAddress.setHorizontalAlignment(4);
            this.lblAddress.setHorizontalTextPosition(4);
            this.lblAddress.setText(Messages.getText((String)"address"));
            this.lblContactPerson = new JLabel();
            this.lblContactPerson.setText(Messages.getText((String)"contact_person") + ":");
            this.lblContactPerson.setHorizontalAlignment(4);
            this.lblContactPerson.setHorizontalTextPosition(4);
            this.lblContactPerson.setBounds(6, 19, 99, 20);
            this.pnlContactInfo = new JPanel();
            this.pnlContactInfo.setLayout(null);
            this.pnlContactInfo.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"contact_info"), 0, 0, null, null));
            this.pnlContactInfo.setLocation(4, 158);
            this.pnlContactInfo.setSize(527, 223);
            this.pnlContactInfo.add((Component)this.lblContactPerson, null);
            this.pnlContactInfo.add((Component)this.getTxtContactPerson(), null);
            this.pnlContactInfo.add((Component)this.lblContactOrganization, null);
            this.pnlContactInfo.add((Component)this.getTxtOrganization(), null);
            this.pnlContactInfo.add((Component)this.lblContactPosition, null);
            this.pnlContactInfo.add((Component)this.getTxtContactPosition(), null);
            this.pnlContactInfo.add((Component)this.lblAddress, null);
            this.pnlContactInfo.add((Component)this.getTxtAddress(), null);
            this.pnlContactInfo.add((Component)this.lblCity, null);
            this.pnlContactInfo.add((Component)this.getTxtCity(), null);
            this.pnlContactInfo.add((Component)this.lblStateProvince, null);
            this.pnlContactInfo.add((Component)this.getCmbCountries(), null);
            this.pnlContactInfo.add((Component)this.getTxtStateOrProvince(), null);
            this.pnlContactInfo.add((Component)this.lblPostCode, null);
            this.pnlContactInfo.add((Component)this.getTxtPostCode(), null);
            this.pnlContactInfo.add((Component)this.lblCountry, null);
            this.pnlContactInfo.add((Component)this.lblPhone, null);
            this.pnlContactInfo.add((Component)this.getTxtTelephone(), null);
            this.pnlContactInfo.add((Component)this.lblFax, null);
            this.pnlContactInfo.add((Component)this.getTxtFax(), null);
            this.pnlContactInfo.add((Component)this.lblEMail, null);
            this.pnlContactInfo.add((Component)this.getTxtEMail(), null);
        }
        return this.pnlContactInfo;
    }

    private JTextField getTxtKeyWords() {
        if (this.txtKeyWords == null) {
            this.txtKeyWords = new JTextField();
            this.txtKeyWords.setBounds(115, 79, 232, 20);
        }
        return this.txtKeyWords;
    }

    private JTextField getTxtContactPerson() {
        if (this.txtContactPerson == null) {
            this.txtContactPerson = new JTextField();
            this.txtContactPerson.setBounds(111, 19, 407, 20);
        }
        return this.txtContactPerson;
    }

    private JTextField getTxtOrganization() {
        if (this.txtOrganization == null) {
            this.txtOrganization = new JTextField();
            this.txtOrganization.setBounds(111, 44, 407, 20);
        }
        return this.txtOrganization;
    }

    private JTextField getTxtContactPosition() {
        if (this.txtContactPosition == null) {
            this.txtContactPosition = new JTextField();
            this.txtContactPosition.setBounds(111, 69, 407, 20);
        }
        return this.txtContactPosition;
    }

    private JTextField getTxtAddress() {
        if (this.txtAddress == null) {
            this.txtAddress = new JTextField();
            this.txtAddress.setBounds(111, 94, 407, 20);
        }
        return this.txtAddress;
    }

    private JTextField getTxtCity() {
        if (this.txtCity == null) {
            this.txtCity = new JTextField();
            this.txtCity.setBounds(111, 119, 135, 20);
        }
        return this.txtCity;
    }

    private JTextField getTxtStateOrProvince() {
        if (this.txtStateOrProvince == null) {
            this.txtStateOrProvince = new JTextField();
            this.txtStateOrProvince.setBounds(368, 119, 150, 20);
        }
        return this.txtStateOrProvince;
    }

    private JTextField getTxtPostCode() {
        if (this.txtPostCode == null) {
            this.txtPostCode = new JTextField();
            this.txtPostCode.setBounds(111, 143, 159, 20);
        }
        return this.txtPostCode;
    }

    private JComboBox getCmbCountries() {
        if (this.cmbCountries == null) {
            this.cmbCountries = new JComboBox();
            this.cmbCountries.setBounds(336, 143, 182, 20);
            String[] countries = Messages.getText((String)"countries_of_the_world").split(";");
            for (int i = 0; i < countries.length; ++i) {
                this.cmbCountries.addItem(countries[i]);
            }
        }
        return this.cmbCountries;
    }

    private JTextField getTxtTelephone() {
        if (this.txtTelephone == null) {
            this.txtTelephone = new JTextField();
            this.txtTelephone.setBounds(111, 168, 159, 20);
        }
        return this.txtTelephone;
    }

    private JTextField getTxtFax() {
        if (this.txtFax == null) {
            this.txtFax = new JTextField();
            this.txtFax.setBounds(336, 168, 182, 20);
        }
        return this.txtFax;
    }

    private JTextField getTxtEMail() {
        if (this.txtEMail == null) {
            this.txtEMail = new JTextField();
            this.txtEMail.setBounds(111, 193, 407, 20);
        }
        return this.txtEMail;
    }

    public Object getWindowModel() {
        return Messages.getText((String)"web_map_context_settings");
    }

    private void execute(String actionCommand) {
        if ("OK".equals(actionCommand)) {
            String str = this.getTxtFile().getText();
            if (str == null || str.equals("")) {
                JOptionPane.showMessageDialog(this, Messages.getText((String)"must_specify_a_file"), Messages.getText((String)"error"), 0);
                return;
            }
            DefaultViewDocument theView = this.exportableViews[this.getCmbViews().getSelectedIndex()];
            MapContext mc = theView.getMapContext();
            this.wmc = new WebMapContext();
            this.wmc.fileVersion = (String)this.getCmbVersion().getSelectedItem();
            if (this.advanced) {
                if (this.getRdBtnUseViewSize().isSelected()) {
                    Dimension sz = null;
                    if (mc.getViewPort().getImageSize() != null) {
                        sz = new Dimension(mc.getViewPort().getImageSize());
                    }
                    if (sz == null || (int)sz.getHeight() == 0 || (int)sz.getWidth() == 0) {
                        sz = new Dimension(this.defaultWidth, this.defaultHeight);
                    }
                    this.wmc.windowSize = sz;
                } else {
                    try {
                        this.wmc.windowSize = new Dimension(Integer.parseInt(this.getTxtWidth().getText()), Integer.parseInt(this.getTxtHeight().getText()));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, Messages.getText((String)"invalid_dimension_values"), PluginServices.getText((Object)this, (String)"error"), 0);
                        return;
                    }
                }
            }
            this.wmc.srs = mc.getProjection().getAbrev();
            if (this.useFullExtent) {
                try {
                    this.wmc.bBox = this.getRectable2DFromEnvelope(mc.getFullEnvelope());
                }
                catch (ReadException e) {
                    NotificationManager.addError((Throwable)e);
                    return;
                }
            } else {
                this.wmc.bBox = this.getRectable2DFromEnvelope(mc.getViewPort().getAdjustedExtent());
            }
            str = this.getTxtTitle().getText();
            if (str == null || str.equals("")) {
                JOptionPane.showMessageDialog(this, this.getTxtTitle().getName() + " " + Messages.getText((String)"is_required"), Messages.getText((String)"error"), 0);
                return;
            }
            this.wmc.title = str;
            str = this.getTxtId().getText();
            if (str == null || str.equals("")) {
                JOptionPane.showMessageDialog(this, this.getTxtId().getName() + " " + Messages.getText((String)"is_required"), Messages.getText((String)"error"), 0);
                return;
            }
            this.wmc.id = str;
            this.wmc.xmlns = "http://www.opengis.net/context";
            this.wmc.xmlns_xlink = "http://www.w3.org/1999/xlink";
            this.wmc.xmlns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
            this.wmc.xsi_schemaLocation = "http://www.opengeospatial.net/context context.xsd";
            str = this.getTxtAbstract().getText();
            if (str != null && !str.equals("")) {
                this.wmc._abstract = str;
            }
            if ((str = this.getTxtKeyWords().getText()) != null && !str.equals("")) {
                String[] ss = str.split("[, ;:]+");
                for (int i = 0; i < ss.length; ++i) {
                    if (this.wmc.keywordList == null) {
                        this.wmc.keywordList = new ArrayList<String>();
                    }
                    this.wmc.keywordList.add(ss[i]);
                }
            }
            if ((str = this.getTxtLogoURL().getText()) != null && !str.equals("")) {
                this.wmc.logoURL = str;
            }
            this.wmc.logoURLSize = null;
            this.wmc.logoURLFormat = null;
            this.wmc.descriptionURLFormat = null;
            str = this.getTxtLogoURL().getText();
            if (str != null && !str.equals("")) {
                this.wmc.descriptionURL = str;
            }
            if ((str = this.getTxtContactPerson().getText()) != null && !str.equals("")) {
                this.wmc.contactPerson = str;
                this.wmc.contactInfo = true;
            }
            if ((str = this.getTxtOrganization().getText()) != null && !str.equals("")) {
                this.wmc.contactOrganization = str;
                this.wmc.contactInfo = true;
            }
            if ((str = this.getTxtContactPosition().getText()) != null && !str.equals("")) {
                this.wmc.contactPosition = str;
                this.wmc.contactInfo = true;
            }
            if ((str = this.getTxtAddress().getText()) != null && !str.equals("")) {
                this.wmc.address = str;
                this.wmc.contactInfo = true;
            }
            if ((str = this.getTxtCity().getText()) != null && !str.equals("")) {
                this.wmc.city = str;
                this.wmc.contactInfo = true;
            }
            if ((str = this.getTxtStateOrProvince().getText()) != null && !str.equals("")) {
                this.wmc.stateOrProvince = str;
                this.wmc.contactInfo = true;
            }
            if ((str = this.getTxtPostCode().getText()) != null && !str.equals("")) {
                this.wmc.postCode = str;
            }
            if ((str = (String)this.getCmbCountries().getSelectedItem()) != null && !str.equals("")) {
                this.wmc.country = str;
            }
            if ((str = this.getTxtTelephone().getText()) != null && !str.equals("")) {
                this.wmc.telephone = str;
                this.wmc.contactInfo = true;
            }
            if ((str = this.getTxtFax().getText()) != null && !str.equals("")) {
                this.wmc.fax = str;
                this.wmc.contactInfo = true;
            }
            if ((str = this.getTxtEMail().getText()) != null && !str.equals("")) {
                this.wmc.email = str;
                this.wmc.contactInfo = true;
            }
            ExportWebMapContextExtension exp = (ExportWebMapContextExtension)PluginServices.getExtension(ExportWebMapContextExtension.class);
            exp.execute("DO_EXPORT");
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        } else if ("CANCEL".equals(actionCommand)) {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
    }

    public String getXML() {
        return this.wmc.toXML(this.exportableViews[this.getCmbViews().getSelectedIndex()]);
    }

    public File getTargetFile() {
        String fileName;
        if (this.targetFile == null && (fileName = this.getTxtFile().getText()) != null) {
            this.targetFile = new File(fileName);
        }
        return this.targetFile;
    }

    private JComboBox getCmbViews() {
        if (this.cmbViews == null) {
            this.cmbViews = new JComboBox();
            this.cmbViews.setBounds(91, 24, 432, 21);
            this.cmbViews.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DefaultViewDocument theView = WebMapContextSettingsPanel.this.exportableViews[WebMapContextSettingsPanel.this.getCmbViews().getSelectedIndex()];
                    Dimension sz = theView.getMapContext().getViewPort().getImageSize();
                    if (sz == null || (int)sz.getHeight() == 0 || (int)sz.getWidth() == 0) {
                        sz = new Dimension(WebMapContextSettingsPanel.this.defaultWidth, WebMapContextSettingsPanel.this.defaultHeight);
                    }
                    WebMapContextSettingsPanel.this.getTxtWidth().setText((int)sz.getWidth() + "");
                    WebMapContextSettingsPanel.this.getTxtHeight().setText((int)sz.getHeight() + "");
                    WebMapContextSettingsPanel.this.getTxtTitle().setText(theView.getName());
                }
            });
            for (int i = 0; i < this.exportableViews.length; ++i) {
                this.cmbViews.addItem(this.exportableViews[i].getName());
            }
        }
        return this.cmbViews;
    }

    private JRadioButton getRdBtnCurrentViewExtent() {
        if (this.rdBtnCurrentViewExtent == null) {
            this.rdBtnCurrentViewExtent = new JRadioButton();
            this.rdBtnCurrentViewExtent.setBounds(91, 146, 270, 20);
            this.rdBtnCurrentViewExtent.setText(Messages.getText((String)"defined_by_view_extent"));
            this.rdBtnCurrentViewExtent.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    fPrefs.putBoolean("use_full_extent", !WebMapContextSettingsPanel.this.getRdBtnFullExtent().isSelected());
                }
            });
            this.rdBtnCurrentViewExtent.setSelected(!this.useFullExtent);
        }
        return this.rdBtnCurrentViewExtent;
    }

    private JRadioButton getRdBtnFullExtent() {
        if (this.rdBtnFullExtent == null) {
            this.rdBtnFullExtent = new JRadioButton();
            this.rdBtnFullExtent.setBounds(91, 164, 270, 20);
            this.rdBtnFullExtent.setText(Messages.getText((String)"use_full_extent"));
            this.rdBtnFullExtent.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean b = WebMapContextSettingsPanel.this.getRdBtnFullExtent().isSelected();
                    fPrefs.putBoolean("use_full_extent", b);
                    WebMapContextSettingsPanel.this.useFullExtent = b;
                }
            });
            this.rdBtnFullExtent.setSelected(this.useFullExtent);
        }
        return this.rdBtnFullExtent;
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }

    private Rectangle2D.Double getRectable2DFromEnvelope(Envelope env) {
        return new Rectangle2D.Double(env.getMinimum(0), env.getMinimum(1), env.getLength(0), env.getLength(1));
    }
}

