/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JOptionPane;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RemoteStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.Tiling;
import org.gvsig.fmap.mapcontext.layers.operations.ComposedLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.gui.beans.Messages;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.NotAvailableStateException;
import org.gvsig.raster.fmap.legend.ImageLegend;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wms.app.wmsclient.layer.ComposedLayerWMS;
import org.gvsig.raster.wms.app.wmsclient.layer.DynObjectSetWMSInfo;
import org.gvsig.raster.wms.app.wmsclient.wmc.XmlBuilder;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSLayerNode;
import org.gvsig.raster.wms.io.WMSServerExplorer;
import org.gvsig.raster.wms.io.WMSServerExplorerParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLyrWMS
extends DefaultFLyrRaster {
    public static final String PERSISTENT_NAME = "FLyrWMS_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "FLyrWMS Persistent Definition";
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(FLyrWMS.class);
    private boolean mustSplitRequest = false;
    private final int maxTileDrawWidth = 1023;
    private final int maxTileDrawHeight = 1023;
    private final int maxTilePrintWidth = 1023;
    private final int maxTilePrintHeight = 1023;
    private List<WeakReference<Thread>> disableUpdateDrawVersion;
    private boolean firstLoad = false;
    private RasterManager rManager = RasterLocator.getManager();
    private boolean deleteCache = false;

    public FLyrWMS() {
        this.updateDrawVersion();
        try {
            this.enableAwake();
        }
        catch (NotAvailableStateException e) {
            logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Object)this, (Object)e);
        }
    }

    public FLyrWMS(DataStoreParameters dataStoreParameters) throws Exception {
        this();
        DataManager dataManager = DALLocator.getDataManager();
        WMSServerExplorerParameters explorerParams = (WMSServerExplorerParameters)dataManager.createServerExplorerParameters(WMSServerExplorer.NAME);
        explorerParams.setHost(((URI)dataStoreParameters.getDynValue("uri")).toString());
        WMSServerExplorer wmsServerExplorer = (WMSServerExplorer)dataManager.openServerExplorer(WMSServerExplorer.NAME, (DataServerExplorerParameters)explorerParams);
        wmsServerExplorer.connect(null, ((RemoteStoreParameters)dataStoreParameters).isDeletingCache());
        this.setParameters((DataStoreParameters)((WMSDataParameters)dataStoreParameters));
        this.setExplorer(wmsServerExplorer);
    }

    public static DataStore createDataStore(String host, IProjection srs) throws InitializeException {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        RasterDataParameters params = null;
        try {
            params = (RasterDataParameters)dataman.createServerExplorerParameters(WMSServerExplorer.NAME);
        }
        catch (InitializeException e) {
            return null;
        }
        catch (ProviderNotRegisteredException e) {
            return null;
        }
        try {
            params.setURI(new URI(host));
        }
        catch (URISyntaxException e1) {
            throw new InitializeException("Can't create URI from " + host, (Throwable)e1);
        }
        params.setSRS(srs);
        try {
            return dataman.openStore(params.getDataStoreName(), (DataStoreParameters)params);
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public void setDataStore(DataStore dataStore) throws LoadLayerException {
        this.dataStore = (RasterDataStore)dataStore;
        try {
            this.dataStore.isOpen();
            if (!this.isOpen()) {
                this.enableOpen();
            }
        }
        catch (NotAvailableStateException e) {
            logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Object)this, (Object)e);
        }
        this.setProjection(this.dataStore.getProjection());
    }

    private String getGreatFormat(Vector<String> formats) {
        for (int i = 0; i < formats.size(); ++i) {
            String format = formats.get(i);
            if (format.equals("image/jpg")) {
                return format;
            }
            if (!format.equals("image/jpeg")) continue;
            return format;
        }
        return formats.get(0);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            if (manager.getDefinition(DefaultFLyrRaster.class) == null) {
                DefaultFLyrRaster.registerPersistence();
            }
            definition = manager.addDefinition(FLyrWMS.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.extend("Persistence", "FLyrRasterSE_Persistent");
        }
        DefaultFLyrRaster.registerPersistence((DynStruct)definition);
    }

    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        DefaultFLyrRaster.RasterTaskStatus taskStatus = new DefaultFLyrRaster.RasterTaskStatus((DefaultFLyrRaster)this, "Drawing " + this.getName() + "...", cancel);
        manager.add((TaskStatus)taskStatus);
        taskStatus.setAutoremove(true);
        this.splitRequestCalculation(viewPort.getImageWidth(), viewPort.getImageHeight());
        if (!this.firstLoad) {
            try {
                this.initFilters();
                try {
                    if (!this.isOpen()) {
                        this.enableOpen();
                    }
                }
                catch (NotAvailableStateException e) {
                    throw new ReadException("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Throwable)e);
                }
            }
            catch (FilePaletteException e) {
                logger.error(e.getMessage(), (Object)this, (Object)e);
            }
            this.firstLoad = true;
        }
        this.enableStopped();
        if (this.recalcLevel) {
            double pixelSize = viewPort.getEnvelope().getLength(0) / (double)viewPort.getImageWidth();
            this.zoomLevel = this.dataStore.getNearestLevel(pixelSize);
        }
        this.recalcLevel = true;
        if (this.isWithinScale(scale)) {
            if (this.mustSplitRequest) {
                Point2D p = viewPort.getOffset();
                Rectangle r = new Rectangle((int)p.getX(), (int)p.getY(), viewPort.getImageWidth(), viewPort.getImageHeight());
                Tiling tiles = new Tiling(1023, 1023, (Rectangle2D)r);
                tiles.setAffineTransform((AffineTransform)viewPort.getAffineTransform().clone());
                for (int tileNr = 0; tileNr < tiles.getNumTiles(); ++tileNr) {
                    try {
                        ViewPort vp = tiles.getTileViewPort(viewPort, tileNr);
                        this.drawTile(g, vp, (SimpleTaskStatus)taskStatus, scale);
                        continue;
                    }
                    catch (LoadLayerException e) {
                        throw new ReadException(e.getMessage(), (Throwable)e);
                    }
                    catch (NoninvertibleTransformException e) {
                        throw new ReadException(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                try {
                    this.drawTile(g, viewPort, (SimpleTaskStatus)taskStatus, scale);
                }
                catch (LoadLayerException e) {
                    this.setAvailable(false);
                    logger.error("Server error:" + e.getMessage(), (Throwable)e);
                }
            }
        }
        this.disableStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTile(Graphics2D g, ViewPort vp, SimpleTaskStatus taskStatus, double scale) throws LoadLayerException, ReadException {
        Envelope layerEnv = this.getFullEnvelope();
        Envelope vpEnv = vp.getAdjustedEnvelope();
        if (!vpEnv.intersects(layerEnv)) {
            return;
        }
        try {
            Rectangle2D.Double vpRect = this.getRectable2DFromEnvelope(vpEnv);
            Rectangle2D.Double layerRect = this.getRectable2DFromEnvelope(layerEnv);
            Rectangle2D.Double requestedRect = new Rectangle2D.Double();
            Rectangle2D.intersect(layerRect, vpRect, requestedRect);
            double scalex = vp.getAffineTransform().getScaleX();
            double scaley = vp.getAffineTransform().getScaleY();
            int wImg = (int)Math.ceil(Math.abs(((RectangularShape)requestedRect).getWidth() * scalex));
            int hImg = (int)Math.ceil(Math.abs(((RectangularShape)requestedRect).getHeight() * scaley));
            if (wImg <= 0 || hImg <= 0) {
                return;
            }
            double worldWidth = Math.abs((double)wImg / scalex);
            double worldHeigh = Math.abs((double)hImg / scaley);
            double worldX = ((RectangularShape)requestedRect).getX() + worldWidth > layerEnv.getMaximum(0) ? layerEnv.getMaximum(0) - worldWidth : ((RectangularShape)requestedRect).getX();
            double worldY = ((RectangularShape)requestedRect).getY() + worldHeigh > layerEnv.getMaximum(1) ? layerEnv.getMaximum(1) - worldHeigh : requestedRect.getMinY();
            ((Rectangle2D)requestedRect).setRect(worldX, worldY, worldWidth, worldHeigh);
            Envelope requestedEnvelope = geomManager.createEnvelope(requestedRect.getMinX(), requestedRect.getMinY(), requestedRect.getMaxX(), requestedRect.getMaxY(), 0);
            Extent requestedExtent = this.rManager.getDataStructFactory().createExtent(requestedEnvelope.getMinimum(0), requestedEnvelope.getMaximum(1), requestedEnvelope.getMaximum(0), requestedEnvelope.getMinimum(1));
            ViewPort auxVp = (ViewPort)vp.clone();
            Dimension sz = new Dimension(wImg, hImg);
            auxVp.setImageSize(sz);
            auxVp.setEnvelope(requestedEnvelope);
            double offsetX = vp.getOffset().getX();
            if (requestedEnvelope.getMinimum(0) - vpEnv.getMinimum(0) > 0.0) {
                offsetX += (requestedEnvelope.getMinimum(0) - vpEnv.getMinimum(0)) * auxVp.getAffineTransform().getScaleX();
            }
            double offsetY = vp.getOffset().getY();
            if (requestedEnvelope.getMaximum(1) - vpEnv.getMaximum(1) < 0.0) {
                offsetY += (requestedEnvelope.getMaximum(1) - vpEnv.getMaximum(1)) * auxVp.getAffineTransform().getScaleY();
            }
            auxVp.setOffset((Point2D)new Point2D.Double(offsetX, offsetY));
            auxVp.refreshExtent();
            ViewPortData vpData = this.rManager.getDataStructFactory().createViewPortData(auxVp.getProjection(), requestedExtent, (Dimension2D)sz);
            vpData.setMat(auxVp.getAffineTransform());
            vpData.setDPI((int)auxVp.getDPI());
            this.getParameters().setExtent((Rectangle2D)requestedRect);
            if (this.getParameters().isSizeFixed()) {
                this.getParameters().setWidth((int)this.getParameters().getFixedSize().getWidth());
                this.getParameters().setHeight((int)this.getParameters().getFixedSize().getHeight());
            } else {
                this.getParameters().setWidth(wImg);
                this.getParameters().setHeight(hImg);
            }
            if (this.getDataStore().getParameters() instanceof WMSDataParameters) {
                this.getRender().draw(g, vpData, (TaskStatus)taskStatus);
            } else {
                Extent vpExtent = this.rManager.getDataStructFactory().createExtent(vpEnv.getMinimum(0), vpEnv.getMaximum(1), vpEnv.getMaximum(0), vpEnv.getMinimum(1));
                ViewPortData vp2 = this.rManager.getDataStructFactory().createViewPortData(vp.getProjection(), vpExtent, (Dimension2D)vp.getImageSize());
                vp2.setMat(vp.getAffineTransform());
                vp2.setDPI((int)vp.getDPI());
                this.getParameters().setExtent(vpExtent.toRectangle2D());
                this.getRender().drawTiledService(g, vp2, (Dimension2D)vp.getImageSize(), (TaskStatus)taskStatus);
            }
        }
        catch (ProcessInterruptedException vpRect) {
        }
        catch (CloneNotSupportedException e) {
            this.drawingError(e);
        }
        catch (QueryException e) {
            this.drawingError((Exception)((Object)e));
        }
        catch (CreateEnvelopeException e) {
            this.drawingError((Exception)((Object)e));
        }
        finally {
            taskStatus.terminate();
        }
    }

    private void drawingError(Exception e) {
        this.setAvailable(false);
        JOptionPane.showMessageDialog(null, "Problems drawing this layer:" + e.getMessage(), Messages.getText((String)"Error"), 0);
        logger.info("Problems drawing this layer:" + e.getMessage(), (Throwable)e);
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintRequestAttributeSet properties) throws ReadException {
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        DefaultFLyrRaster.RasterTaskStatus taskStatus = new DefaultFLyrRaster.RasterTaskStatus((DefaultFLyrRaster)this, "Printing " + this.getName() + "...", cancel);
        manager.add((TaskStatus)taskStatus);
        taskStatus.setAutoremove(true);
        this.splitRequestCalculation(viewPort.getImageWidth(), viewPort.getImageHeight());
        if (this.isVisible() && this.isWithinScale(scale)) {
            if (!this.mustSplitRequest) {
                this.draw(null, g, viewPort, cancel, scale);
            } else {
                Tiling tiles = new Tiling(1023, 1023, (Rectangle2D)g.getClipBounds());
                tiles.setAffineTransform((AffineTransform)viewPort.getAffineTransform().clone());
                for (int tileNr = 0; tileNr < tiles.getNumTiles(); ++tileNr) {
                    try {
                        ViewPort vp = tiles.getTileViewPort(viewPort, tileNr);
                        this.drawTile(g, vp, (SimpleTaskStatus)taskStatus, scale);
                        continue;
                    }
                    catch (NoninvertibleTransformException e) {
                        throw new ReadException(e.getMessage(), (Throwable)e);
                    }
                    catch (LoadLayerException e) {
                        throw new ReadException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        taskStatus.terminate();
    }

    public void _print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        this.draw(null, g, viewPort, cancel, scale);
    }

    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        String[] layerNames = this.getParameters().getLayerQuery().split(",");
        Vector<WMSLayerNode> layers = new Vector<WMSLayerNode>(layerNames.length);
        try {
            for (int i = 0; i < layerNames.length; ++i) {
                layers.add(i, this.getExplorer().getLayer(layerNames[i]));
            }
            info.put("name", this.getName());
            info.put("selectedLayers", layers);
            info.put("host", this.getParameters().getURI());
            info.put("srs", this.getParameters().getSRSCode());
            info.put("format", this.getParameters().getFormat());
            info.put("infoformat", this.getParameters().getInfoFormat());
            info.put("wmsTransparency", new Boolean(this.getParameters().isWmsTransparent()));
            info.put("styles", this.getParameters().getStyles());
            info.put("dimensions", this.getParameters().getDimensions());
            info.put("fixedSize", this.getParameters().getFixedSize());
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toMapContext(String mapContextVersion) {
        XmlBuilder xml = new XmlBuilder();
        String query = this.getParameters().getLayerQuery();
        String[] layerNames = query.split(",");
        List styleList = this.getParameters().getStyles();
        for (int i = 0; i < layerNames.length; ++i) {
            WMSLayerNode layer = this.getExplorer().getLayer(layerNames[i]);
            HashMap<Object, String> xmlAttrs = new HashMap<Object, String>();
            xmlAttrs.put("hidden", !this.isVisible() + "");
            xmlAttrs.put("queryable", this.getExplorer().isQueryable() + "");
            xml.openTag("Layer", xmlAttrs);
            xmlAttrs.clear();
            if (mapContextVersion.equals("1.1.0") || mapContextVersion.equals("1.0.0")) {
                int j;
                xmlAttrs.put("service", "WMS");
                xmlAttrs.put("version", this.getExplorer().getVersion());
                xmlAttrs.put("title", this.getExplorer().getServiceTitle());
                xml.openTag("Server", xmlAttrs);
                xmlAttrs.clear();
                xmlAttrs.put("xlink:type", "simple");
                xmlAttrs.put("xlink:href", this.getParameters().getURI().toString());
                xml.writeTag("OnlineResource", xmlAttrs);
                xmlAttrs.clear();
                xml.closeTag();
                xml.writeTag("Name", layer.getName().trim());
                xml.writeTag("Title", layer.getTitle().trim());
                if (layer.getAbstract() != null) {
                    xml.writeTag("Abstract", layer.getAbstract());
                }
                String[] strings = layer.getAllSrs().toArray(new String[0]);
                String mySRS = strings[0];
                for (j = 1; j < strings.length; ++j) {
                    mySRS = mySRS + "," + strings[j];
                }
                xml.writeTag("SRS", mySRS);
                xml.openTag("FormatList");
                strings = this.getExplorer().getFormats();
                for (j = 0; j < strings.length; ++j) {
                    String str = strings[j].trim();
                    if (str.equals(this.getParameters().getFormat())) {
                        xml.writeTag("Format", str, "current", "1");
                        continue;
                    }
                    xml.writeTag("Format", str);
                }
                xml.closeTag();
                xml.openTag("StyleList");
                if (layer.getStyles().size() > 0) {
                    for (j = 0; j < layer.getStyles().size(); ++j) {
                        RemoteWMSStyle st = (RemoteWMSStyle)layer.getStyles().get(j);
                        if (st.getName().equals(((RemoteWMSStyle)styleList.get(i)).getName())) {
                            xmlAttrs.put("current", "1");
                        }
                        xml.openTag("Style", xmlAttrs);
                        xmlAttrs.clear();
                        xml.writeTag("Name", st.getName());
                        xml.writeTag("Title", st.getTitle());
                        xml.closeTag();
                    }
                } else {
                    xmlAttrs.put("current", "1");
                    xml.openTag("Style", xmlAttrs);
                    xmlAttrs.clear();
                    xml.writeTag("Name", "default");
                    xml.writeTag("Title", "default");
                    xml.closeTag();
                }
                xml.closeTag();
                if (mapContextVersion.compareTo("1.0.0") > 0) {
                    xml.openTag("DimensionList");
                    xml.closeTag();
                }
            } else {
                xml.writeTag("ERROR", PluginServices.getText((Object)((Object)this), (String)"unsupported_map_context_version"));
            }
            xml.closeTag();
        }
        return xml.getXML();
    }

    public String getTocImageIcon() {
        return "icon-layer-wms";
    }

    public int[] getTileSize() {
        int[] size = new int[]{1023, 1023};
        return size;
    }

    public boolean isTiled() {
        return this.mustSplitRequest;
    }

    private void splitRequestCalculation(int width, int height) {
        RasterDataStore store = this.getDataStore();
        if (store == null) {
            String msg = "Can't get RasterDataStore associated to this layer (" + this.toString() + ").";
            logger.warn(msg);
            throw new RuntimeException(msg);
        }
        this.mustSplitRequest = !store.isTiled() && (width > 1023 || height > 1023);
    }

    public ComposedLayer newComposedLayer() {
        Preferences prefs = Preferences.userRoot().node("gvsig.wms");
        String str = prefs.get("useComposedLayer", "false");
        Boolean useComposedLayer = Boolean.TRUE;
        try {
            useComposedLayer = Boolean.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (useComposedLayer.booleanValue()) {
            return new ComposedLayerWMS();
        }
        return null;
    }

    boolean isComposedLayerCompatible(FLayer layer) {
        if (!(layer instanceof FLyrWMS)) {
            return false;
        }
        FLyrWMS aLayer = (FLyrWMS)layer;
        if (!this.getParameters().getURI().equals(aLayer.getParameters().getURI())) {
            return false;
        }
        WMSDataParameters p = this.getWMSParameters(this.getDataStore().getParameters());
        if (!p.getFormat().equals(aLayer.getParameters().getFormat())) {
            return false;
        }
        if (!p.getSRS().equals(aLayer.getParameters().getSRS())) {
            return false;
        }
        if (p.getInfoLayerQuery() != null ? !p.getInfoLayerQuery().equals(aLayer.getParameters().getInfoLayerQuery()) : p.getInfoLayerQuery() != null) {
            return false;
        }
        if (this.getParameters().getFixedSize() != null && aLayer.getParameters().getFixedSize() != null ? this.getParameters().getFixedSize().equals(aLayer.getParameters().getFixedSize()) : this.getParameters().getFixedSize() != null != (aLayer.getParameters().getFixedSize() != null)) {
            return false;
        }
        if (p.getDimensions() != null && aLayer.getParameters().getDimensions() != null) {
            if (p.getDimensions().size() != aLayer.getParameters().getDimensions().size()) {
                return false;
            }
            Iterator iter = p.getDimensions().iterator();
            while (iter.hasNext()) {
                if (aLayer.getParameters().getDimensions().contains(iter.next())) continue;
                return false;
            }
        } else if (p.getDimensions() != null != (aLayer.getParameters().getDimensions() != null)) {
            return false;
        }
        return true;
    }

    public boolean isActionEnabled(int action) {
        switch (action) {
            case 0: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: {
                return false;
            }
            case 20: {
                return true;
            }
        }
        return super.isActionEnabled(action);
    }

    public ILegend getLegend() {
        Image img;
        if (this.getDataStore() != null && (img = this.getDataStore().getImageLegend()) != null) {
            return new ImageLegend(img);
        }
        return null;
    }

    public boolean isRemote() {
        return true;
    }

    public boolean overviewsSupport() {
        return false;
    }

    protected void updateDrawVersion() {
        if (this.disableUpdateDrawVersion != null) {
            Thread curThread = Thread.currentThread();
            Iterator<WeakReference<Thread>> iter = this.disableUpdateDrawVersion.iterator();
            while (iter.hasNext()) {
                Thread aThread = (Thread)iter.next().get();
                if (aThread == null) {
                    iter.remove();
                    continue;
                }
                if (!aThread.equals(curThread)) continue;
                return;
            }
        }
        super.updateDrawVersion();
    }

    protected void disableUpdateDrawVersion() {
        if (this.disableUpdateDrawVersion == null) {
            this.disableUpdateDrawVersion = new ArrayList<WeakReference<Thread>>();
        }
        this.disableUpdateDrawVersion.add(new WeakReference<Thread>(Thread.currentThread()));
    }

    protected void enableUpdateDrawVersion() {
        if (this.disableUpdateDrawVersion == null) {
            return;
        }
        Thread curThread = Thread.currentThread();
        Iterator<WeakReference<Thread>> iter = this.disableUpdateDrawVersion.iterator();
        while (iter.hasNext()) {
            Thread aThread = (Thread)iter.next().get();
            if (aThread == null) {
                iter.remove();
                continue;
            }
            if (!aThread.equals(curThread)) continue;
            iter.remove();
            break;
        }
    }

    private Rectangle2D.Double getRectable2DFromEnvelope(Envelope env) {
        return new Rectangle2D.Double(env.getMinimum(0), env.getMinimum(1), env.getLength(0), env.getLength(1));
    }

    public String getFileFormat() {
        return "WMS";
    }

    public FLayer getFileLayer() throws RasterDriverException {
        return null;
    }

    public Envelope getFullEnvelope() {
        ICoordTrans ct;
        Extent e1 = this.getDataStore().getExtent();
        Envelope rAux = null;
        try {
            rAux = geomManager.createEnvelope(e1.getMin().getX(), e1.getMin().getY(), e1.getMax().getX(), e1.getMax().getY(), 0);
        }
        catch (CreateEnvelopeException exc) {
            logger.error("Error creating the envelope", (Throwable)exc);
        }
        if (rAux == null || rAux.getMaximum(0) - rAux.getMinimum(0) == 0.0 && rAux.getMaximum(1) - rAux.getMinimum(1) == 0.0) {
            try {
                rAux = geomManager.createEnvelope(0.0, 0.0, 100.0, 100.0, 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
        if ((ct = this.getCoordTrans()) != null) {
            Point2D pt1 = new Point2D.Double(rAux.getMinimum(0), rAux.getMinimum(1));
            Point2D pt2 = new Point2D.Double(rAux.getMaximum(0), rAux.getMaximum(1));
            pt1 = ct.convert(pt1, null);
            pt2 = ct.convert(pt2, null);
            try {
                rAux = geomManager.createEnvelope(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
        return rAux;
    }

    public Extent getFullRasterExtent() {
        return this.getExtentFromEnvelope(this.getFullEnvelope());
    }

    public DynObjectSet getInfo(Point p, double tolerance) throws LoadLayerException, DataException {
        java.awt.Point p1 = new java.awt.Point((int)p.getX(), (int)p.getY());
        return this.getInfo(p1, tolerance, null, false);
    }

    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel, boolean fast) throws LoadLayerException, DataException {
        String fInfo;
        ViewPort viewPort = this.getMapContext().getViewPort();
        this.getParameters().setExtent((Rectangle2D)this.getRectable2DFromEnvelope(viewPort.getAdjustedEnvelope()));
        if (this.getParameters().isSizeFixed()) {
            this.getParameters().setWidth((int)this.getParameters().getFixedSize().getWidth());
            this.getParameters().setHeight((int)this.getParameters().getFixedSize().getHeight());
        } else {
            this.getParameters().setWidth(viewPort.getImageWidth());
            this.getParameters().setHeight(viewPort.getImageHeight());
        }
        CancelTaskImpl cancellable = new CancelTaskImpl(cancel);
        this.getParameters().setCancellable((ICancellable)cancellable);
        try {
            Extent bbox = this.getExtentFromEnvelope(viewPort.getAdjustedEnvelope());
            fInfo = this.getDataStore().getInfoByPoint(p.getX(), p.getY(), bbox, viewPort.getImageWidth(), viewPort.getImageHeight(), (ICancellable)cancellable);
        }
        catch (InfoByPointException e) {
            throw new LoadLayerException("Error in getInfoByPoint", (Throwable)e);
        }
        return new DynObjectSetWMSInfo(fInfo, this.getParameters().getInfoFormat());
    }

    private Extent getExtentFromEnvelope(Envelope env) {
        double minx = env.getMinimum(0);
        double miny = env.getMinimum(1);
        double maxx = env.getMaximum(0);
        double maxy = env.getMaximum(1);
        Point2D.Double ul = new Point2D.Double(minx, maxy);
        Point2D.Double ur = new Point2D.Double(maxx, maxy);
        Point2D.Double ll = new Point2D.Double(minx, miny);
        Point2D.Double lr = new Point2D.Double(maxx, miny);
        return this.rManager.getDataStructFactory().createExtent((Point2D)ul, (Point2D)lr, (Point2D)ur, (Point2D)ll);
    }

    public void setParameters(DataStoreParameters params) throws InitializeException {
        if (params instanceof TileDataParameters) {
            ((TileDataParameters)params).deleteCache(this.deleteCache);
        }
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            DataParameters p;
            DataStore dStore = dataman.openStore(params.getDataStoreName(), params);
            this.setDataStore(dStore);
            if (params instanceof WMSDataParameters) {
                this.setName(((WMSDataParameters)params).getURI().getPath());
            }
            if (params instanceof TileDataParameters && (p = ((TileDataParameters)params).getDataParameters()) instanceof WMSDataParameters) {
                this.setName(((WMSDataParameters)p).getURI().getPath());
            }
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (LoadLayerException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public WMSDataParameters getParameters() {
        return this.getWMSParameters(this.getDataStore().getParameters());
    }

    private WMSDataParameters getWMSParameters(DataStoreParameters parameters) {
        DataParameters p;
        WMSDataParameters params = null;
        if (parameters instanceof WMSDataParameters) {
            params = (WMSDataParameters)parameters;
        }
        if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof WMSDataParameters) {
            params = (WMSDataParameters)p;
        }
        return params;
    }

    public void deleteCache(boolean deleteCache) {
        this.deleteCache = deleteCache;
    }

    public void setExplorer(WMSServerExplorer explorer) {
        if (this.getDataStore() != null) {
            this.getDataStore().setExplorer((RasterDataServerExplorer)explorer);
        }
    }

    public WMSServerExplorer getExplorer() {
        try {
            return (WMSServerExplorer)this.getDataStore().getExplorer();
        }
        catch (ValidateDataParametersException e) {
            logger.debug("Error getting the explorer", (Throwable)e);
        }
        catch (DataException e) {
            logger.debug("Error getting the explorer", (Throwable)e);
        }
        return null;
    }

    public FLayer cloneLayer() throws Exception {
        return super.cloneLayer();
    }

    public boolean isInside(Point2D p) {
        return this.rManager.getRasterUtils().isInside(p, this.getDataStore().getExtent());
    }
}

