/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.wmc;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.coverage.exception.ImportMapContextException;
import org.gvsig.fmap.mapcontext.exceptions.UnsupportedVersionLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.wms.app.wmsclient.layer.FLyrWMS;
import org.gvsig.raster.wms.app.wmsclient.wmc.XmlBuilder;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSDataParametersImpl;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class WebMapContext {
    public static final String FILE_EXTENSION = ".cml";
    private Logger log = LoggerFactory.getLogger(WebMapContext.class);
    static final ArrayList<String> supportedVersions = new ArrayList();
    public static final ArrayList<String> exportVersions = new ArrayList();
    private static HashSet supportedLayers = new HashSet();
    private File mapContextFile;
    private String encoding = "UTF-8";
    private String WMC_START_TAG;
    public String fileVersion = null;
    public Dimension windowSize = null;
    public String srs = null;
    public Rectangle2D bBox = null;
    public String title = null;
    public String id = null;
    public String xmlns = null;
    public String xmlns_xlink = null;
    public String xmlns_xsi = null;
    public String xsi_schemaLocation = null;
    public String _abstract = null;
    public List<String> keywordList = null;
    public Dimension logoURLSize = null;
    public String logoURLFormat = null;
    public String logoURL = null;
    public String descriptionURLFormat = null;
    public String descriptionURL = null;
    public boolean contactInfo = false;
    public String contactPerson = null;
    public String contactOrganization = null;
    public String contactPosition = null;
    public String address = null;
    public String city = null;
    public String stateOrProvince = null;
    public String postCode = null;
    public String country = null;
    public String telephone = null;
    public String fax = null;
    public String email = null;
    private StringBuffer errorMessages;
    List<FLyrWMS> layerList = null;
    List<WMSDataParameters> paramsList = null;
    Hashtable<Object, String[]> srsList = null;
    Hashtable<String, String> serverTitles = null;
    Hashtable layerAbstracts = null;
    Hashtable layerFormats = null;
    Hashtable layerStyles = null;

    public void readFile(File file) throws UnsupportedVersionLayerException, ImportMapContextException {
        this.mapContextFile = file;
        this.errorMessages = new StringBuffer();
        if (this.getVersion() != null) {
            if (supportedVersions.contains(this.getVersion())) {
                this.WMC_START_TAG = "ViewContext";
                if (this.getVersion().equals("0.1.4")) {
                    this.WMC_START_TAG = "WMS_Viewer_Context";
                    this.parse1_1_0(file);
                } else if (this.getVersion().equals("1.1.0")) {
                    this.parse1_1_0(file);
                } else if (this.getVersion().equals("1.0.0")) {
                    this.parse1_1_0(file);
                } else {
                    this.parseDefaultVersion(file);
                }
                if (this.errorMessages.length() > 0) {
                    throw new ImportMapContextException(this.errorMessages.toString(), false);
                }
            } else {
                throw new UnsupportedVersionLayerException(file.getName(), null);
            }
        }
    }

    private void parseDefaultVersion(File file) throws ImportMapContextException {
        this.parse1_1_0(file);
    }

    private String getVersion() {
        if (this.fileVersion == null) {
            String v = null;
            try {
                FileReader fr = new FileReader(this.mapContextFile);
                KXmlParser parser = new KXmlParser();
                parser.setInput((Reader)fr);
                parser.nextTag();
                if (parser.getEventType() != 1 && (parser.getName().compareTo("ViewContext") == 0 || parser.getName().compareTo("WMS_Viewer_Context") == 0)) {
                    v = parser.getAttributeValue("", "version");
                }
            }
            catch (FileNotFoundException fr) {
            }
            catch (XmlPullParserException xmlEx) {
                xmlEx.printStackTrace();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileVersion = v;
        }
        return this.fileVersion;
    }

    private void readEnconding(File file) {
        FileReader fr = null;
        try {
            fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            char[] buffer = new char[100];
            br.read(buffer);
            StringBuffer st = new StringBuffer(new String(buffer));
            String searchText = "encoding=\"";
            int index = st.indexOf(searchText);
            if (index > -1) {
                st.delete(0, index + searchText.length());
                this.encoding = st.substring(0, st.indexOf("\""));
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException ex) {
            this.log.info("Error reading the encoding", (Throwable)ex);
        }
        catch (IOException e) {
            this.log.info("Error reading the encoding", (Throwable)e);
        }
    }

    private void parse1_1_0(File file) throws ImportMapContextException {
        block19: {
            try {
                this.readEnconding(file);
                KXmlParser parser = new KXmlParser();
                parser.setInput((InputStream)new FileInputStream(file), this.encoding);
                int tag = parser.nextTag();
                if (parser.getEventType() == 1) break block19;
                parser.require(2, null, this.WMC_START_TAG);
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo(this.WMC_START_TAG) == 0) {
                                this.id = parser.getAttributeValue("", "id");
                                this.xmlns = parser.getAttributeValue("", "xmlns");
                                this.xmlns_xlink = parser.getAttributeValue("", "xmlns:xlink");
                                this.xmlns_xsi = parser.getAttributeValue("", "xmlns:xsi");
                                this.xsi_schemaLocation = parser.getAttributeValue("", "xsi:schemaLocation");
                                break;
                            }
                            if (parser.getName().compareTo("General") == 0) {
                                this.parseGeneral1_1_0(parser);
                                break;
                            }
                            if (parser.getName().compareTo("LayerList") == 0) {
                                int layerListTag = parser.nextTag();
                                boolean bLayerListEnd = false;
                                this.layerList = new ArrayList<FLyrWMS>();
                                this.paramsList = new ArrayList<WMSDataParameters>();
                                while (!bLayerListEnd) {
                                    switch (layerListTag) {
                                        case 2: {
                                            if (parser.getName().compareTo("Layer") == 0) {
                                                FLyrWMS layer = new FLyrWMS();
                                                WMSDataParametersImpl dataParameters = new WMSDataParametersImpl();
                                                dataParameters.setSRS(this.srs);
                                                this.parseLayer1_1_0(parser, layer, (WMSDataParameters)dataParameters);
                                                IProjection proj = CRSFactory.getCRS((String)this.srs);
                                                if (proj == null) {
                                                    String msg = Messages.getText((String)"unsupported_crs") + " (" + this.srs + ")";
                                                    throw new ImportMapContextException(msg, true);
                                                }
                                                dataParameters.setWmsTransparency(true);
                                                this.layerList.add(layer);
                                                this.paramsList.add((WMSDataParameters)dataParameters);
                                                break;
                                            }
                                            this.log.info("Unrecognized " + parser.getName());
                                            break;
                                        }
                                        case 3: {
                                            if (parser.getName().compareTo("LayerList") != 0) break;
                                            bLayerListEnd = true;
                                            break;
                                        }
                                    }
                                    layerListTag = parser.next();
                                }
                                break;
                            }
                            if (parser.getName().compareTo("DimensionList") == 0) {
                                this.log.info("WebMapContext's Dimension not yet implemented");
                                break;
                            }
                            this.log.info("Unrecognized " + parser.getName());
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
            catch (ImportMapContextException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.debug(Messages.getText((String)"map_context_file_error"), (Throwable)e);
            }
        }
    }

    private void parseGeneral1_1_0(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("Window") == 0) {
                        if (this.windowSize == null) {
                            this.windowSize = new Dimension();
                        }
                        this.windowSize.setSize(Integer.parseInt(parser.getAttributeValue("", "width")), Integer.parseInt(parser.getAttributeValue("", "height")));
                        break;
                    }
                    if (parser.getName().compareTo("BoundingBox") == 0) {
                        this.srs = parser.getAttributeValue("", "SRS");
                        double minx = Double.parseDouble(parser.getAttributeValue("", "minx"));
                        double miny = Double.parseDouble(parser.getAttributeValue("", "miny"));
                        double maxx = Double.parseDouble(parser.getAttributeValue("", "maxx"));
                        double maxy = Double.parseDouble(parser.getAttributeValue("", "maxy"));
                        this.bBox = new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
                        break;
                    }
                    if (parser.getName().compareTo("Title") == 0) {
                        this.title = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("Abstract") == 0) {
                        this._abstract = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("KeywordList") == 0) {
                        this.keywordList = new ArrayList<String>();
                        boolean keywordEnd = false;
                        int keywordTag = parser.next();
                        while (!keywordEnd) {
                            switch (keywordTag) {
                                case 2: {
                                    if (parser.getName().compareTo("Keyword") == 0) {
                                        this.keywordList.add(parser.nextText());
                                        break;
                                    }
                                    System.out.println("Unrecognized " + parser.getName());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("KeywordList") != 0) break;
                                    keywordEnd = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            keywordTag = parser.next();
                        }
                        break;
                    }
                    if (parser.getName().compareTo("LogoURL") == 0) {
                        this.logoURLSize = new Dimension(Integer.parseInt(parser.getAttributeValue("", "width")), Integer.parseInt(parser.getAttributeValue("", "height")));
                        this.logoURLFormat = parser.getAttributeValue("", "Format".toLowerCase());
                        parser.nextTag();
                        if (parser.getName().compareTo("OnlineResource") == 0) {
                            this.logoURL = parser.getAttributeValue("", "xlink:href");
                            break;
                        }
                        System.out.println("Unrecognized " + parser.getName());
                        break;
                    }
                    if (parser.getName().compareTo("DescriptionURL") == 0) {
                        this.descriptionURLFormat = parser.getAttributeValue("", "Format".toLowerCase());
                        parser.nextTag();
                        if (parser.getName().compareTo("OnlineResource") == 0) {
                            this.descriptionURL = parser.getAttributeValue("", "xlink:href");
                            break;
                        }
                        System.out.println("Unrecognized " + parser.getName());
                        break;
                    }
                    if (parser.getName().compareTo("ContactInformation") == 0) {
                        boolean contactInfoEnd = false;
                        int contactInfoTag = parser.next();
                        while (!contactInfoEnd) {
                            switch (contactInfoTag) {
                                case 2: {
                                    if (parser.getName().compareTo("ContactPerson") == 0) {
                                        this.contactPerson = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("ContactOrganization") == 0) {
                                        this.contactOrganization = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("ContactPosition") == 0) {
                                        this.contactPosition = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("Address") == 0) {
                                        this.address = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("City") == 0) {
                                        this.city = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("StateOrProvince") == 0) {
                                        this.stateOrProvince = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("PostCode") == 0) {
                                        this.postCode = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("Country") == 0) {
                                        this.country = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("ContactVoiceTelephone") == 0) {
                                        this.telephone = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("ContactFacsimileTelephone") == 0) {
                                        this.fax = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("ContactElectronicMailAddress") == 0) {
                                        this.email = parser.nextText();
                                        break;
                                    }
                                    if (parser.getName().compareTo("ContactPersonPrimary") == 0 || parser.getName().compareTo("ContactAddress") == 0) break;
                                    System.out.println("Unrecognized " + parser.getName());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("ContactInformation") != 0) break;
                                    contactInfoEnd = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            contactInfoTag = parser.next();
                        }
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("General") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            tag = parser.next();
        }
    }

    private void parseLayer1_1_0(KXmlParser parser, FLyrWMS layer, WMSDataParameters dataParameters) throws XmlPullParserException, IOException {
        boolean end = false;
        String queryable = parser.getAttributeValue("", "queryable");
        dataParameters.setQueryable(queryable != null && (queryable.equals("1") || queryable.toLowerCase().equals("true")));
        ArrayList<RemoteWMSStyle> styles = new ArrayList<RemoteWMSStyle>();
        String hidden = parser.getAttributeValue("", "hidden");
        layer.setVisible(hidden == null || !hidden.equals("1") || !hidden.toLowerCase().equals("true"));
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("Server") == 0) {
                        URI uri;
                        String serverTitle = parser.getAttributeValue("", "Title".toLowerCase());
                        parser.nextTag();
                        if (parser.getName().compareTo("OnlineResource") != 0) break;
                        String uriStr = parser.getAttributeValue("", "xlink:href");
                        try {
                            uri = new URI(uriStr);
                        }
                        catch (URISyntaxException e) {
                            throw new IOException("Can't create URI from " + uriStr, e);
                        }
                        dataParameters.setURI(uri);
                        if (this.serverTitles == null) {
                            this.serverTitles = new Hashtable();
                        }
                        this.serverTitles.put(uriStr, serverTitle);
                        break;
                    }
                    if (parser.getName().compareTo("Title") == 0) {
                        layer.setName(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("Name") == 0) {
                        dataParameters.setLayerQuery(parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("Abstract") == 0) {
                        if (this.layerAbstracts == null) {
                            this.layerAbstracts = new Hashtable();
                        }
                        this.layerAbstracts.put(layer, parser.nextText());
                        break;
                    }
                    if (parser.getName().compareTo("SRS") == 0) {
                        String[] srss = this.parseEPSGList(parser.nextText());
                        if (this.srsList == null) {
                            this.srsList = new Hashtable();
                        }
                        this.srsList.put((Object)layer, srss);
                        break;
                    }
                    if (parser.getName().compareTo("FormatList") == 0) {
                        int formatsTag = parser.nextTag();
                        boolean bFormatsEnd = false;
                        ArrayList<String> formats = new ArrayList<String>();
                        while (!bFormatsEnd) {
                            switch (formatsTag) {
                                case 2: {
                                    if (parser.getName().compareTo("Format") == 0) {
                                        String current = parser.getAttributeValue("", "current");
                                        String format = parser.nextText();
                                        if (current != null && current.equals("1")) {
                                            dataParameters.setFormat(format);
                                        }
                                        formats.add(format);
                                        break;
                                    }
                                    this.log.info("Unrecognized " + parser.getName());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("FormatList") != 0) break;
                                    bFormatsEnd = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    this.log.info("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            formatsTag = parser.next();
                        }
                        if (this.layerFormats == null) {
                            this.layerFormats = new Hashtable();
                        }
                        this.layerFormats.put(layer, formats.toArray(new String[0]));
                        break;
                    }
                    if (parser.getName().compareTo("StyleList") == 0) {
                        int stylesTag = parser.nextTag();
                        boolean bStylesEnd = false;
                        while (!bStylesEnd) {
                            switch (stylesTag) {
                                case 2: {
                                    if (parser.getName().compareTo("Style") == 0) {
                                        String current = parser.getAttributeValue("", "current");
                                        RemoteWMSStyle style = this.parseStyle1_1_0(parser);
                                        if (current != null && current.equals("1") && !style.getName().equals("default")) {
                                            style.setName("default");
                                        }
                                        styles.add(style);
                                        break;
                                    }
                                    System.out.println("Unrecognized " + parser.getName());
                                    break;
                                }
                                case 3: {
                                    if (parser.getName().compareTo("StyleList") != 0) break;
                                    bStylesEnd = true;
                                    break;
                                }
                                case 4: {
                                    if (parser.getName() == null) break;
                                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                                }
                            }
                            stylesTag = parser.next();
                        }
                        if (this.layerStyles == null) {
                            this.layerStyles = new Hashtable();
                        }
                        this.layerStyles.put(layer, styles.toArray(new RemoteWMSStyle[0]));
                        break;
                    }
                    this.log.info("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Layer") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            tag = parser.next();
        }
        dataParameters.setStyles(styles);
    }

    private String[] parseEPSGList(String nextText) {
        String[] epsglist = nextText.split(",");
        return epsglist;
    }

    private RemoteWMSStyle parseStyle1_1_0(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        String styleName = null;
        String styleAbstract = null;
        String styleTitle = null;
        int legendWidth = -1;
        int legendHeight = -1;
        String legendType = null;
        String legendHref = null;
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("Name") == 0) {
                        styleName = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("Abstract") == 0) {
                        styleAbstract = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("Title") == 0) {
                        styleTitle = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("LegendURL") == 0) {
                        legendWidth = Integer.parseInt(parser.getAttributeValue("", "width"));
                        legendHeight = Integer.parseInt(parser.getAttributeValue("", "height"));
                        parser.nextTag();
                        if (parser.getName().compareTo("OnlineResource") != 0) break;
                        legendType = parser.getAttributeValue("", "xlink:type");
                        legendHref = parser.getAttributeValue("", "xlink:href");
                        break;
                    }
                    System.out.println("Unrecognized " + parser.getName());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Style") != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (parser.getName() == null) break;
                    System.out.println("[TAG][" + parser.getName() + "]\n[TEXT][" + parser.getText().trim() + "]");
                }
            }
            tag = parser.next();
        }
        RemoteWMSStyle sty = new RemoteWMSStyle();
        sty.setName(styleName);
        sty.setTitle(styleTitle);
        sty.setStyleAbstract(styleAbstract);
        sty.setLegendWidth(legendWidth);
        sty.setLegendHeight(legendHeight);
        sty.setType(legendType);
        sty.setHref(legendHref);
        sty.setParent(null);
        return sty;
    }

    private String createMapContext1_1_0(DefaultViewDocument v) {
        int i;
        ArrayList layersToExport = WebMapContext.getExportableLayers(v);
        XmlBuilder xml = new XmlBuilder();
        HashMap<Object, String> xmlAttrs = new HashMap<Object, String>();
        xml.setEncoding("ISO-8859-1");
        xml.writeHeader();
        String viewContextTag = this.fileVersion.equals("0.1.4") ? "WMS_Viewer_Context" : "ViewContext";
        xml.writeRaw("<!-- " + Messages.getText((String)"created_with") + " gvSIG " + ApplicationLocator.getManager().getVersion() + " -->");
        xmlAttrs.put("version", this.fileVersion);
        xmlAttrs.put("id", this.id);
        xmlAttrs.put("xmlns", "http://www.opengis.net/context");
        xmlAttrs.put("xmlns:xlink", "http://www.w3.org/1999/xlink");
        xmlAttrs.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlAttrs.put("xsi:schemaLocation", "http://www.opengeospatial.net/context context.xsd");
        xml.openTag(viewContextTag, xmlAttrs);
        xmlAttrs.clear();
        xml.openTag("General");
        if (this.windowSize != null) {
            xmlAttrs.put("width", (int)this.windowSize.getWidth() + "");
            xmlAttrs.put("height", (int)this.windowSize.getHeight() + "");
            xml.writeTag("Window", xmlAttrs);
            xmlAttrs.clear();
        }
        xmlAttrs.put("SRS", v.getProjection().getAbrev());
        xmlAttrs.put("minx", this.bBox.getMinX() + "");
        xmlAttrs.put("miny", this.bBox.getMinY() + "");
        xmlAttrs.put("maxx", this.bBox.getMaxX() + "");
        xmlAttrs.put("maxy", this.bBox.getMaxY() + "");
        xml.writeTag("BoundingBox", xmlAttrs);
        xmlAttrs.clear();
        xml.writeTag("Title", this.title.trim());
        if (this._abstract != null) {
            xml.writeTag("Abstract", this._abstract.trim());
        }
        if (this.logoURL != null) {
            xml.writeTag("LogoURL", this.logoURL.trim());
        }
        if (this.descriptionURL != null) {
            xml.writeTag("DescriptionURL", this.descriptionURL.trim());
        }
        if (this.contactInfo) {
            xml.openTag("ContactInformation");
            if (this.contactPerson != null || this.contactOrganization != null) {
                xml.openTag("ContactPersonPrimary");
                if (this.contactPerson != null) {
                    xml.writeTag("ContactPerson", this.contactPerson.trim());
                }
                if (this.contactOrganization != null) {
                    xml.writeTag("ContactOrganization", this.contactOrganization.trim());
                }
                xml.closeTag();
            }
            xml.closeTag();
            if (this.contactPosition != null) {
                xml.writeTag("ContactPosition", this.contactPosition.trim());
            }
            if (this.address != null || this.city != null || this.stateOrProvince != null || this.postCode != null || this.country != null) {
                xml.openTag("ContactAddress");
                xml.writeTag("AddressType", "Postal");
                if (this.address != null) {
                    xml.writeTag("Address", this.address.trim());
                }
                if (this.city != null) {
                    xml.writeTag("City", this.city.trim());
                }
                if (this.stateOrProvince != null) {
                    xml.writeTag("StateOrProvince", this.stateOrProvince.trim());
                }
                if (this.postCode != null) {
                    xml.writeTag("PostCode", this.postCode.trim());
                }
                if (this.country != null) {
                    xml.writeTag("Country", this.country.trim());
                }
                xml.closeTag();
            }
            if (this.telephone != null) {
                xml.writeTag("ContactVoiceTelephone", this.telephone.trim());
            }
            if (this.fax != null) {
                xml.writeTag("ContactFacsimileTelephone", this.fax.trim());
            }
            if (this.email != null) {
                xml.writeTag("ContactElectronicMailAddress", this.email.trim());
            }
        }
        xml.openTag("KeywordList");
        if (this.keywordList != null) {
            for (i = 0; i < this.keywordList.size(); ++i) {
                xml.writeTag("Keyword", this.keywordList.get(i).trim());
            }
        } else {
            xml.writeTag("Keyword", "");
        }
        xml.closeTag();
        xml.closeTag();
        xml.openTag("LayerList");
        for (i = 0; i < layersToExport.size(); ++i) {
            xml.writeRaw(((FLyrWMS)((Object)layersToExport.get(i))).toMapContext(this.fileVersion));
        }
        xml.closeTag();
        xml.closeTag();
        return xml.getXML();
    }

    public String toXML(DefaultViewDocument v) {
        if (this.fileVersion.equals("1.1.0") || this.fileVersion.equals("1.0.0") || this.fileVersion.equals("0.1.4")) {
            return this.createMapContext1_1_0(v);
        }
        return null;
    }

    public static ArrayList getExportableLayers(DefaultViewDocument v) {
        ArrayList list = new ArrayList();
        FLayers lyrs = v.getMapContext().getLayers();
        list.addAll(WebMapContext._getExportableLayers((FLayer)lyrs));
        return list;
    }

    private static ArrayList _getExportableLayers(FLayer lyr) {
        ArrayList<FLayer> list = new ArrayList<FLayer>();
        if (WebMapContext.checkType(lyr)) {
            list.add(lyr);
        } else if (lyr instanceof FLayers) {
            FLayers lyrs = (FLayers)lyr;
            for (int i = 0; i < lyrs.getLayersCount(); ++i) {
                list.addAll(WebMapContext._getExportableLayers(lyrs.getLayer(i)));
            }
        }
        return list;
    }

    private static boolean checkType(FLayer lyr) {
        return supportedLayers.contains(lyr.getClass());
    }

    public static boolean containsExportableLayers(FLayer layer) {
        if (WebMapContext.checkType(layer)) {
            return true;
        }
        if (layer instanceof FLayers) {
            FLayers layers = (FLayers)layer;
            for (int i = 0; i < layers.getLayersCount(); ++i) {
                FLayer lyr = layers.getLayer(i);
                if (!WebMapContext.containsExportableLayers(lyr)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        supportedVersions.add("1.1.0");
        supportedVersions.add("1.0.0");
        supportedVersions.add("0.1.4");
        exportVersions.add("1.1.0");
        exportVersions.add("1.0.0");
        exportVersions.add("0.1.4");
        supportedLayers.add(FLyrWMS.class);
    }
}

