/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.wmc;

import java.util.HashMap;
import java.util.Stack;

public class XmlBuilder {
    private static final int DEF_XMLDOC_SIZE = 256;
    private static final String PAD = "  ";
    private static final int NUM_PADSTRINGS = 20;
    private static final byte[] NEWLINE_BYTES = "\n".getBytes();
    private static String[] s_padStrings = new String[20];
    private static String s_newlineXmlEnc;
    private StringBuffer m_xml = new StringBuffer(256);
    private StringBuffer m_encodeBuf = new StringBuffer(40);
    private String m_pad = "";
    private boolean m_autoPad;
    protected Stack<String> m_openElements = new Stack();
    private int m_padLevel = 0;
    private String encoding = "UTF-8";

    public XmlBuilder() {
        this(true);
    }

    public XmlBuilder(boolean autoPad) {
        this.m_autoPad = autoPad;
        this.m_padLevel = 0;
        this.m_pad = s_padStrings[this.m_padLevel];
    }

    public void reset() {
        this.m_padLevel = 0;
        this.m_pad = s_padStrings[this.m_padLevel];
        this.m_xml.setLength(0);
    }

    public void writeRaw(String raw) {
        this.m_xml.append(raw);
    }

    public void writeComment(String comment) {
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<!-- ");
        XmlBuilder.encode(comment, this.m_xml);
        this.m_xml.append(" -->\n");
    }

    public void writeHeader() {
        String HEADER = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n";
        this.m_xml.append(HEADER);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void writeTag(String name, String data) {
        name = this.encode(name);
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        this.m_xml.append(name);
        this.m_xml.append(">");
        XmlBuilder.encode(data, this.m_xml);
        this.m_xml.append("</");
        this.m_xml.append(name);
        this.m_xml.append(">");
    }

    public void writeTag(String name, HashMap<Object, String> attributes) {
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        XmlBuilder.encode(name, this.m_xml);
        this.m_xml.append(" ");
        Object[] elems = attributes.keySet().toArray();
        for (int i = 0; i < elems.length; ++i) {
            String nm = (String)elems[i];
            String val = attributes.get(nm);
            XmlBuilder.encode(nm, this.m_xml);
            this.m_xml.append("=\"");
            XmlBuilder.encode(val, this.m_xml);
            this.m_xml.append("\" ");
        }
        this.m_xml.append("/>");
    }

    public void writeTag(String name, String attr1Name, String attr1Value, String attr2Name, String attr2Value) {
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        XmlBuilder.encode(name, this.m_xml);
        this.m_xml.append(" ");
        XmlBuilder.encode(attr1Name, this.m_xml);
        this.m_xml.append("=\"");
        XmlBuilder.encode(attr1Value, this.m_xml);
        this.m_xml.append("\" ");
        XmlBuilder.encode(attr2Name, this.m_xml);
        this.m_xml.append("=\"");
        XmlBuilder.encode(attr2Value, this.m_xml);
        this.m_xml.append("\" ");
        this.m_xml.append("/>");
    }

    public void writeTag(String name, String data, String attrName, String attrValue) {
        name = this.encode(name);
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        this.m_xml.append(name);
        this.m_xml.append(" ");
        XmlBuilder.encode(attrName, this.m_xml);
        this.m_xml.append("=\"");
        XmlBuilder.encode(attrValue, this.m_xml);
        this.m_xml.append("\" ");
        this.m_xml.append(">");
        XmlBuilder.encode(data, this.m_xml);
        this.m_xml.append("</");
        this.m_xml.append(name);
        this.m_xml.append(">");
    }

    public void writeTag(String name, String data, String attr1Name, String attr1Value, String attr2Name, String attr2Value) {
        name = this.encode(name);
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        this.m_xml.append(name);
        this.m_xml.append(" ");
        XmlBuilder.encode(attr1Name, this.m_xml);
        this.m_xml.append("=\"");
        XmlBuilder.encode(attr1Value, this.m_xml);
        this.m_xml.append("\" ");
        XmlBuilder.encode(attr2Name, this.m_xml);
        this.m_xml.append("=\"");
        XmlBuilder.encode(attr2Value, this.m_xml);
        this.m_xml.append("\" ");
        this.m_xml.append(">");
        XmlBuilder.encode(data, this.m_xml);
        this.m_xml.append("</");
        this.m_xml.append(name);
        this.m_xml.append(">");
    }

    public void writeTag(String name, String data, HashMap<Object, String> attributes) {
        name = this.encode(name);
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        this.m_xml.append(name);
        this.m_xml.append(" ");
        Object[] elems = attributes.keySet().toArray();
        for (int i = 0; i < elems.length; ++i) {
            String nm = (String)elems[i];
            String val = attributes.get(nm);
            XmlBuilder.encode(nm, this.m_xml);
            this.m_xml.append("=\"");
            XmlBuilder.encode(val, this.m_xml);
            this.m_xml.append("\" ");
        }
        this.m_xml.append(">");
        XmlBuilder.encode(data, this.m_xml);
        this.m_xml.append("</");
        this.m_xml.append(name);
        this.m_xml.append(">");
    }

    public void openTag(String name) {
        name = this.encode(name);
        this.m_openElements.push(name);
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        this.m_xml.append(name);
        this.m_xml.append(">");
        if (this.m_autoPad) {
            ++this.m_padLevel;
            this.m_pad = this.m_padLevel < 20 ? s_padStrings[this.m_padLevel] : this.m_pad + PAD;
        }
    }

    public void openTag(String name, String attrName, String attrValue) {
        name = this.encode(name);
        this.m_openElements.push(name);
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        this.m_xml.append(name);
        this.m_xml.append(" ");
        XmlBuilder.encode(attrName, this.m_xml);
        this.m_xml.append("=\"");
        XmlBuilder.encode(attrValue, this.m_xml);
        this.m_xml.append("\" ");
        this.m_xml.append(">");
        if (this.m_autoPad) {
            ++this.m_padLevel;
            this.m_pad = this.m_padLevel < 20 ? s_padStrings[this.m_padLevel] : this.m_pad + PAD;
        }
    }

    public void openTag(String name, String attr1Name, String attr1Value, String attr2Name, String attr2Value) {
        name = this.encode(name);
        this.m_openElements.push(name);
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        this.m_xml.append(name);
        this.m_xml.append(" ");
        XmlBuilder.encode(attr1Name, this.m_xml);
        this.m_xml.append("=\"");
        XmlBuilder.encode(attr1Value, this.m_xml);
        this.m_xml.append("\" ");
        XmlBuilder.encode(attr2Name, this.m_xml);
        this.m_xml.append("=\"");
        XmlBuilder.encode(attr2Value, this.m_xml);
        this.m_xml.append("\" ");
        this.m_xml.append(">");
        if (this.m_autoPad) {
            ++this.m_padLevel;
            this.m_pad = this.m_padLevel < 20 ? s_padStrings[this.m_padLevel] : this.m_pad + PAD;
        }
    }

    public void openTag(String name, HashMap<Object, String> attributes) {
        name = this.encode(name);
        this.m_openElements.push(name);
        if (this.m_autoPad) {
            this.m_xml.append(this.m_pad);
        }
        this.m_xml.append("<");
        this.m_xml.append(name);
        this.m_xml.append(" ");
        Object[] elems = attributes.keySet().toArray();
        for (int i = 0; i < elems.length; ++i) {
            String nm = (String)elems[i];
            String val = attributes.get(nm);
            XmlBuilder.encode(nm, this.m_xml);
            this.m_xml.append("=\"");
            XmlBuilder.encode(val, this.m_xml);
            this.m_xml.append("\" ");
        }
        this.m_xml.append(">");
        if (this.m_autoPad) {
            ++this.m_padLevel;
            this.m_pad = this.m_padLevel < 20 ? s_padStrings[this.m_padLevel] : this.m_pad + PAD;
        }
    }

    public void closeTag() {
        if (this.m_autoPad) {
            if (this.m_padLevel > 0) {
                --this.m_padLevel;
            }
            if (this.m_padLevel < 20) {
                this.m_pad = s_padStrings[this.m_padLevel];
            } else {
                int len = this.m_pad.length() - PAD.length();
                if (len > 0) {
                    this.m_pad = this.m_pad.substring(0, len);
                }
            }
            this.m_xml.append(this.m_pad);
        }
        String name = this.m_openElements.pop();
        this.m_xml.append("</");
        this.m_xml.append(name);
        this.m_xml.append(">");
    }

    public String getXML() {
        return this.m_xml.toString();
    }

    private String encode(String src) {
        this.m_encodeBuf.setLength(0);
        XmlBuilder.encode(src, this.m_encodeBuf);
        return this.m_encodeBuf.toString();
    }

    private static final void encode(String src, StringBuffer dst) {
        int n = src.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = src.charAt(i);
            switch (c) {
                case '&': {
                    dst.append("&amp;");
                    continue block8;
                }
                case '<': {
                    dst.append("&lt;");
                    continue block8;
                }
                case '>': {
                    dst.append("&gt;");
                    continue block8;
                }
                case '\'': {
                    dst.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    dst.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    dst.append(s_newlineXmlEnc);
                    continue block8;
                }
                default: {
                    dst.append(c);
                }
            }
        }
    }

    static {
        String pad = "";
        for (int i = 0; i < 20; ++i) {
            XmlBuilder.s_padStrings[i] = "\n" + pad;
            pad = pad + PAD;
        }
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < NEWLINE_BYTES.length; ++i) {
            tmp.append("&#");
            tmp.append(NEWLINE_BYTES[i]);
            tmp.append(";");
        }
        s_newlineXmlEnc = tmp.toString();
    }
}

