/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.Objects;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.spi.LocalTransaction;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCServerExplorerBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.sqlite.dal.SQLiteExplorerParameters;
import org.gvsig.sqlite.dal.SQLiteHelper;
import org.gvsig.sqlite.dal.SQLiteUtils;
import org.gvsig.sqlite.dal.geopackage.GeopackageSpatialRefSys;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.gvsig.sqlite.dal.geopackage.index.GeopackageIndexRTree;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public class SQLiteExplorer
extends JDBCServerExplorerBase {
    public SQLiteExplorer(JDBCServerExplorerParameters parameters, DataServerExplorerProviderServices services, JDBCHelper helper) throws InitializeException {
        super(parameters, services, helper);
    }

    public SQLiteExplorerParameters getParameters() {
        return (SQLiteExplorerParameters)super.getParameters();
    }

    public ResourcesStorage getResourcesStorage(DataStore dataStore) {
        ResourcesStorage ress = super.getResourcesStorage(dataStore);
        return ress;
    }

    public SQLiteHelper getHelper() {
        return (SQLiteHelper)super.getHelper();
    }

    public boolean exists() {
        try {
            SQLiteExplorerParameters serverParameters = this.getParameters();
            return SQLiteUtils.existsdb(serverParameters.getFile());
        }
        catch (Throwable th) {
            return false;
        }
    }

    public boolean add(String providerName, NewDataStoreParameters theParams, boolean overwrite) throws DataException {
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            FeatureAttributeDescriptor geomAttr;
            trans.begin();
            trans.add((DataServerExplorer)this);
            EditableFeatureType feat = ((JDBCNewStoreParameters)theParams).getDefaultFeatureType();
            if (feat != null && (geomAttr = feat.getDefaultGeometryAttribute()) != null) {
                IProjection proj = geomAttr.getSRS();
                if (proj != null) {
                    GeopackageSpatialRefSys refSys = GeopackageUtils.getSpatialRefSys(proj);
                    refSys.save(this.getHelper());
                }
                if (geomAttr.isIndexed()) {
                    GeopackageIndexRTree index = new GeopackageIndexRTree();
                    index.setHasIndex(geomAttr, true);
                }
            }
            boolean x = super.add(providerName, theParams, overwrite);
            trans.commit();
            boolean bl = x;
            return bl;
        }
        catch (Exception ex) {
            trans.abortQuietly();
            throw ex;
        }
        finally {
            trans.closeQuietly();
        }
    }

    public void remove(DataStoreParameters theParams) throws RemoveException {
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((DataServerExplorer)this);
            DataManager dataManager = DALLocator.getDataManager();
            EditableFeatureType type = dataManager.createFeatureType();
            OperationsFactory operations = this.getHelper().getOperations();
            OperationsFactory.TableReference table = this.getHelper().getOperations().createTableReference((JDBCStoreParameters)theParams);
            FetchFeatureTypeOperation operation = operations.createFetchFeatureType(type, table, null, null, null);
            operation.perform();
            ArrayList<String> sqls = new ArrayList<String>();
            for (FeatureAttributeDescriptor attr : type) {
                if (attr.getDataType().getType() != 66) continue;
                GeopackageIndexRTree index = new GeopackageIndexRTree();
                sqls.addAll(index.getRemoveIndexSQL(table.getTable(), attr.getName()));
            }
            JDBCConnection conn = null;
            Statement st = null;
            try {
                conn = this.getHelper().getConnection();
                st = conn.createStatement();
                for (String sql : sqls) {
                    JDBCUtils.execute((Statement)st, (String)sql);
                }
            }
            catch (Exception ex) {
                try {
                    throw new RemoveException(table.getTable(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    JDBCUtils.closeQuietly(st);
                    throw throwable;
                }
            }
            JDBCUtils.closeQuietly((Statement)st);
            super.remove(theParams);
            trans.commit();
        }
        catch (RemoveException ex) {
            trans.abortQuietly();
            throw ex;
        }
        catch (Exception ex) {
            trans.abortQuietly();
            throw new RemoveException("Can't remove " + Objects.toString(theParams), (Throwable)ex);
        }
        finally {
            trans.closeQuietly();
        }
    }

    protected ResourcesStorage getLocalResourcesStorage(DataStoreParameters parameters, String storeName) {
        return null;
    }
}

