/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal;

import java.io.File;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.PersonalDatabaseServerExplorerFactory;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCServerExplorerFactory;
import org.gvsig.sqlite.dal.SQLiteExplorerParameters;
import org.gvsig.sqlite.dal.SQLiteHelper;
import org.gvsig.sqlite.dal.SQLiteUtils;

public class SQLiteExplorerFactory
extends JDBCServerExplorerFactory
implements PersonalDatabaseServerExplorerFactory {
    private static final String NAME = "SQLite";

    public SQLiteExplorerFactory() {
        super(NAME, "GeoPackage/SQLite");
    }

    public JDBCServerExplorer create(DataServerExplorerParameters parameters, DataServerExplorerProviderServices providerServices) throws InitializeException {
        SQLiteHelper helper = new SQLiteHelper((JDBCConnectionParameters)parameters);
        JDBCServerExplorer server = helper.createServerExplorer((JDBCServerExplorerParameters)parameters, providerServices);
        return server;
    }

    public JDBCServerExplorerParameters createParameters() {
        SQLiteExplorerParameters params = new SQLiteExplorerParameters();
        return params;
    }

    public String[] getPossibleExtensions(String extension) {
        return new String[]{"gpkg", "gpkx", "sqlite", "sqlite3", "db", "db3", "s3db", "sl3"};
    }

    public File[] getPossibleFiles(File dbfile) {
        return SQLiteUtils.getFiles(dbfile);
    }

    public boolean existsdb(File dbfile) {
        return SQLiteUtils.existsdb(dbfile);
    }

    public boolean removedb(File dbfile) {
        return SQLiteUtils.removedb(dbfile);
    }

    public File normalizeFile(File dbfile) {
        String s = SQLiteUtils.removeFileNameExtension(dbfile.getPath());
        if (s == null) {
            return null;
        }
        return new File(s + "." + "gpkg");
    }

    public File removeExtension(File dbfile) {
        return new File(SQLiteUtils.removeFileNameExtension(dbfile.getPath()));
    }

    public boolean isServerModeSupported() {
        return false;
    }

    public void serverStop() {
    }

    public void serverStart(Object ... args) {
    }

    public void serverSetEnabled(boolean enabled) {
    }

    public boolean serverIsEnabled() {
        return false;
    }

    public boolean serverIsStarted() {
        return false;
    }
}

