/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal;

import java.io.InputStream;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorerFactory;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.store.db.DBHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCLibrary;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCStoreProviderBase;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.sqlite.dal.SQLiteExplorerFactory;
import org.gvsig.sqlite.dal.SQLiteExplorerParameters;
import org.gvsig.sqlite.dal.SQLiteHelper;
import org.gvsig.sqlite.dal.SQLiteNewStoreParameters;
import org.gvsig.sqlite.dal.SQLiteStoreParameters;
import org.gvsig.sqlite.dal.SQLiteStoreProviderFactory;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class SQLiteLibrary
extends AbstractLibrary {
    public static final String NAME = "SQLite";

    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(JDBCLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        LibraryException ex = null;
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (Throwable th) {
            SQLiteHelper.LOGGER.warn("Can't load SQLite JDBC Driver.", th);
        }
        DBHelper.registerParametersDefinition((String)"SQLiteStoreParameters", SQLiteStoreParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "SQLiteParameters.xml"));
        DBHelper.registerParametersDefinition((String)"SQLiteNewStoreParameters", SQLiteNewStoreParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "SQLiteParameters.xml"));
        DBHelper.registerParametersDefinition((String)"SQLiteServerExplorerParameters", SQLiteExplorerParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "SQLiteParameters.xml"));
        try {
            DBHelper.registerMetadataDefinition((String)NAME, JDBCStoreProviderBase.class, (InputStream)dataman.getResourceAsStream((Object)this, "SQLiteMetadata.xml"));
        }
        catch (MetadataException e) {
            ex = new LibraryException(((Object)((Object)this)).getClass(), (ListBaseException)e);
        }
        if (!dataman.getStoreProviderRegister().exits(NAME)) {
            dataman.registerStoreProviderFactory((DataStoreProviderFactory)new SQLiteStoreProviderFactory());
        }
        if (!dataman.getServerExplorerRegister().exits(NAME)) {
            dataman.registerServerExplorerFactory((DataServerExplorerFactory)new SQLiteExplorerFactory());
        }
        if (ex != null) {
            throw ex;
        }
    }
}

