/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.expressionbuilderformatter;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;

public class Extract
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;

    public Extract(Formatter<ExpressionBuilder.Value> formatter) {
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.Function) {
            return StringUtils.equalsIgnoreCase((CharSequence)"EXTRACT", (CharSequence)((ExpressionBuilder.Function)value).name());
        }
        return false;
    }

    public String format(ExpressionBuilder.Value function0) {
        ExpressionBuilder.Function function = (ExpressionBuilder.Function)function0;
        ExpressionBuilder.Value fieldValue = (ExpressionBuilder.Value)function.parameters().get(0);
        ExpressionBuilder.Value exp = (ExpressionBuilder.Value)function.parameters().get(1);
        String field = fieldValue.toString(this.formatter);
        if (fieldValue instanceof ExpressionBuilder.Constant) {
            field = (String)((ExpressionBuilder.Constant)fieldValue).value();
        }
        switch (StringUtils.lowerCase((String)field)) {
            case "year": {
                return "CAST(strftime('%Y'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "month": {
                return "CAST(strftime('%m'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "day": {
                return "CAST(strftime('%d'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "dow": {
                return "CAST(strftime('%w'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "hour": {
                return "CAST(strftime('%H'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "isodow": {
                return "CAST(strftime('%u'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "minute": {
                return "CAST(strftime('%M'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "second": {
                return "CAST(strftime('%S'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "week": {
                return "CAST(strftime('%W'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
            case "quarter": {
                return "(CAST(strftime('%m'," + exp.toString(this.formatter) + ") AS INTEGER)-1)/3+1";
            }
            case "doy": {
                return "CAST(strftime('%j'," + exp.toString(this.formatter) + ") AS INTEGER)";
            }
        }
        return "EXTRACT(" + field + " FROM " + exp.toString(this.formatter) + ")";
    }
}

