/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_ConvexHull
extends Functions.AbstractFunction {
    public ST_ConvexHull(SQLiteConnection conn) {
        super("ST_ConvexHull", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            byte[] bytes = this.value_blob(0);
            if (bytes == null) {
                this.result();
                return;
            }
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            Geometry geom = parser.parseToGeometry(conn, bytes);
            if (geom == null) {
                this.result();
                return;
            }
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            builder.setGeometry(conn, geom.convexHull());
            bytes = builder.build();
            if (bytes == null) {
                this.result();
            } else {
                this.result(bytes);
            }
        }
        catch (Throwable ex) {
            throw new SQLException("Can't get geometry's convex hull", ex);
        }
    }
}

