/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_Difference
extends Functions.AbstractFunction {
    public ST_Difference(SQLiteConnection conn) {
        super("ST_Difference", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            byte[] bytes1 = this.value_blob(0);
            if (bytes1 == null) {
                this.result();
                return;
            }
            byte[] bytes2 = this.value_blob(1);
            if (bytes2 == null) {
                this.result();
                return;
            }
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            Geometry geom1 = parser.parseToGeometry(conn, bytes1);
            if (geom1 == null) {
                this.result();
                return;
            }
            Geometry geom2 = parser.parseToGeometry(conn, bytes2);
            if (geom2 == null) {
                this.result();
                return;
            }
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            builder.setGeometry(conn, geom1.difference(geom2));
            byte[] bytes = builder.build();
            if (bytes == null) {
                this.result();
            } else {
                this.result(bytes);
            }
        }
        catch (Throwable ex) {
            throw new SQLException("Can't build the difference of the geometries", ex);
        }
    }
}

