/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_Envelope
extends Functions.AbstractFunction {
    public ST_Envelope(SQLiteConnection conn) {
        super("ST_Envelope", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            Geometry geom;
            byte[] bytes = this.value_blob(0);
            if (bytes == null) {
                this.result();
                return;
            }
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            parser.parseEnvelope(bytes);
            Envelope env = parser.getEnvelope(conn);
            if (env == null) {
                geom = parser.parseToGeometry(conn, bytes);
                if (geom == null) {
                    this.result();
                    return;
                }
                geom = geom.getEnvelope().getGeometry();
            } else {
                geom = env.getGeometry();
            }
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            builder.setGeometry(conn, geom);
            bytes = builder.build();
            if (bytes == null) {
                this.result();
            } else {
                this.result(bytes);
            }
        }
        catch (Throwable ex) {
            throw new SQLException("Can't get envelope", ex);
        }
    }
}

