/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_NumPoints
extends Functions.AbstractFunction {
    public ST_NumPoints(SQLiteConnection conn) {
        super("ST_NumPoints", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            byte[] bytes1 = this.value_blob(0);
            if (bytes1 == null) {
                this.result();
                return;
            }
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            Geometry geom1 = parser.parseToGeometry(conn, bytes1);
            if (geom1 == null) {
                this.result();
                return;
            }
            if (geom1 instanceof OrientablePrimitive) {
                this.result(((OrientablePrimitive)geom1).getNumVertices());
            }
            this.result();
        }
        catch (Throwable ex) {
            throw new SQLException("I can't get the number of point of the geometry", ex);
        }
    }
}

