/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_Transform
extends Functions.AbstractFunction {
    public ST_Transform(SQLiteConnection conn) {
        super("ST_Transform", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            byte[] bytes1 = this.value_blob(0);
            if (bytes1 == null) {
                this.result();
                return;
            }
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            Geometry geom = parser.parseToGeometry(conn, bytes1);
            if (geom == null) {
                this.result();
                return;
            }
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            IProjection to_proj = null;
            IProjection from_proj = null;
            Integer to_srid = null;
            Integer from_srid = null;
            switch (this.args()) {
                case 2: {
                    to_srid = this.value_int(1);
                    to_proj = CRSFactory.getCRS((String)("EPSG:" + to_srid));
                    from_proj = geom.getProjection();
                    break;
                }
                case 3: {
                    to_srid = this.value_int(2);
                    from_srid = this.value_int(1);
                    to_proj = CRSFactory.getCRS((String)("EPSG:" + to_srid));
                    from_proj = CRSFactory.getCRS((String)("EPSG:" + from_srid));
                    break;
                }
                default: {
                    throw new ExpressionRuntimeException("Incorrect number of arguments.");
                }
            }
            ICoordTrans ct = from_proj.getCT(to_proj);
            Geometry reprojectedGeom = geom.cloneGeometry();
            reprojectedGeom.reProject(ct);
            builder.setGeometry(conn, reprojectedGeom);
            byte[] bytes = builder.build();
            if (bytes == null) {
                this.result();
            } else {
                this.result(bytes);
            }
        }
        catch (Throwable ex) {
            throw new SQLException("Can't transform the geometry", ex);
        }
    }
}

