/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

class ByteWriter {
    private static final Logger logger = Logger.getLogger(ByteWriter.class.getName());
    public static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private final OutputStream outputStream;
    private ByteOrder byteOrder = DEFAULT_BYTE_ORDER;

    public ByteWriter() {
        this.outputStream = new ByteArrayOutputStream();
    }

    public ByteWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public ByteWriter(ByteOrder byteOrder) {
        this();
        this.byteOrder = byteOrder;
    }

    public ByteWriter(OutputStream outputStream, ByteOrder byteOrder) {
        this(outputStream);
        this.byteOrder = byteOrder;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        if (!(this.outputStream instanceof ByteArrayOutputStream)) {
            throw new RuntimeException("Output Stream is not a ByteArrayOutputStream: " + this.outputStream.getClass().getName());
        }
        return (ByteArrayOutputStream)this.outputStream;
    }

    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close byte writer output stream", e);
        }
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public byte[] getBytes() {
        return this.getByteArrayOutputStream().toByteArray();
    }

    public int size() {
        return this.getByteArrayOutputStream().size();
    }

    public void writeString(String value) throws IOException {
        byte[] valueBytes = value.getBytes();
        this.outputStream.write(valueBytes);
    }

    public void writeByte(byte value) throws IOException {
        this.outputStream.write(value);
    }

    public void writeInt(int value) throws IOException {
        byte[] valueBytes = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(this.byteOrder).putInt(value);
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.outputStream.write(valueBytes);
    }

    public void writeDouble(double value) throws IOException {
        byte[] valueBytes = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(this.byteOrder).putDouble(value);
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.outputStream.write(valueBytes);
    }

    public void writeBytes(byte[] value) throws IOException {
        this.outputStream.write(value, 0, value.length);
    }
}

