/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage;

import java.io.IOException;
import java.nio.ByteOrder;
import java.sql.Connection;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.sqlite.dal.geopackage.ByteReader;
import org.gvsig.sqlite.dal.geopackage.GeopackageException;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class GeopackageGeometryParser {
    private boolean extended = false;
    private boolean empty = true;
    private ByteOrder byteOrder = GeopackageUtils.DEFAULT_BYTE_ORDER;
    private int srsId;
    private int wkbGeometryIndex;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private boolean hasZ;
    private Double minZ;
    private Double maxZ;
    private Double maxM;
    private Double minM;
    private boolean hasM;
    private int envelopeIndicator;
    private GeometryManager geometryManager;
    private IProjection lastProjection;
    private int lastSrsId;

    GeopackageGeometryParser() {
    }

    public Geometry parseToGeometry(SQLiteConnection conn, byte[] bytes) {
        Geometry geom = null;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            byte[] wkb = this.parseToWKB(bytes);
            if (wkb != null) {
                IProjection proj = GeopackageUtils.getProjection("EPSG:" + this.srsId);
                geom = this.getGeometryManager().createFrom(wkb, proj);
            }
        }
        catch (Exception e) {
            throw new GeopackageException("Failed to read the WKB geometry", e);
        }
        return geom;
    }

    private GeometryManager getGeometryManager() {
        if (this.geometryManager == null) {
            this.geometryManager = GeometryLocator.getGeometryManager();
        }
        return this.geometryManager;
    }

    private IProjection getProjection(SQLiteConnection conn, int srsid) {
        if (srsid <= 0) {
            return null;
        }
        if (srsid != this.lastSrsId) {
            this.lastProjection = GeopackageUtils.getProjection((Connection)conn, this.srsId);
            this.lastSrsId = srsid;
        }
        return this.lastProjection;
    }

    public byte[] parseToWKB(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        byte[] wkb = null;
        ByteReader reader = new ByteReader(bytes);
        try {
            this.parseMagicAndVersion(reader);
            this.parseFlags(reader);
            this.parseSrsId(reader);
            this.parseEnvelope(reader);
        }
        catch (Throwable e) {
            throw new GeopackageException("Failed to read the GeoPackage geometry header", e);
        }
        this.wkbGeometryIndex = reader.getNextByte();
        if (!this.empty) {
            try {
                wkb = reader.readBytes(bytes.length - this.wkbGeometryIndex);
            }
            catch (Throwable e) {
                throw new GeopackageException("Failed to read the WKB geometry", e);
            }
        }
        reader.close();
        return wkb;
    }

    public void parseEnvelope(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        ByteReader reader = new ByteReader(bytes);
        try {
            this.parseMagicAndVersion(reader);
            this.parseFlags(reader);
            this.parseSrsId(reader);
            this.parseEnvelope(reader);
        }
        catch (Throwable e) {
            throw new GeopackageException("Failed to read the GeoPackage geometry header", e);
        }
        reader.close();
    }

    public boolean isEmpty(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return true;
        }
        ByteReader reader = new ByteReader(bytes);
        try {
            this.parseMagicAndVersion(reader);
            this.parseFlags(reader);
            this.parseSrsId(reader);
            this.parseEnvelope(reader);
        }
        catch (Throwable e) {
            throw new GeopackageException("Failed to read the GeoPackage geometry header", e);
        }
        reader.close();
        return this.empty;
    }

    private void processFlags(byte flags) {
        int reserved7 = flags >> 7 & 1;
        int reserved6 = flags >> 6 & 1;
        if (reserved7 != 0 || reserved6 != 0) {
            throw new GeopackageException("Unexpected GeoPackage Geometry flags. Flag bit 7 and 6 should both be 0, 7=" + reserved7 + ", 6=" + reserved6);
        }
        int binaryType = flags >> 5 & 1;
        this.extended = binaryType == 1;
        int emptyValue = flags >> 4 & 1;
        this.empty = emptyValue == 1;
        this.envelopeIndicator = flags >> 1 & 7;
        if (this.envelopeIndicator > 4) {
            throw new GeopackageException("Unexpected GeoPackage Geometry flags. Envelope contents indicator must be between 0 and 4. Actual: " + this.envelopeIndicator);
        }
        int byteOrderValue = flags & 1;
        this.byteOrder = byteOrderValue == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    private void parseMagicAndVersion(ByteReader reader) throws IOException {
        String magic = null;
        try {
            magic = reader.readString(2);
        }
        catch (Throwable e) {
            throw new GeopackageException("Unexpected GeoPackage Geometry magic number character encoding: Expected: GP", e);
        }
        if (!magic.equals("GP")) {
            throw new GeopackageException("Unexpected GeoPackage Geometry magic number: " + magic + ", Expected: " + "GP");
        }
        byte version = reader.readByte();
        if (version != 0) {
            throw new GeopackageException("Unexpected GeoPackage Geometry version: " + version + ", Expected: " + 0);
        }
    }

    private void parseFlags(ByteReader reader) throws IOException {
        byte flags = reader.readByte();
        this.processFlags(flags);
        reader.setByteOrder(this.byteOrder);
    }

    private void parseSrsId(ByteReader reader) throws IOException {
        this.srsId = reader.readInt();
    }

    private void parseEnvelope(ByteReader reader) throws IOException {
        if (this.envelopeIndicator > 0) {
            this.minX = reader.readDouble();
            this.maxX = reader.readDouble();
            this.minY = reader.readDouble();
            this.maxY = reader.readDouble();
            this.hasZ = false;
            this.minZ = null;
            this.maxZ = null;
            this.hasM = false;
            this.minM = null;
            this.maxM = null;
            if (this.envelopeIndicator == 2 || this.envelopeIndicator == 4) {
                this.hasZ = true;
                this.minZ = reader.readDouble();
                this.maxZ = reader.readDouble();
            }
            if (this.envelopeIndicator == 3 || this.envelopeIndicator == 4) {
                this.hasM = true;
                this.minM = reader.readDouble();
                this.maxM = reader.readDouble();
            }
        }
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public int getSrsId() {
        return this.srsId;
    }

    public Envelope getEnvelope(SQLiteConnection conn) {
        if (this.envelopeIndicator == 0) {
            return null;
        }
        try {
            IProjection proj = GeopackageUtils.getProjection((Connection)conn, this.srsId);
            Envelope env = GeometryLocator.getGeometryManager().createEnvelope(this.minX, this.minY, this.maxX, this.maxY, 0);
            env.setProjection(proj);
            return env;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Can't get envelope", ex);
        }
    }

    public void clean() {
        this.extended = false;
        this.empty = true;
        this.byteOrder = GeopackageUtils.DEFAULT_BYTE_ORDER;
        this.srsId = 0;
        this.wkbGeometryIndex = 0;
        this.minX = 0.0;
        this.maxX = 0.0;
        this.minY = 0.0;
        this.maxY = 0.0;
        this.hasZ = false;
        this.minZ = null;
        this.maxZ = null;
        this.maxM = null;
        this.minM = null;
        this.hasM = false;
        this.envelopeIndicator = 0;
    }
}

