/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage;

import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolverBase;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class GeopackageSRSSolver
extends SRSSolverBase {
    GeopackageSRSSolver() {
        super(null);
    }

    protected Object searchDatabaseCode(JDBCConnection connection, String applicationAbbrev) {
        return this.searchDatabaseCode((SQLiteConnection)connection.get(), applicationAbbrev);
    }

    protected String searchApplicationAbbrev(JDBCConnection connection, Integer databaseCode) {
        return this.searchApplicationAbbrev((SQLiteConnection)connection.get(), databaseCode);
    }

    protected Object searchDatabaseCode(SQLiteConnection connection, String applicationAbbrev) {
        String sql = "select srs_id, organization, organization_coordsys_id from gpkg_spatial_ref_sys where organization/organization_coordsys_id is '" + applicationAbbrev + "'.";
        try {
            String[] s = applicationAbbrev.split(":");
            sql = "select srs_id, organization, organization_coordsys_id from gpkg_spatial_ref_sys where upper(organization) = upper('" + s[0] + "') and organization_coordsys_id = " + s[1] + " ";
            Statement st = connection.createStatement();
            ResultSet rs = JDBCUtils.executeQuery((Statement)st, (String)sql);
            if (rs.next()) {
                Integer srid = rs.getInt("srs_id");
                return srid;
            }
            return null;
        }
        catch (Throwable ex) {
            logger.warn("Can't retrieve SRS code from gpkg_spatial_ref_sys (" + sql + ").", ex);
            throw new RuntimeException("Can't retrieve SRS code from gpkg_spatial_ref_sys (" + sql + ").", ex);
        }
    }

    protected String searchApplicationAbbrev(SQLiteConnection connection, Integer databaseCode) {
        String sql = "select srs_id, organization, organization_coordsys_id from gpkg_spatial_ref_sys where srs_id = " + databaseCode;
        try {
            Statement st = connection.createStatement();
            ResultSet rs = JDBCUtils.executeQuery((Statement)st, (String)sql);
            if (rs.next()) {
                int auth_code = rs.getInt("organization_coordsys_id");
                String auth_name = rs.getString("organization");
                return auth_name + ":" + auth_code;
            }
            return null;
        }
        catch (Throwable ex) {
            logger.warn("Can't retrieve SRS from gpkg_spatial_ref_sys (" + sql + ").", ex);
            throw new RuntimeException("Can't retrieve SRS from gpkg_spatial_ref_sys (" + sql + ").", ex);
        }
    }

    public Integer getDatabaseCode(SQLiteConnection connection, String applicationAbbrev) {
        if (this.hasApplicationAbbrev(null, applicationAbbrev)) {
            return (Integer)this.applicationAbbrev2database.get(applicationAbbrev);
        }
        Integer databaseCode = (Integer)this.searchDatabaseCode(connection, applicationAbbrev);
        this.add(databaseCode, applicationAbbrev);
        return databaseCode;
    }

    public IProjection getProjection(SQLiteConnection connection, Object databaseCode) {
        if (databaseCode == null) {
            return null;
        }
        String s = databaseCode.toString().trim();
        if (s.equals("0")) {
            return null;
        }
        String abbrev = this.getApplicationAbbrev(connection, databaseCode);
        if (StringUtils.isEmpty((CharSequence)abbrev)) {
            return null;
        }
        IProjection proj = GeopackageUtils.getProjection(abbrev);
        return proj;
    }

    public String getApplicationAbbrev(SQLiteConnection connection, Object databaseCode) {
        if (this.hasDatabaseCode(null, databaseCode)) {
            return (String)this.database2applicationAbbrev.get((Integer)databaseCode);
        }
        String applicationAbbrev = this.searchApplicationAbbrev(connection, (Integer)databaseCode);
        if (StringUtils.isEmpty((CharSequence)applicationAbbrev)) {
            return null;
        }
        this.add(databaseCode, applicationAbbrev);
        return applicationAbbrev;
    }
}

