/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage;

import java.nio.ByteOrder;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryColumns;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageSRSSolver;
import org.gvsig.sqlite.dal.geopackage.GeopackageSpatialRefSys;
import org.gvsig.sqlite.dal.geopackage.index.GeopackageIndexManager;
import org.gvsig.sqlite.dal.geopackage.index.GeopackageIndexManagerImpl;
import org.gvsig.sqlite.dal.operations.SQLiteFetchFeatureTypeOperation;
import org.sqlite.SQLiteConnection;

public class GeopackageUtils {
    public static final String GEOMETRY_MAGIC_NUMBER = "GP";
    public static final byte GEOMETRY_VERSION_1 = 0;
    public static final String EXTENSION = "gpkg";
    public static final String EXTENDED_EXTENSION = "gpkx";
    public static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static final Map<String, IProjection> projCache = new LRUMap(10);
    private static GeopackageIndexManager INSTANCE_INDEX_MANAGER = null;

    public static boolean isGeopackageGeometry(byte[] bytes) {
        return bytes[0] == 71 && bytes[1] == 80;
    }

    public static int getSrsId(Connection conn, Geometry geom) {
        if (geom == null) {
            return 0;
        }
        return GeopackageUtils.getSrsId(conn, geom.getProjection());
    }

    public static int getSrsId(Connection conn, IProjection proj) {
        if (proj == null) {
            return 0;
        }
        try {
            if (conn == null || !(conn instanceof SQLiteConnection)) {
                String[] s = proj.getAbrev().split(":");
                return Integer.valueOf(s[1]);
            }
            return GeopackageUtils.createSRSSolver((SQLiteConnection)conn).getDatabaseCode((SQLiteConnection)conn, proj.getAbrev());
        }
        catch (Throwable ex) {
            return 0;
        }
    }

    public static IProjection getProjection(Connection conn, int srs_id) {
        if (srs_id < 1) {
            return null;
        }
        if (conn == null || !(conn instanceof SQLiteConnection)) {
            String abrev = "EPSG:" + srs_id;
            return GeopackageUtils.getProjection(abrev);
        }
        return GeopackageUtils.createSRSSolver((SQLiteConnection)conn).getProjection((SQLiteConnection)conn, srs_id);
    }

    public static IProjection getProjection(String abbrev) {
        try {
            if (StringUtils.isBlank((CharSequence)abbrev)) {
                return null;
            }
            IProjection proj = projCache.get(abbrev);
            if (proj == null) {
                if (projCache.containsKey(abbrev)) {
                    return null;
                }
                proj = CRSFactory.getCRS((String)abbrev);
                projCache.put(abbrev, proj);
            }
            return proj;
        }
        catch (Exception ex) {
            projCache.put(abbrev, null);
            return null;
        }
    }

    public static GeopackageSRSSolver createSRSSolver(SQLiteConnection conn) {
        Properties props = conn.getDatabase().getConfig().toProperties();
        GeopackageSRSSolver solver = (GeopackageSRSSolver)((Object)props.get("SRSSolver"));
        if (solver != null) {
            return solver;
        }
        solver = new GeopackageSRSSolver();
        props.put("SRSSolver", (Object)solver);
        return solver;
    }

    public static GeopackageGeometryParser createGeometryParser() {
        return new GeopackageGeometryParser();
    }

    public static GeopackageGeometryBuilder createGeometryBuilder() {
        return new GeopackageGeometryBuilder();
    }

    public static void load_gpkg_geometry_columns(Map<String, SQLiteFetchFeatureTypeOperation.SQLiteColumnInfo> columns_info, JDBCConnection conn, String tableName, JDBCSQLBuilderBase sqlbuilder) {
        GeopackageGeometryColumns.load_gpkg_geometry_columns(columns_info, conn, tableName, sqlbuilder);
    }

    public static GeopackageIndexManager getIndexManager() {
        if (INSTANCE_INDEX_MANAGER == null) {
            INSTANCE_INDEX_MANAGER = new GeopackageIndexManagerImpl();
        }
        return INSTANCE_INDEX_MANAGER;
    }

    public static GeopackageSpatialRefSys getSpatialRefSys(IProjection proj) {
        return new GeopackageSpatialRefSys(proj);
    }
}

