/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage.index;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.sqlite.dal.geopackage.index.AbstractGeopackageIndex;
import org.gvsig.sqlite.dal.utils.TemplateUtils;

public class GeopackageIndexRTree
extends AbstractGeopackageIndex {
    private static final String ATTRIBUTE_INDEX_FLAG_NAME = "gpkg_rtree_index";
    public static final String GROUP_NAME = "rtree";

    @Override
    protected String getGroup() {
        return GROUP_NAME;
    }

    @Override
    protected String getAttributeIndexFlagName() {
        return ATTRIBUTE_INDEX_FLAG_NAME;
    }

    @Override
    public List<String> getCreateIndexSQL(String tablename, String fieldnamegeom, String fieldnameid) {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "create_table_gpkg_extensions", new Object[0]));
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "create_rtree_table", tablename, fieldnamegeom));
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "create_trigger_rtree_delete", tablename, fieldnamegeom, fieldnameid));
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "create_trigger_rtree_insert", tablename, fieldnamegeom, fieldnameid));
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "create_trigger_rtree_update1", tablename, fieldnamegeom, fieldnameid));
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "create_trigger_rtree_update2", tablename, fieldnamegeom, fieldnameid));
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "create_trigger_rtree_update3", tablename, fieldnamegeom, fieldnameid));
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "create_trigger_rtree_update4", tablename, fieldnamegeom, fieldnameid));
        sqls.add(TemplateUtils.getSqlTemplate(this.getGroup(), "insert_into_table_gpkg_extensions", tablename, fieldnamegeom));
        return sqls;
    }

    @Override
    public String getEnvelopeSQL(String tablename, String fieldnamegeom) {
        String sql = TemplateUtils.getSqlTemplate(this.getGroup(), "bbox_of_index", tablename, fieldnamegeom);
        return sql;
    }

    @Override
    public List<String> getRemoveIndexSQL(String tablename, String fieldnamegeom) {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(String.format("DROP TRIGGER IF EXISTS \"rtree_%s_%s_delete\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TRIGGER IF EXISTS \"rtree_%s_%s_insert\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TRIGGER IF EXISTS \"rtree_%s_%s_update1\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TRIGGER IF EXISTS \"rtree_%s_%s_update2\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TRIGGER IF EXISTS \"rtree_%s_%s_update3\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TRIGGER IF EXISTS \"rtree_%s_%s_update4\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TABLE IF EXISTS \"rtree_%s_%s\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TABLE IF EXISTS \"rtree_%s_%s_node\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TABLE IF EXISTS \"rtree_%s_%s_parent\"", tablename, fieldnamegeom));
        sqls.add(String.format("DROP TABLE IF EXISTS \"rtree_%s_%s_rowid\"", tablename, fieldnamegeom));
        return sqls;
    }
}

