/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.difference;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import es.unex.sextante.core.Sextante;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifferenceOperation
extends GeometryOperation {
    private Logger log = LoggerFactory.getLogger(DifferenceOperation.class);
    private boolean errorInfo = false;
    private Geometry overlaysGeom = null;

    public DifferenceOperation(org.gvsig.fmap.geom.Geometry overlays, AbstractSextanteGeoProcess p) {
        super(p);
        if (overlays != null) {
            this.overlaysGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)overlays);
        }
    }

    public boolean getErrorInfo() {
        return this.errorInfo;
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        block10: {
            if (g == null) {
                return this.lastEditFeature;
            }
            Geometry jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
            try {
                if (this.overlaysGeom == null) {
                    return this.persister.addFeature(feature, jtsGeom);
                }
                if (!jtsGeom.getEnvelope().intersects(this.overlaysGeom.getEnvelope())) {
                    this.lastEditFeature = this.persister.addFeature(feature, jtsGeom);
                    return this.lastEditFeature;
                }
                if (jtsGeom.intersects(this.overlaysGeom)) {
                    try {
                        Geometry newGeom = EnhancedPrecisionOp.difference((Geometry)jtsGeom, (Geometry)this.overlaysGeom);
                        if (!newGeom.isEmpty()) {
                            this.lastEditFeature = this.persister.addFeature(feature, newGeom);
                        }
                        break block10;
                    }
                    catch (TopologyException e) {
                        this.errorInfo = true;
                        this.log.info("Problems operating difference: ", (Throwable)e);
                    }
                    break block10;
                }
                this.lastEditFeature = this.persister.addFeature(feature, jtsGeom);
            }
            catch (CreateGeometryException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.lastEditFeature;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        if (g == null) {
            return;
        }
        Geometry jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        try {
            if (this.overlaysGeom == null) {
                this.persister.addFeature((Feature)feature, jtsGeom);
            }
            if (!jtsGeom.getEnvelope().intersects(this.overlaysGeom.getEnvelope())) {
                this.persister.addFeature((Feature)feature, jtsGeom);
            }
            if (jtsGeom.intersects(this.overlaysGeom)) {
                try {
                    Geometry newGeom = EnhancedPrecisionOp.difference((Geometry)jtsGeom, (Geometry)this.overlaysGeom);
                    this.persister.addFeature((Feature)feature, newGeom);
                }
                catch (CreateGeometryException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                catch (DataException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
            } else {
                this.persister.addFeature((Feature)feature, jtsGeom);
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (CreateGeometryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

