/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.ListItem;
import gishur.core.Queue;
import gishur.core.SimpleList;
import gishur.gui.ScreenTransformException;
import gishur.gui.ScreenTransformation;
import gishur.gui.VirtualScreen;
import gishur.x.AffineXTransformable;
import gishur.x.Intersection;
import gishur.x.PointComparitor;
import gishur.x.XHalfplane;
import gishur.x.XLine;
import gishur.x.XParabola;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XPolyline;
import gishur.x.XRay;
import gishur.x.XRectangle;
import gishur.x.XSegment;
import gishur.x.XUPolygon;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class ScreenXTransformation
implements ScreenTransformation {
    double _m00;
    double _m01;
    double _m02;
    double _m10;
    double _m11;
    double _m12;
    double _a00;
    double _a01;
    double _a02;
    double _a10;
    double _a11;
    double _a12;
    private VirtualScreen _vscreen;
    private XSegment[] _border = null;
    private int CLIP_INT = 10000;

    public void resetTransform() {
        this._m00 = 1.0;
        this._m01 = 0.0;
        this._m02 = 0.0;
        this._m10 = 0.0;
        this._m11 = 1.0;
        this._m12 = 0.0;
        this.createInverse();
    }

    public XSegment transformXSegment(Point point, Point point2) {
        return new XSegment(this.transformXPoint(point), this.transformXPoint(point2));
    }

    public XSegment transformXSegment(int n, int n2, int n3, int n4) {
        return new XSegment(this.transformXPoint(n, n2), this.transformXPoint(n3, n4));
    }

    public Point[] transformXSegment(XSegment xSegment) {
        if ((xSegment = this.clipSegment(xSegment)) == null) {
            return new Point[0];
        }
        Point[] pointArray = new Point[]{this.transformXPoint(xSegment.source()), this.transformXPoint(xSegment.target())};
        return pointArray;
    }

    public Point[] transformXSegment(XSegment[] xSegmentArray) {
        Point[] pointArray = new Point[2 * xSegmentArray.length];
        int n = 0;
        while (n < xSegmentArray.length) {
            XSegment xSegment = this.clipSegment(xSegmentArray[n]);
            if (xSegment != null) {
                pointArray[2 * n] = this.transformPoint(xSegment.source());
                pointArray[2 * n + 1] = this.transformPoint(xSegment.target());
            }
            ++n;
        }
        return pointArray;
    }

    public double getXResolution() {
        Rectangle rectangle = this._vscreen.getBounds();
        double d = rectangle.width;
        double d2 = rectangle.height;
        XPoint xPoint = this.transformXPoint(0, 0);
        XPoint xPoint2 = this.transformXPoint(rectangle.width, 0);
        d = xPoint.distance(xPoint2) / d;
        xPoint2 = this.transformXPoint(0, rectangle.height);
        d2 = xPoint.distance(xPoint2) / d2;
        return Math.min(d, d2);
    }

    private void createInverse() {
        double d = this._m00 * this._m11 - this._m01 * this._m10;
        if (d == 0.0) {
            throw new ScreenTransformException("Non-Invertable Transformation", (ScreenTransformation)this, null);
        }
        this._a00 = this._m11 / d;
        this._a10 = -this._m10 / d;
        this._a01 = -this._m01 / d;
        this._a11 = this._m00 / d;
        this._a02 = (this._m01 * this._m12 - this._m02 * this._m11) / d;
        this._a12 = (this._m02 * this._m10 - this._m00 * this._m12) / d;
        this.calculateClipBorder();
    }

    public boolean transformObjectFromPseudoScreen(Object object) {
        if (object instanceof AffineXTransformable) {
            ((AffineXTransformable)object).transform(this._a00, this._a01, this._a02, this._a10, this._a11, this._a12);
            return true;
        }
        return false;
    }

    public Point[] transformXPolyline(XPolyline xPolyline) {
        Point[] pointArray = new Point[xPolyline.length()];
        int n = 0;
        while (n < pointArray.length) {
            pointArray[n] = this.transformXPoint(xPolyline.point(n));
            ++n;
        }
        return pointArray;
    }

    public Point[] transformXHalfplane(XHalfplane xHalfplane) {
        boolean bl;
        XPolygon xPolygon = this.getXBounds();
        Intersection intersection = xPolygon.intersection(xHalfplane);
        if (intersection.empty()) {
            if (xHalfplane.in(xPolygon.point(0))) {
                return this.getBoundPoints();
            }
            return null;
        }
        XPoint xPoint = intersection.xpoint(0);
        XPoint xPoint2 = intersection.xpoint(1);
        boolean bl2 = bl = xHalfplane.orientation() == 1;
        if (PointComparitor.compareY(xHalfplane.source(), xHalfplane.target()) == -1) {
            bl = !bl;
        }
        XPolyline xPolyline = bl ? xPolygon.copy(xPoint, xPoint2) : xPolygon.copy(xPoint2, xPoint);
        Point[] pointArray = new Point[xPolyline.length()];
        int n = 0;
        while (n < pointArray.length) {
            pointArray[n] = this.transformXPoint(xPolyline.point(n));
            ++n;
        }
        return pointArray;
    }

    /*
     * Unable to fully structure code
     */
    public XSegment clipSegment(XSegment var1_1) {
        if (this._border == null) {
            this.calculateClipBorder();
        }
        var2_2 = null;
        var3_3 = null;
        var4_4 = 0;
        while (var4_4 < 4 && var2_2 == null) {
            var2_2 = this._border[var4_4].intersection(var1_1).xpoint();
            ++var4_4;
        }
        if (var2_2 != null) ** GOTO lbl18
        if (this.drawable(var1_1.source())) {
            return var1_1;
        }
        return null;
lbl-1000:
        // 1 sources

        {
            var3_3 = this._border[var4_4].intersection(var1_1).xpoint();
            if (var3_3 != null && var3_3.equals(var2_2)) {
                var3_3 = null;
            }
            ++var4_4;
lbl18:
            // 2 sources

            ** while (var4_4 < 4 && var3_3 == null)
        }
lbl19:
        // 1 sources

        if (var3_3 == null) {
            if (this.drawable(var1_1.source())) {
                var3_3 = var2_2;
                var2_2 = var1_1.source();
            } else {
                var3_3 = var1_1.target();
            }
        }
        if (var1_1.source().squareDistance(var2_2) < var1_1.source().squareDistance(var3_3)) {
            return new XSegment(var2_2, var3_3);
        }
        return new XSegment(var3_3, var2_2);
    }

    public Point[] transform(Object object) {
        if (object == null) {
            return null;
        }
        Point[] pointArray = null;
        if (object instanceof XPoint) {
            pointArray = new Point[]{this.transformXPoint((XPoint)object)};
            return pointArray;
        }
        if (object instanceof XPoint[]) {
            return this.transformXPoint((XPoint[])object);
        }
        if (object instanceof XSegment) {
            return this.transformXSegment((XSegment)object);
        }
        if (object instanceof XSegment[]) {
            return this.transformXSegment((XSegment[])object);
        }
        if (object instanceof XRay) {
            return this.transformXRay((XRay)object);
        }
        if (object instanceof XLine) {
            return this.transformXLine((XLine)object);
        }
        if (object instanceof XPolygon) {
            return this.transformXPolygon((XPolygon)object);
        }
        if (object instanceof XUPolygon) {
            return this.transformXUPolygon((XUPolygon)object);
        }
        if (object instanceof XPolyline) {
            return this.transformXPolyline((XPolyline)object);
        }
        if (object instanceof XHalfplane) {
            return this.transformXHalfplane((XHalfplane)object);
        }
        if (object instanceof XParabola) {
            return this.transformXParabola((XParabola)object);
        }
        throw new ScreenTransformException((ScreenTransformation)this, object);
    }

    public Object transform(Point[] pointArray) {
        return this.transformXPoint(pointArray);
    }

    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this._m00 * d + this._m01 * d4;
        double d8 = this._m00 * d2 + this._m01 * d5;
        double d9 = this._m00 * d3 + this._m01 * d6 + this._m02;
        double d10 = this._m10 * d + this._m11 * d4;
        double d11 = this._m10 * d2 + this._m11 * d5;
        double d12 = this._m10 * d3 + this._m11 * d6 + this._m12;
        this._m00 = d7;
        this._m01 = d8;
        this._m02 = d9;
        this._m10 = d10;
        this._m11 = d11;
        this._m12 = d12;
    }

    public Object getStatus() {
        return new ScreenXTransformationStatus();
    }

    public void setStatus(Object object) {
        if (!(object instanceof ScreenXTransformationStatus)) {
            return;
        }
        ((ScreenXTransformationStatus)object).restore();
        this.createInverse();
    }

    public SimpleList clipSegmentList(SimpleList simpleList) {
        SimpleList simpleList2 = new SimpleList();
        ListItem listItem = simpleList.first();
        while (listItem != null) {
            XSegment xSegment;
            if (listItem.value() instanceof XSegment && (xSegment = this.clipSegment((XSegment)listItem.value())) != null) {
                simpleList2.push((Object)xSegment);
            }
            listItem = listItem.next();
        }
        return simpleList2;
    }

    public SimpleList convertPolygonSegmentList2PointList(SimpleList simpleList) {
        XPoint xPoint = null;
        XPoint xPoint2 = null;
        SimpleList simpleList2 = new SimpleList();
        ListItem listItem = simpleList.first();
        while (listItem != null) {
            if (listItem.value() instanceof XSegment) {
                XSegment xSegment = (XSegment)listItem.value();
                XPoint xPoint3 = xPoint;
                xPoint = xSegment.source();
                if (xPoint2 == null) {
                    xPoint2 = xPoint;
                }
                if (xPoint3 == null || !xPoint3.equals(xPoint)) {
                    if (xPoint3 != null) {
                        this.pushChain(simpleList2, xPoint3, xPoint);
                    }
                    simpleList2.push((Object)xPoint);
                }
                if (!(xPoint3 = xPoint).equals(xPoint = xSegment.target())) {
                    simpleList2.push((Object)xPoint);
                }
            }
            listItem = listItem.next();
        }
        if (xPoint2 != null && simpleList2.length() > 1) {
            if (xPoint2.equals(xPoint)) {
                simpleList2.pop();
            } else {
                this.pushChain(simpleList2, xPoint, xPoint2);
            }
        }
        return simpleList2;
    }

    public XPolygon getXBounds() {
        Rectangle rectangle = this._vscreen.getBounds();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray2[3] = 0;
        nArray2[2] = 0;
        nArray[3] = 0;
        nArray[0] = 0;
        nArray2[0] = nArray2[1] = rectangle.height;
        nArray[1] = nArray[2] = rectangle.width;
        return this.transformXPolygon(nArray, nArray2, nArray.length);
    }

    public void scale(Point point, double d, double d2) {
        XPoint xPoint = this.transformXPoint(point);
        this.transform(d, 0.0, xPoint.x - d * xPoint.x, 0.0, d2, xPoint.y - d2 * xPoint.y);
        this.createInverse();
    }

    public void scale(double d, double d2) {
        this.scale(this._vscreen.getScreenCenterPoint(), d, d2);
    }

    public Point[] transformXUPolygon(XUPolygon xUPolygon) {
        XPolygon xPolygon = this.getXBounds();
        Intersection intersection = xUPolygon.intersection(xPolygon);
        if (intersection.empty()) {
            return null;
        }
        SimpleList simpleList = intersection.list();
        XPoint xPoint = (XPoint)simpleList.lastValue();
        XPoint xPoint2 = (XPoint)simpleList.firstValue();
        XPolyline xPolyline = xUPolygon.orientation() == 1 ? xPolygon.copy(xPoint, xPoint2) : xPolygon.copy(xPoint2, xPoint);
        if (xPolyline == null) {
            return null;
        }
        Point[] pointArray = new Point[xUPolygon.length() + xPolyline.length()];
        int n = 0;
        while (n < xUPolygon.length()) {
            pointArray[n] = this.transformXPoint(xUPolygon.point(n));
            ++n;
        }
        n = 0;
        while (n < xPolyline.length()) {
            pointArray[xUPolygon.length() + n] = this.transformXPoint(xPolyline.point(n));
            ++n;
        }
        return pointArray;
    }

    public void zoomTo(Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        double d = (double)rectangle.width / (double)rectangle2.width;
        double d2 = (double)rectangle.height / (double)rectangle2.height;
        if (bl) {
            d = d2 = Math.min(d, d2);
        }
        XPoint xPoint = (XPoint)this.transformVector(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        this.transformXPoint(rectangle.x, rectangle.y + rectangle.height);
        this.transform(1.0, 0.0, xPoint.x, 0.0, 1.0, xPoint.y);
        this.scale(new Point(rectangle2.x, rectangle2.y), d, d2);
    }

    public String toString() {
        return "ScreenXTransform[matrix:" + this._m00 + "," + this._m10 + "," + this._m01 + "," + this._m11 + "," + this._m02 + "," + this._m12 + ";inverse:" + this._a00 + "," + this._a10 + "," + this._a01 + "," + this._a11 + "," + this._a02 + "," + this._a12 + "]";
    }

    public Object transformPoint(int n, int n2) {
        double d = this._vscreen.getX(n);
        double d2 = this._vscreen.getY(n2);
        return new XPoint(this._a00 * d + this._a01 * d2 + this._a02, this._a10 * d + this._a11 * d2 + this._a12);
    }

    public Point transformPoint(Object object) {
        if (object instanceof XPoint) {
            return this.transformXPoint((XPoint)object);
        }
        throw new ScreenTransformException((ScreenTransformation)this, object);
    }

    public void rotate(Point point, double d) {
        XPoint xPoint = this.transformXPoint(point);
        this.transform(Math.cos(d), -Math.sin(d), xPoint.x, Math.sin(d), Math.cos(d), xPoint.y);
        this.transform(1.0, 0.0, -xPoint.x, 0.0, 1.0, -xPoint.y);
        this.createInverse();
    }

    public void rotate(Point point, Point point2, Point point3) {
        this.rotate(point, this.transformXPoint(point).angle(this.transformXPoint(point2), this.transformXPoint(point3)));
    }

    public void rotate(double d) {
        this.transform(Math.cos(d), -Math.sin(d), 0.0, Math.sin(d), Math.cos(d), 0.0);
        this.createInverse();
    }

    public void translate(int n, int n2) {
        XPoint xPoint = (XPoint)this.transformVector(n, n2);
        this.transform(1.0, 0.0, xPoint.x, 0.0, 1.0, xPoint.y);
        this.createInverse();
    }

    public boolean drawable(Object object) {
        if (object instanceof XPoint) {
            return this.drawable((XPoint)object);
        }
        return true;
    }

    public ScreenXTransformation() {
        this(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public ScreenXTransformation(double d, double d2, double d3, double d4, double d5, double d6) {
        this._m00 = d;
        this._m10 = d2;
        this._m01 = d3;
        this._m11 = d4;
        this._m02 = d5;
        this._m12 = d6;
        this.createInverse();
    }

    public XPoint transformXPoint(Point point) {
        this._vscreen.transform(point);
        double d = point.x;
        double d2 = point.y;
        return new XPoint(this._a00 * d + this._a01 * d2 + this._a02, this._a10 * d + this._a11 * d2 + this._a12);
    }

    public XPoint transformXPoint(int n, int n2) {
        double d = this._vscreen.getX(n);
        double d2 = this._vscreen.getY(n2);
        return new XPoint(this._a00 * d + this._a01 * d2 + this._a02, this._a10 * d + this._a11 * d2 + this._a12);
    }

    public XPoint[] transformXPoint(int[] nArray, int[] nArray2, int n) {
        XPoint[] xPointArray = new XPoint[n];
        int n2 = 0;
        while (n2 < n) {
            xPointArray[n2] = this.transformXPoint(nArray[n2], nArray2[n2]);
            ++n2;
        }
        return xPointArray;
    }

    public XPoint[] transformXPoint(Point[] pointArray) {
        if (pointArray == null) {
            return null;
        }
        XPoint[] xPointArray = new XPoint[pointArray.length];
        int n = 0;
        while (n < xPointArray.length) {
            xPointArray[n] = this.transformXPoint(pointArray[n]);
            ++n;
        }
        return xPointArray;
    }

    public Point transformXPoint(double d, double d2) {
        Point point = new Point((int)Math.round(this._m00 * d + this._m01 * d2 + this._m02), (int)Math.round(this._m10 * d + this._m11 * d2 + this._m12));
        this._vscreen.transform2Screen(point);
        return point;
    }

    public Point transformXPoint(XPoint xPoint) {
        return this.transformXPoint(xPoint.x, xPoint.y);
    }

    public Point[] transformXPoint(XPoint[] xPointArray) {
        Point[] pointArray = new Point[xPointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            pointArray[n] = this.transformXPoint(xPointArray[n]);
            ++n;
        }
        return pointArray;
    }

    public XPolygon transformXPolygon(int[] nArray, int[] nArray2, int n) {
        return new XPolygon(this.transformXPoint(nArray, nArray2, n));
    }

    public XPolygon transformXPolygon(Point[] pointArray) {
        return new XPolygon(this.transformXPoint(pointArray));
    }

    public XPolygon transformXPolygon(Polygon polygon) {
        return new XPolygon(this.transformXPoint(polygon.xpoints, polygon.ypoints, polygon.npoints));
    }

    public Point[] transformXPolygon(XPolygon xPolygon) {
        if (xPolygon.length() < 1) {
            return null;
        }
        if (xPolygon.length() == 1) {
            Point[] pointArray = new Point[]{this.transformXPoint(xPolygon.point(0))};
            return pointArray;
        }
        SimpleList simpleList = xPolygon.getSegmentList((byte)1);
        simpleList = this.convertPolygonSegmentList2PointList(this.clipSegmentList(simpleList));
        Point[] pointArray = new Point[simpleList.length()];
        int n = 0;
        ListItem listItem = simpleList.first();
        while (listItem != null) {
            if (listItem.value() instanceof XPoint) {
                pointArray[n] = this.transformXPoint((XPoint)listItem.value());
                ++n;
            }
            listItem = listItem.next();
        }
        return pointArray;
    }

    public boolean drawable(XPoint xPoint) {
        if (this._border == null) {
            this.calculateClipBorder();
        }
        int n = 0;
        do {
            if (this._border[n].orientation(xPoint) == 1) continue;
            return false;
        } while (++n < 4);
        return true;
    }

    private void pushChain(SimpleList simpleList, XPoint xPoint, XPoint xPoint2) {
        int n = 0;
        while (n < 4 && !this._border[n].liesOn(xPoint)) {
            ++n;
        }
        if (n >= 4) {
            return;
        }
        int n2 = 0;
        while (n2 < 4 && !this._border[n].liesOn(xPoint2)) {
            simpleList.add((Object)this._border[n].target());
            ++n2;
            n = (n + 1) % 4;
        }
    }

    public Point[] transformXParabola(XParabola xParabola) {
        Point point;
        double d = xParabola.getIntervalParameter(false);
        double d2 = xParabola.getIntervalParameter(true);
        if (d == Double.POSITIVE_INFINITY || d2 == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            XPoint[] xPointArray = this.getXBounds().getMinMaxPoints();
            double[] dArray = xParabola.getBoxInterval(xPointArray[0].x, xPointArray[0].y, xPointArray[1].x, xPointArray[1].y);
            if (dArray == null) {
                return null;
            }
            d = dArray[0];
            d2 = dArray[1];
        }
        if (d == Double.POSITIVE_INFINITY || d2 == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        double d3 = this.getXResolution();
        Queue queue = new Queue();
        Point point2 = null;
        while (d <= d2) {
            point = this.transformXPoint(xParabola.point(d));
            if (point2 == null || point != null && !point2.equals(point)) {
                queue.push((Object)point);
            }
            point2 = point;
            d += d3;
        }
        if (d - d3 < d2) {
            point = this.transformXPoint(xParabola.point(d2));
            if (point2 == null || !point2.equals(point)) {
                queue.push((Object)point);
            }
        }
        Point[] pointArray = new Point[queue.length()];
        int n = 0;
        while (n < pointArray.length) {
            pointArray[n] = (Point)queue.pop();
            ++n;
        }
        return pointArray;
    }

    public Point[] getBoundPoints() {
        Rectangle rectangle = this._vscreen.getBounds();
        Point[] pointArray = new Point[]{new Point(0, rectangle.height), new Point(rectangle.width, rectangle.height), new Point(rectangle.width, 0), new Point(0, 0)};
        return pointArray;
    }

    public XRay transformXRay(Point point, Point point2) {
        return new XRay(this.transformXPoint(point), this.transformXPoint(point2));
    }

    public XRay transformXRay(int n, int n2, int n3, int n4) {
        return new XRay(this.transformXPoint(n, n2), this.transformXPoint(n3, n4));
    }

    public Point[] transformXRay(XRay xRay) {
        Point[] pointArray = new Point[2];
        XPolygon xPolygon = this.getXBounds();
        Intersection intersection = xPolygon.intersection(xRay);
        if (intersection.empty()) {
            return null;
        }
        if (intersection.length() > 1) {
            pointArray[0] = this.transformXPoint(intersection.xpoint(0));
            pointArray[1] = this.transformXPoint(intersection.xpoint(1));
        } else {
            pointArray[0] = this.transformXPoint(xRay.source());
            pointArray[1] = this.transformXPoint(intersection.xpoint(0));
        }
        return pointArray;
    }

    public void calculateClipBorder() {
        if (this._vscreen == null) {
            return;
        }
        XPoint xPoint = this.transformXPoint(-this.CLIP_INT, this.CLIP_INT);
        XPoint xPoint2 = this.transformXPoint(this.CLIP_INT, -this.CLIP_INT);
        this._border = new XSegment[4];
        this._border[0] = new XSegment(xPoint.x, xPoint.y, xPoint2.x, xPoint.y);
        this._border[1] = new XSegment(xPoint2.x, xPoint.y, xPoint2.x, xPoint2.y);
        this._border[2] = new XSegment(xPoint2.x, xPoint2.y, xPoint.x, xPoint2.y);
        this._border[3] = new XSegment(xPoint.x, xPoint2.y, xPoint.x, xPoint.y);
    }

    public void setVirtualScreen(VirtualScreen virtualScreen) {
        this._vscreen = virtualScreen;
    }

    public boolean transformObjectToPseudoScreen(Object object) {
        if (object instanceof AffineXTransformable) {
            ((AffineXTransformable)object).transform(this._m00, this._m01, this._m02, this._m10, this._m11, this._m12);
            return true;
        }
        return false;
    }

    public XLine transformXLine(Point point, Point point2) {
        return new XLine(this.transformXPoint(point), this.transformXPoint(point2));
    }

    public XLine transformXLine(int n, int n2, int n3, int n4) {
        return new XLine(this.transformXPoint(n, n2), this.transformXPoint(n3, n4));
    }

    public Point[] transformXLine(XLine xLine) {
        Point[] pointArray = new Point[2];
        XPolygon xPolygon = this.getXBounds();
        Intersection intersection = xPolygon.intersection(xLine);
        if (intersection.empty()) {
            return null;
        }
        pointArray[0] = this.transformXPoint(intersection.xpoint(0));
        pointArray[1] = this.transformXPoint(intersection.xpoint(1));
        return pointArray;
    }

    public Object transformVector(int n, int n2) {
        double d = this._vscreen.vectorX(n);
        double d2 = this._vscreen.vectorY(n2);
        return new XPoint(this._a00 * d + this._a01 * d2, this._a10 * d + this._a11 * d2);
    }

    public Point transformVector(Object object) {
        if (object instanceof XPoint) {
            XPoint xPoint = (XPoint)object;
            Point point = new Point((int)Math.round(this._m00 * xPoint.x + this._m01 * xPoint.y), (int)Math.round(this._m10 * xPoint.x + this._m11 * xPoint.y));
            point.x = this._vscreen.vectorX(point.x);
            point.y = this._vscreen.vectorY(point.y);
            return point;
        }
        throw new ScreenTransformException((ScreenTransformation)this, object);
    }

    public XRectangle transformXRectangle(int n, int n2, int n3, int n4) {
        return new XRectangle(this.transformXPoint(n, n2), this.transformXPoint(n + n3 - 1, n2 + n4 - 1));
    }

    public XRectangle transformXRectangle(Rectangle rectangle) {
        return this.transformXRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private class ScreenXTransformationStatus {
        private double _t00;
        private double _t01;
        private double _t02;
        private double _t10;
        private double _t11;
        private double _t12;

        ScreenXTransformationStatus() {
            ScreenXTransformation.this.getClass();
            this._t00 = ScreenXTransformation.this._m00;
            this._t01 = ScreenXTransformation.this._m01;
            this._t02 = ScreenXTransformation.this._m02;
            this._t10 = ScreenXTransformation.this._m10;
            this._t11 = ScreenXTransformation.this._m11;
            this._t12 = ScreenXTransformation.this._m12;
        }

        void restore() {
            ScreenXTransformation.this._m00 = this._t00;
            ScreenXTransformation.this._m01 = this._t01;
            ScreenXTransformation.this._m02 = this._t02;
            ScreenXTransformation.this._m10 = this._t10;
            ScreenXTransformation.this._m11 = this._t11;
            ScreenXTransformation.this._m12 = this._t12;
        }
    }
}

