/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.x.Area;
import gishur.x.AreaIntersectable;
import gishur.x.Intersection;
import gishur.x.IntersectionException;
import gishur.x.XBaseline;
import gishur.x.XLine;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XRay;
import gishur.x.XSegment;
import gishur.x.XUPolygon;

public class XHalfplane
extends XLine
implements AreaIntersectable {
    private byte _orientation = 1;

    public void setOrientation(byte by) {
        this._orientation = by;
    }

    private Area halfplaneintersection(XHalfplane xHalfplane) {
        Intersection intersection = super.intersection(xHalfplane);
        Area area = null;
        if (intersection.xpoint() != null) {
            XPoint xPoint = xHalfplane.source();
            if (intersection.xpoint().equals(xPoint)) {
                xPoint = xHalfplane.target();
            }
            XRay xRay = new XRay(intersection.xpoint(), xPoint);
            if (this.locate(xPoint) == 3) {
                xRay = new XRay(intersection.xpoint(), xRay.slope(), XBaseline.oppositeDirection(xRay.direction()));
            }
            xPoint = this.source();
            if (intersection.xpoint().equals(xPoint)) {
                xPoint = this.target();
            }
            XRay xRay2 = new XRay(intersection.xpoint(), xPoint);
            if (xHalfplane.locate(xPoint) == 3) {
                xRay2 = new XRay(intersection.xpoint(), xRay2.slope(), XBaseline.oppositeDirection(xRay2.direction()));
            }
            XUPolygon xUPolygon = new XUPolygon();
            xUPolygon.add(intersection.xpoint());
            xUPolygon.setInRay(xRay);
            xUPolygon.setOutRay(xRay2);
            xUPolygon.setOrientation(xRay2.orientation(xRay.target()));
            area = new Area(xUPolygon);
            area.setConvexMode((byte)2);
        }
        return area;
    }

    public String toString(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = this.toString(bl2, bl3);
        if (!string.equals("")) {
            string = "," + string;
        }
        if (bl) {
            string = ",source=" + this._source.toString(true) + ",target=" + this._target.toString(true) + string;
        }
        if (bl4) {
            switch (this._orientation) {
                case 1: {
                    string = string + ",orientation=left";
                    break;
                }
                case 2: {
                    string = string + ",orientation=right";
                    break;
                }
                case 3: {
                    string = string + ",orientation=line";
                    break;
                }
                default: {
                    string = string + ",no orientation";
                }
            }
        }
        return string.substring(1);
    }

    public XHalfplane() {
    }

    public XHalfplane(double d, double d2, double d3, double d4, byte by) {
        super(d, d2, d3, d4);
        this._orientation = by;
    }

    public XHalfplane(XPoint xPoint, XPoint xPoint2, byte by) {
        super(xPoint.x, xPoint.y, xPoint2.x, xPoint2.y);
        this._orientation = by;
    }

    public XHalfplane(XPoint xPoint, double d, byte by) {
        super(xPoint, d);
        this._orientation = by;
    }

    public XHalfplane(XLine xLine, byte by) {
        super(xLine);
        this._orientation = by;
    }

    public XHalfplane(XHalfplane xHalfplane) {
        this.copy(xHalfplane);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toString(true, true, false, true) + "]";
    }

    public boolean in(XPoint xPoint) {
        return this.locate(xPoint) == 1;
    }

    public boolean contains(double d, double d2) {
        return this.locate(new XPoint(d, d2)) != 3;
    }

    public boolean supportsIntersection(AreaIntersectable areaIntersectable, boolean bl) {
        if (areaIntersectable == null) {
            return false;
        }
        return areaIntersectable instanceof XHalfplane;
    }

    public byte locate(XPoint xPoint) {
        if (super.contains(xPoint.x, xPoint.y)) {
            return 2;
        }
        if (this.orientation(xPoint) == this._orientation) {
            return 1;
        }
        return 3;
    }

    public void copy(XHalfplane xHalfplane) {
        super.copy(xHalfplane);
        this._orientation = xHalfplane._orientation;
    }

    public Area intersection(AreaIntersectable areaIntersectable, boolean bl) {
        if (areaIntersectable instanceof XHalfplane) {
            XHalfplane xHalfplane = (XHalfplane)areaIntersectable;
            Area area = new Area(this.getInfiniteXPolygon().convexPolygonIntersection(xHalfplane.getInfiniteXPolygon()));
            area.setConvexMode((byte)2);
            return area;
        }
        throw new IntersectionException(this, areaIntersectable);
    }

    public XPolygon getInfiniteXPolygon() {
        XSegment xSegment = this.getInfiniteSegment();
        XPoint[] xPointArray = new XPoint[6];
        if (this._orientation == 2) {
            XBaseline.copyInfiniteChain(xSegment.source(), xSegment.target(), xPointArray, 0);
        } else {
            XBaseline.copyInfiniteChain(xSegment.target(), xSegment.source(), xPointArray, 0);
        }
        return new XPolygon(xPointArray);
    }

    public boolean convex() {
        return true;
    }

    public byte orientation() {
        return this._orientation;
    }
}

