/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.ExtMath;
import gishur.x.Intersectable;
import gishur.x.Intersection;
import gishur.x.IntersectionException;
import gishur.x.XBaseline;
import gishur.x.XLine;
import gishur.x.XObject;
import gishur.x.XPoint;
import gishur.x.XRay;
import gishur.x.XSegment;

public class XParabola
extends XObject
implements Intersectable {
    private double a;
    private double b;
    private double x;
    private double y;
    private double phi;
    private double source_t = Double.NEGATIVE_INFINITY;
    private double target_t = Double.POSITIVE_INFINITY;

    public void setSource(double d) {
        this.source_t = d;
    }

    public boolean validParameter(double d) {
        return this.source_t - 1.0E-7 <= d && d <= this.target_t + 1.0E-7 || this.source_t + 1.0E-7 >= d && d >= this.target_t - 1.0E-7;
    }

    public void setSource(XPoint xPoint) {
        double d = this.getParameter(xPoint);
        if (d == Double.POSITIVE_INFINITY) {
            return;
        }
        this.source_t = d;
    }

    public boolean liesOn(XPoint xPoint) {
        return this.contains(xPoint.x, xPoint.y);
    }

    public void setTarget(double d) {
        this.target_t = d;
    }

    public void setTarget(XPoint xPoint) {
        double d = this.getParameter(xPoint);
        if (d == Double.POSITIVE_INFINITY) {
            return;
        }
        this.target_t = d;
    }

    public String toString() {
        String string = "<";
        if (this.source_t > this.target_t) {
            string = ">";
        }
        string = this.source_t + string + "t" + string + this.target_t;
        return this.getClass().getName() + "[" + this.a + "x\u00b2+" + this.b + ",phi=" + this.phi + ",dx=(" + this.x + "," + this.y + ")," + string + "]";
    }

    public XParabola(double d, double d2, double d3, XPoint xPoint) {
        this.a = d;
        this.b = d2;
        this.phi = d3;
        this.x = xPoint.x;
        this.y = xPoint.y;
    }

    public XParabola(XBaseline xBaseline, XPoint xPoint) {
        XLine xLine = new XLine(xBaseline.source(), xBaseline.target());
        XPoint xPoint2 = xLine.plumb(xPoint);
        this.phi = xPoint2.angle(xPoint) - 1.5707963267948966;
        double d = xPoint2.distance(xPoint);
        this.a = 0.5 / d;
        this.b = d / 2.0;
        this.x = xPoint2.x;
        this.y = xPoint2.y;
        if (xBaseline instanceof XSegment) {
            boolean bl;
            XSegment xSegment = (XSegment)xBaseline;
            double d2 = xSegment.source().distance(xPoint2);
            double d3 = xSegment.target().distance(xPoint2);
            boolean bl2 = bl = xSegment.orientation(xPoint) == 1;
            if (xSegment.liesOn(xPoint2)) {
                if (bl) {
                    this.source_t = -d2;
                    this.target_t = d3;
                    return;
                }
                this.source_t = d2;
                this.target_t = -d3;
                return;
            }
            if (d2 > d3) {
                boolean bl3 = bl = !bl;
            }
            if (bl) {
                this.source_t = d2;
                this.target_t = d3;
                return;
            }
            this.source_t = -d2;
            this.target_t = -d3;
        }
    }

    public XParabola(XParabola xParabola) {
        this.a = xParabola.a;
        this.b = xParabola.b;
        this.phi = xParabola.phi;
        this.x = xParabola.x;
        this.y = xParabola.y;
        this.source_t = xParabola.source_t;
        this.target_t = xParabola.target_t;
    }

    private double[] checkValidParameters(double[] dArray, XBaseline xBaseline) {
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (this.validParameter(dArray[n2])) {
                XPoint xPoint = this.point(dArray[n2]);
                if (!xBaseline.inBounds(xPoint.x, xPoint.y)) {
                    dArray[n2] = Double.POSITIVE_INFINITY;
                }
            } else {
                dArray[n2] = Double.POSITIVE_INFINITY;
            }
            if (dArray[n2] == Double.POSITIVE_INFINITY || dArray[n2] == Double.NEGATIVE_INFINITY) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return dArray;
        }
        double[] dArray2 = new double[dArray.length - n];
        n = 0;
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3] != Double.POSITIVE_INFINITY && dArray[n3] != Double.NEGATIVE_INFINITY) {
                dArray2[n++] = dArray[n3];
            }
            ++n3;
        }
        return dArray2;
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getParameter(new XPoint(d, d2));
        return d3 != Double.POSITIVE_INFINITY;
    }

    public boolean supportsIntersection(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XPoint) {
            return true;
        }
        if (object instanceof XSegment) {
            return true;
        }
        if (object instanceof XRay) {
            return true;
        }
        if (object instanceof XLine) {
            return true;
        }
        return object instanceof XParabola;
    }

    public XPoint source() {
        if (this.source_t == Double.NEGATIVE_INFINITY || this.source_t == Double.POSITIVE_INFINITY) {
            return null;
        }
        return this.point(this.source_t);
    }

    private double[][] basicParabolaIntersection(XParabola xParabola) {
        double d = xParabola.a;
        double d2 = xParabola.b;
        double d3 = xParabola.phi - this.phi;
        double d4 = Math.sin(-this.phi);
        double d5 = Math.cos(-this.phi);
        double d6 = (xParabola.x - this.x) * d5 - (xParabola.y - this.y) * d4;
        double d7 = (xParabola.x - this.x) * d4 + (xParabola.y - this.y) * d5;
        d4 = Math.sin(d3);
        d5 = Math.cos(d3);
        double d8 = d4 * d4 * d * d * this.a;
        double d9 = -2.0 * d4 * d5 * d * this.a;
        double d10 = 2.0 * d4 * d4 * d * d2 * this.a - 2.0 * d4 * d * d6 * this.a + d5 * d5 * this.a - d5 * d;
        double d11 = 2.0 * d5 * d6 * this.a - 2.0 * d4 * d5 * d2 * this.a - d4;
        double d12 = d4 * d4 * d2 * d2 * this.a - 2.0 * d4 * d2 * d6 * this.a + d6 * d6 * this.a + this.b - d5 * d2 - d7;
        double[][] dArray = Math.abs(d8) < 9.999999999999998E-15 ? ExtMath.findRoots((double)d10, (double)d11, (double)d12) : ExtMath.findRoots((double)d8, (double)d9, (double)d10, (double)d11, (double)d12);
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (dArray[n2][1] == 0.0) {
                ++n;
            }
            ++n2;
        }
        double[][] dArray2 = new double[n][2];
        n = 0;
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3][1] == 0.0) {
                dArray2[n++][1] = dArray[n3][0];
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < dArray2.length) {
            dArray2[n3][0] = -d4 * d * dArray2[n3][1] * dArray2[n3][1] + d5 * dArray2[n3][1] - d4 * d2 + d6;
            ++n3;
        }
        return dArray2;
    }

    public void flip() {
        double d = this.source_t;
        this.source_t = this.target_t;
        this.target_t = d;
    }

    private double[] basicLineIntersection(XBaseline xBaseline) {
        if (xBaseline.vertical()) {
            return this.getXParameters(xBaseline.source().x);
        }
        double d = Math.sin(this.phi);
        double d2 = Math.cos(this.phi);
        double d3 = xBaseline.slope();
        double d4 = xBaseline.y_abs();
        if (Math.abs(d2 * this.a + d * this.a * d3) < 1.0E-7) {
            double[] dArray = new double[]{(d2 * this.b + this.y + d * this.b * d3 - this.x * d3 - d4) / (d2 * d3 - d)};
            return dArray;
        }
        double[][] dArray = ExtMath.findRoots((double)(d2 * this.a + d * this.a * d3), (double)(d - d2 * d3), (double)(d2 * this.b + this.y + d * this.b * d3 - this.x * d3 - d4));
        if (dArray[0][1] != 0.0) {
            return new double[0];
        }
        if (dArray[0][0] == dArray[1][0]) {
            double[] dArray2 = new double[]{dArray[0][0]};
            return dArray2;
        }
        double[] dArray3 = new double[]{Math.min(dArray[0][0], dArray[1][0]), Math.max(dArray[0][0], dArray[1][0])};
        return dArray3;
    }

    public double[] getBoxInterval(double d, double d2, double d3, double d4) {
        double[] dArray = this.getXParameters(d);
        double[] dArray2 = this.getXParameters(d3);
        double[] dArray3 = this.getYParameters(d2);
        double[] dArray4 = this.getYParameters(d4);
        double[] dArray5 = new double[2 + dArray.length + dArray2.length + dArray3.length + dArray4.length];
        int n = 0;
        if (dArray.length > 0) {
            System.arraycopy(dArray, 0, dArray5, n, dArray.length);
        }
        n += dArray.length;
        if (dArray2.length > 0) {
            System.arraycopy(dArray2, 0, dArray5, n, dArray2.length);
        }
        n += dArray2.length;
        if (dArray3.length > 0) {
            System.arraycopy(dArray3, 0, dArray5, n, dArray3.length);
        }
        n += dArray3.length;
        if (dArray4.length > 0) {
            System.arraycopy(dArray4, 0, dArray5, n, dArray4.length);
        }
        dArray5[n += dArray4.length] = this.source_t;
        dArray5[n + 1] = this.target_t;
        if ((dArray5 = this.findIn(dArray5, d, d2, d3, d4))[0] == Double.POSITIVE_INFINITY || dArray5[0] == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return dArray5;
    }

    public Intersection intersection(Object object) {
        if (this.supportsIntersection(object)) {
            if (object instanceof XPoint) {
                if (this.liesOn((XPoint)object)) {
                    return new Intersection(((XPoint)object).clone());
                }
                return new Intersection();
            }
            if (object instanceof XBaseline) {
                double[] dArray = this.basicLineIntersection((XBaseline)object);
                if ((dArray = this.checkValidParameters(dArray, (XBaseline)object)).length == 0) {
                    return new Intersection();
                }
                XPoint[] xPointArray = new XPoint[dArray.length];
                int n = 0;
                while (n < dArray.length) {
                    xPointArray[n] = this.point(dArray[n]);
                    ++n;
                }
                if (((XBaseline)object).vertical()) {
                    n = 0;
                    while (n < dArray.length) {
                        xPointArray[n].x = ((XBaseline)object).source().x;
                        ++n;
                    }
                }
                return new Intersection(xPointArray);
            }
            if (object instanceof XParabola) {
                XParabola xParabola = (XParabola)object;
                double[][] dArray = this.basicParabolaIntersection(xParabola);
                int n = 0;
                int n2 = 0;
                while (n2 < dArray.length) {
                    if (this.validParameter(dArray[n2][0]) && xParabola.validParameter(dArray[n2][1])) {
                        ++n;
                    }
                    ++n2;
                }
                if (n == 0) {
                    return new Intersection();
                }
                XPoint[] xPointArray = new XPoint[n];
                n = 0;
                int n3 = 0;
                while (n3 < dArray.length) {
                    if (this.validParameter(dArray[n3][0]) && xParabola.validParameter(dArray[n3][1])) {
                        xPointArray[n++] = this.point(dArray[n3][0]);
                    }
                    ++n3;
                }
                return new Intersection(xPointArray);
            }
        } else {
            if (object instanceof Intersectable && ((Intersectable)object).supportsIntersection(this)) {
                return ((Intersectable)object).intersection(this);
            }
            throw new IntersectionException(this, this, object);
        }
        throw new IntersectionException(this, this, object);
    }

    public XObject transform_XObject(double d, double d2, double d3, double d4, double d5, double d6) {
        return this;
    }

    public double getParameter(XPoint xPoint) {
        if (xPoint == null) {
            return Double.POSITIVE_INFINITY;
        }
        double[] dArray = this.getXParameters(xPoint.x);
        if (dArray.length <= 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.validParameter(dArray[0]) && this.point(dArray[0]).equals(xPoint)) {
            return dArray[0];
        }
        if (dArray.length < 2) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.validParameter(dArray[1]) && this.point(dArray[1]).equals(xPoint)) {
            return dArray[1];
        }
        dArray = this.getYParameters(xPoint.y);
        if (dArray.length <= 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.validParameter(dArray[0]) && this.point(dArray[0]).equals(xPoint)) {
            return dArray[0];
        }
        if (dArray.length < 2) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.validParameter(dArray[1]) && this.point(dArray[1]).equals(xPoint)) {
            return dArray[1];
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getIntervalParameter(boolean bl) {
        if (bl) {
            return Math.max(this.source_t, this.target_t);
        }
        return Math.min(this.source_t, this.target_t);
    }

    public double[] getXParameters(double d) {
        double d2 = Math.sin(this.phi);
        double d3 = Math.cos(this.phi);
        if (Math.abs(d2 * this.a) < 1.0E-7) {
            double[] dArray = new double[]{(d - this.x) / d3};
            return dArray;
        }
        double[][] dArray = ExtMath.findRoots((double)(-d2 * this.a), (double)d3, (double)(-d2 * this.b + this.x - d));
        if (dArray[0][1] != 0.0) {
            return new double[0];
        }
        double[] dArray2 = dArray[0][0] == dArray[1][0] ? new double[]{dArray[0][0]} : new double[]{Math.min(dArray[0][0], dArray[1][0]), Math.max(dArray[0][0], dArray[1][0])};
        return dArray2;
    }

    public XPoint point(double d) {
        if (!this.validParameter(d)) {
            return null;
        }
        double d2 = Math.sin(this.phi);
        double d3 = Math.cos(this.phi);
        return new XPoint(-d2 * this.a * d * d + d3 * d - d2 * this.b + this.x, d3 * this.a * d * d + d2 * d + d3 * this.b + this.y);
    }

    public XPoint calculatePoint(double d) {
        double[] dArray = this.getXParameters(d);
        if (dArray.length == 0) {
            return null;
        }
        if (dArray.length == 1) {
            return this.point(dArray[0]);
        }
        XPoint xPoint = this.point(dArray[0]);
        XPoint xPoint2 = this.point(dArray[1]);
        if (xPoint == null) {
            return xPoint2;
        }
        if (xPoint2 == null) {
            return xPoint;
        }
        if (xPoint.y < xPoint2.y) {
            return xPoint;
        }
        return xPoint2;
    }

    public XPoint target() {
        if (this.target_t == Double.NEGATIVE_INFINITY || this.target_t == Double.POSITIVE_INFINITY) {
            return null;
        }
        return this.point(this.target_t);
    }

    public double[] getYParameters(double d) {
        double d2 = Math.sin(this.phi);
        double d3 = Math.cos(this.phi);
        if (Math.abs(d3 * this.a) < 1.0E-7) {
            double[] dArray = new double[]{(this.y - d) / d2};
            return dArray;
        }
        double[][] dArray = ExtMath.findRoots((double)(d3 * this.a), (double)d2, (double)(d3 * this.b + this.y - d));
        if (dArray[0][1] != 0.0) {
            return new double[0];
        }
        double[] dArray2 = dArray[0][0] == dArray[1][0] ? new double[]{dArray[0][0]} : new double[]{Math.min(dArray[0][0], dArray[1][0]), Math.max(dArray[0][0], dArray[1][0])};
        return dArray2;
    }

    private double[] findIn(double[] dArray, double d, double d2, double d3, double d4) {
        Object object;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        d -= 1.0E-7;
        d2 -= 1.0E-7;
        d3 += 1.0E-7;
        d4 += 1.0E-7;
        if (dArray != null && dArray.length > 0) {
            int n = 0;
            while (n < dArray.length) {
                if ((dArray[n] > d6 || dArray[n] < d5) && (object = (Object)this.point(dArray[n])) != null && object.x >= d && object.x <= d3 && object.y >= d2 && object.y <= d4) {
                    if (dArray[n] > d6) {
                        d6 = dArray[n];
                    }
                    if (dArray[n] < d5) {
                        d5 = dArray[n];
                    }
                }
                ++n;
            }
        }
        object = new double[]{d5, d6};
        return object;
    }
}

