/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.x.AffineXTransformable;
import gishur.x.XObject;

public class XPoint
extends XObject
implements AffineXTransformable,
Cloneable {
    public static final double IDENTICAL = 1.0E-7;
    public static final double WEAK_IDENTICAL = 1.0E-4;
    public static final byte ORIENTATION_LEFT = 1;
    public static final byte ORIENTATION_RIGHT = 2;
    public static final byte ORIENTATION_COLLINEAR = 3;
    public double x = 0.0;
    public double y = 0.0;

    public double distance(XPoint xPoint) {
        if (xPoint == null) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.sqrt(this.squareDistance(xPoint));
    }

    public static final byte orientation(XPoint xPoint, XPoint xPoint2, XPoint xPoint3) {
        double d = (xPoint.x - xPoint2.x) * (xPoint.y - xPoint3.y);
        double d2 = (xPoint.y - xPoint2.y) * (xPoint.x - xPoint3.x);
        if (d < d2) {
            return 2;
        }
        if (d == d2) {
            return 3;
        }
        return 1;
    }

    public void normalize() {
        double d = this.norm();
        this.x /= d;
        this.y /= d;
    }

    public static final double angle(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d - d5;
        double d8 = d2 - d6;
        double d9 = d3 - d;
        double d10 = d4 - d2;
        double d11 = d7 * d9 + d8 * d10;
        double d12 = (d7 * d7 + d8 * d8) * (d9 * d9 + d10 * d10);
        if ((d11 = -(d11 / Math.sqrt(d12))) >= 1.0) {
            return 0.0;
        }
        if (d11 <= -1.0) {
            return Math.PI;
        }
        double d13 = Math.acos(d11);
        if (d7 * d10 - d8 * d9 > 0.0) {
            return d13;
        }
        return Math.PI * 2 - d13;
    }

    public double angle(XPoint xPoint, XPoint xPoint2) {
        return XPoint.angle(this.x, this.y, xPoint.x, xPoint.y, xPoint2.x, xPoint2.y);
    }

    public void setPolar(double d, double d2) {
        this.x = Math.cos(d) * d2;
        this.y = Math.sin(d) * d2;
    }

    public double angle(XPoint xPoint) {
        return XPoint.angle(this.x, this.y, this.x + 1.0, this.y, xPoint.x, xPoint.y);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XPoint) {
            return Math.abs(this.x - ((XPoint)object).x) < 1.0E-7 && Math.abs(this.y - ((XPoint)object).y) < 1.0E-7;
        }
        return false;
    }

    public boolean equals(double d, double d2) {
        return Math.abs(this.x - d) < 1.0E-7 && Math.abs(this.y - d2) < 1.0E-7;
    }

    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d * this.x + d2 * this.y + d3;
        double d8 = d4 * this.x + d5 * this.y + d6;
        this.x = d7;
        this.y = d8;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public void setLength(double d) {
        double d2 = this.norm();
        if (d2 == 0.0) {
            return;
        }
        this.x = this.x / d2 * d;
        this.y = this.y / d2 * d;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void scale(XPoint xPoint, double d, double d2) {
        this.transform(d, 0.0, -d * xPoint.x + xPoint.x, 0.0, d2, -d2 * xPoint.y + xPoint.y);
    }

    public void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public String toString(boolean bl) {
        if (!bl) {
            return this.x + "," + this.y;
        }
        return "(" + this.x + "," + this.y + ")";
    }

    public void rotate(XPoint xPoint, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.transform(d2, -d3, -xPoint.x * d2 + xPoint.y * d3 + xPoint.x, d3, d2, -xPoint.x * d3 - xPoint.y * d2 + xPoint.y);
    }

    public void rotate(XPoint xPoint, XPoint xPoint2, XPoint xPoint3) {
        this.rotate(xPoint, xPoint.angle(xPoint2, xPoint3));
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public XPoint() {
        this.y = 0.0;
        this.x = 0.0;
    }

    public XPoint(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public XPoint(XPoint xPoint) {
        this.copy(xPoint);
    }

    public XPoint(XPoint xPoint, XPoint xPoint2) {
        this.x = xPoint.x + (xPoint2.x - xPoint.x) / 2.0;
        this.y = xPoint.y + (xPoint2.y - xPoint.y) / 2.0;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.x + "," + this.y + "]";
    }

    public static final byte opposite(byte by) {
        switch (by) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return by;
    }

    public boolean isInfinite() {
        return this.x >= 2.0E7 || this.x <= -2.0E7 || this.y >= 2.0E7 || this.y <= -2.0E7;
    }

    public boolean weak_equals(XPoint xPoint) {
        return Math.abs(this.x - xPoint.x) < 1.0E-4 && Math.abs(this.y - xPoint.y) < 1.0E-4;
    }

    public void copy(XPoint xPoint) {
        if (xPoint == null) {
            return;
        }
        this.x = xPoint.x;
        this.y = xPoint.y;
    }

    public void translatePolar(double d, double d2) {
        this.x += Math.cos(d) * d2;
        this.y += Math.sin(d) * d2;
    }

    public double squareDistance(XPoint xPoint) {
        if (xPoint == null) {
            return Double.POSITIVE_INFINITY;
        }
        double d = xPoint.x - this.x;
        double d2 = xPoint.y - this.y;
        return d * d + d2 * d2;
    }

    public XObject transform_XObject(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x = d3 += d * this.x + d2 * this.y;
        this.y = d6 += d4 * this.x + d5 * this.y;
        return this;
    }

    public byte orientation(XPoint xPoint, XPoint xPoint2) {
        return XPoint.orientation(xPoint, xPoint2, this);
    }
}

