/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.BasicList;
import gishur.core.Cloneable;
import gishur.core.Comparitor;
import gishur.core.ListItem;
import gishur.core.SimpleList;
import gishur.x.AffineXTransformable;
import gishur.x.Intersectable;
import gishur.x.Intersection;
import gishur.x.IntersectionException;
import gishur.x.PointComparitor;
import gishur.x.XBaseline;
import gishur.x.XLine;
import gishur.x.XObject;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XRay;
import gishur.x.XSegment;
import gishur.x.XUPolygon;

public class XPolyline
extends XObject
implements Intersectable,
AffineXTransformable,
Cloneable {
    XPoint[] _points;

    public XPoint[] getMinMaxPoints() {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < this._points.length) {
            if (this._points[n].x < d2) {
                d2 = this._points[n].x;
            }
            if (this._points[n].x > d) {
                d = this._points[n].x;
            }
            if (this._points[n].y < d4) {
                d4 = this._points[n].y;
            }
            if (this._points[n].y > d3) {
                d3 = this._points[n].y;
            }
            ++n;
        }
        XPoint[] xPointArray = new XPoint[]{new XPoint(d2, d4), new XPoint(d, d3)};
        return xPointArray;
    }

    public int liesOn(XPoint xPoint) {
        int n = this.countBorderSegments();
        if (n < 1) {
            if (this._points.length == 1) {
                if (this._points[0].equals(xPoint)) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        int n2 = 0;
        while (n2 < n && !this.borderSegment(n2).liesOn(xPoint)) {
            ++n2;
        }
        if (n2 < n) {
            return n2;
        }
        return -1;
    }

    public boolean checkSimplicity(int n) {
        if (n < 0 || n >= this._points.length) {
            return false;
        }
        int n2 = this.countBorderSegments();
        if (n2 < 4) {
            return true;
        }
        XSegment xSegment = (n = this.findBorderIndex(n, false)) >= 0 ? this.borderSegment(n) : null;
        int n3 = this.findBorderIndex(n, true);
        XSegment xSegment2 = n3 >= 0 ? this.borderSegment(n3) : null;
        boolean bl = true;
        int n4 = 0;
        while (n4 < n2 && bl) {
            XSegment xSegment3 = this.borderSegment(n4);
            if (n4 < n - 1 || n4 > n + 1) {
                boolean bl2 = bl = bl && ((XBaseline)xSegment).intersection(xSegment3).empty();
            }
            if (n4 < n3 - 1 || n4 > n3 + 1) {
                bl = bl && ((XBaseline)xSegment2).intersection(xSegment3).empty();
            }
            ++n4;
        }
        return bl;
    }

    public boolean checkSimplicity(XPoint xPoint) {
        int n = this.indexOf(xPoint);
        if (n < 0) {
            n = this.findPoint(xPoint);
        }
        if (n < 0) {
            return true;
        }
        return this.checkSimplicity(n);
    }

    private void pswap(int n, int n2) {
        if (n == n2) {
            return;
        }
        XPoint xPoint = this._points[n2];
        this._points[n2] = this._points[n];
        this._points[n] = xPoint;
    }

    SimpleList eleminateDuplicatePoints(SimpleList simpleList) {
        if (simpleList.length() < 2) {
            return simpleList;
        }
        XPoint xPoint = (XPoint)simpleList.firstValue();
        ListItem listItem = simpleList.first().next();
        while (listItem != null) {
            ListItem listItem2 = listItem.next();
            XPoint xPoint2 = (XPoint)listItem.value();
            if (xPoint2.equals(xPoint)) {
                simpleList.remove(listItem);
            }
            listItem = listItem2;
        }
        return simpleList;
    }

    public XLine line(int n) {
        if (n < 0 || n >= this._points.length - 1) {
            return null;
        }
        return new XLine(this._points[n], this._points[n + 1]);
    }

    public void add(double d, double d2) {
        XPoint[] xPointArray = new XPoint[this._points.length + 1];
        try {
            System.arraycopy(this._points, 0, xPointArray, 0, this._points.length);
            xPointArray[this._points.length] = new XPoint(d, d2);
            this._points = xPointArray;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {
            return;
        }
    }

    public void add(XPoint xPoint) {
        this.add(xPoint.x, xPoint.y);
    }

    public boolean supportsIntersection(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XPoint) {
            return true;
        }
        if (object instanceof XLine) {
            return true;
        }
        if (object instanceof XRay) {
            return true;
        }
        if (object instanceof XSegment) {
            return true;
        }
        if (object instanceof XPolygon) {
            return false;
        }
        if (object instanceof XUPolygon) {
            return false;
        }
        return object instanceof XPolyline;
    }

    public double circumference() {
        double d = 0.0;
        int n = 0;
        while (n < this._points.length - 1) {
            d += this._points[n].distance(this._points[n + 1]);
            ++n;
        }
        return d;
    }

    public int indexOf(XPoint xPoint) {
        int n = 0;
        n = 0;
        while (n < this._points.length && xPoint != this._points[n]) {
            ++n;
        }
        if (n >= this._points.length) {
            return -1;
        }
        return n;
    }

    public void reverse() {
        int n = 0;
        while (n < this._points.length / 2) {
            this.pswap(n, this._points.length - 1 - n);
            ++n;
        }
    }

    public int findPoint(XPoint xPoint, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < this._points.length && !xPoint.equals(this._points[n2])) {
            ++n2;
        }
        if (n2 >= this._points.length) {
            return -1;
        }
        return n2;
    }

    public int findPoint(XPoint xPoint) {
        return this.findPoint(xPoint, 0);
    }

    public void setPoint(XPoint xPoint, int n) {
        if (this._points == null || xPoint == null || n < 0 || n > this._points.length - 1) {
            return;
        }
        this._points[n] = xPoint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XPolyline)) {
            return false;
        }
        XPolyline xPolyline = (XPolyline)object;
        if (this._points.length != xPolyline._points.length) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < this._points.length && bl) {
            bl = this._points[n].equals(xPolyline._points[n]);
            ++n;
        }
        return bl;
    }

    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = 0;
        while (n < this._points.length) {
            double d7 = d * this._points[n].x + d2 * this._points[n].y + d3;
            double d8 = d4 * this._points[n].x + d5 * this._points[n].y + d6;
            this._points[n].set(d7, d8);
            ++n;
        }
    }

    public Object clone() {
        XPolyline xPolyline = new XPolyline(this);
        int n = 0;
        while (n < this._points.length) {
            xPolyline._points[n] = (XPoint)this._points[n].clone();
            ++n;
        }
        return xPolyline;
    }

    public int length() {
        return this._points.length;
    }

    public void scale(XPoint xPoint, double d, double d2) {
        this.transform(d, 0.0, -d * xPoint.x + xPoint.x, 0.0, d2, -d2 * xPoint.y + xPoint.y);
    }

    public void remove(int n) {
        if (n < 0 || n >= this._points.length) {
            return;
        }
        if (this._points.length <= 1) {
            this.clear();
            return;
        }
        XPoint[] xPointArray = new XPoint[this._points.length - 1];
        try {
            System.arraycopy(this._points, 0, xPointArray, 0, n);
            System.arraycopy(this._points, n + 1, xPointArray, n, this._points.length - n - 1);
            this._points = xPointArray;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {
            return;
        }
    }

    public void cycle(int n) {
        if (n <= 0 || n >= this._points.length) {
            return;
        }
        XPoint[] xPointArray = new XPoint[this._points.length];
        try {
            System.arraycopy(this._points, 0, xPointArray, 0, this._points.length);
            System.arraycopy(xPointArray, n, this._points, 0, this._points.length - n);
            System.arraycopy(xPointArray, 0, this._points, this._points.length - n, n);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {
            return;
        }
    }

    SimpleList intersection_impl(XBaseline xBaseline) {
        SimpleList simpleList = new SimpleList();
        int n = 0;
        while (n < this.countBorderSegments()) {
            Intersection intersection = this.borderSegment(n).intersection(xBaseline);
            if (!intersection.empty()) {
                simpleList.add(intersection.object());
            }
            ++n;
        }
        if (simpleList.empty()) {
            return null;
        }
        return this.eleminateDuplicatePoints(simpleList);
    }

    SimpleList intersection_impl(XPolyline xPolyline) {
        SimpleList simpleList = new SimpleList();
        SimpleList simpleList2 = new SimpleList();
        PointComparitor pointComparitor = new PointComparitor(4);
        int n = xPolyline.countBorderSegments();
        int n2 = 0;
        while (n2 < this.countBorderSegments()) {
            simpleList2.clear();
            int n3 = 0;
            while (n3 < n) {
                Intersection intersection = this.borderSegment(n2).intersection(xPolyline.borderSegment(n3));
                if (!intersection.empty()) {
                    simpleList2.add(intersection.object());
                }
                ++n3;
            }
            if (simpleList2.length() > 1) {
                pointComparitor.setReferencePoint(this.borderSegment(n2).source());
                simpleList2.sort((Comparitor)pointComparitor, (short)1);
            }
            if (!simpleList2.empty()) {
                simpleList.concat((BasicList)simpleList2);
            }
            ++n2;
        }
        if (simpleList.empty()) {
            return null;
        }
        return this.eleminateDuplicatePoints(simpleList);
    }

    public void set(XPoint[] xPointArray) {
        if (xPointArray == null || xPointArray.length == 0) {
            this.clear();
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < xPointArray.length) {
            if (xPointArray[n2] != null) {
                ++n;
            }
            ++n2;
        }
        this._points = new XPoint[n];
        n = 0;
        n2 = 0;
        while (n2 < xPointArray.length) {
            if (xPointArray[n2] != null) {
                this._points[n++] = xPointArray[n2];
            }
            ++n2;
        }
    }

    public void set(SimpleList simpleList) {
        if (simpleList == null || simpleList.empty()) {
            this.clear();
            return;
        }
        int n = 0;
        XPoint[] xPointArray = new XPoint[2 * simpleList.length() + 2];
        ListItem listItem = simpleList.first();
        while (listItem != null) {
            Object object = listItem.value();
            if (object != null) {
                if (object instanceof XPoint) {
                    xPointArray[n] = new XPoint((XPoint)object);
                    if (n == 0 || !xPointArray[n - 1].equals(xPointArray[n])) {
                        ++n;
                    }
                }
                if (object instanceof XRay) {
                    xPointArray[n] = ((XRay)object).source();
                    if (n == 0 || !xPointArray[n - 1].equals(xPointArray[n])) {
                        ++n;
                    }
                }
                if (object instanceof XSegment) {
                    xPointArray[n] = ((XSegment)object).source();
                    if (n == 0 || !xPointArray[n - 1].equals(xPointArray[n])) {
                        ++n;
                    }
                    xPointArray[n] = ((XSegment)object).target();
                    if (n == 0 || !xPointArray[n - 1].equals(xPointArray[n])) {
                        ++n;
                    }
                }
            }
            listItem = listItem.next();
        }
        if (n > 1 && xPointArray[0].equals(xPointArray[n - 1])) {
            --n;
        }
        this._points = new XPoint[n];
        try {
            if (n > 0) {
                System.arraycopy(xPointArray, 0, this._points, 0, n);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {}
    }

    public String toString(boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            string = string + ",length=" + this.length();
        }
        if (bl2) {
            string = string + ",{";
            int n = 0;
            while (n < this._points.length - 1) {
                string = string + this._points[n].toString(true) + ",";
                ++n;
            }
            string = this._points.length > 0 ? string + this._points[n].toString(true) + "}" : string + "}";
        }
        return string.substring(1);
    }

    public void rotate(XPoint xPoint, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.transform(d2, -d3, -xPoint.x * d2 + xPoint.y * d3 + xPoint.x, d3, d2, -xPoint.x * d3 - xPoint.y * d2 + xPoint.y);
    }

    public void rotate(XPoint xPoint, XPoint xPoint2, XPoint xPoint3) {
        this.rotate(xPoint, xPoint.angle(xPoint2, xPoint3));
    }

    public void translate(double d, double d2) {
        this.transform(1.0, 0.0, d, 0.0, 1.0, d2);
    }

    public XPolyline() {
        this.clear();
    }

    public XPolyline(XPoint[] xPointArray) {
        this.set(xPointArray);
    }

    public XPolyline(SimpleList simpleList) {
        this.set(simpleList);
    }

    public XPolyline(XPolyline xPolyline) {
        this.copy(xPolyline);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toString(true, true) + "]";
    }

    public void insert(double d, double d2, int n) {
        if (n < 0 || n > this._points.length) {
            return;
        }
        XPoint[] xPointArray = new XPoint[this._points.length + 1];
        try {
            System.arraycopy(this._points, 0, xPointArray, 0, n);
            System.arraycopy(this._points, n, xPointArray, n + 1, this._points.length - n);
            xPointArray[n] = new XPoint(d, d2);
            this._points = xPointArray;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {
            return;
        }
    }

    public void insert(XPoint xPoint, int n) {
        this.insert(xPoint.x, xPoint.y, n);
    }

    public boolean contains(double d, double d2) {
        return this.liesOn(new XPoint(d, d2)) >= 0;
    }

    public SimpleList getSegmentList() {
        SimpleList simpleList = new SimpleList();
        int n = 0;
        while (n < this._points.length - 1) {
            simpleList.push((Object)new XSegment(this._points[n], this._points[n + 1]));
            ++n;
        }
        return simpleList;
    }

    public void copy(XPolyline xPolyline) {
        if (xPolyline == null) {
            return;
        }
        this._points = new XPoint[xPolyline._points.length];
        try {
            System.arraycopy(xPolyline._points, 0, this._points, 0, this._points.length);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {
            return;
        }
    }

    public XPolyline copy(XPoint xPoint, XPoint xPoint2) {
        int n = this.liesOn(xPoint);
        int n2 = this.liesOn(xPoint2);
        int n3 = n;
        if (n < 0 || n2 < 0) {
            return null;
        }
        SimpleList simpleList = new SimpleList();
        XSegment xSegment = this.borderSegment(n);
        simpleList.push((Object)xPoint);
        if (n == n2) {
            if (xSegment.source().squareDistance(xPoint2) < xSegment.source().squareDistance(xPoint)) {
                simpleList.push((Object)xPoint);
                xSegment = this.borderSegment(n);
                simpleList.push((Object)xSegment.target());
                ++n;
            } else {
                simpleList.push((Object)xPoint);
            }
        }
        while (n != n2 && this.borderSegment(n).incident(this.borderSegment(n3))) {
            simpleList.push((Object)xSegment.target());
            n3 = n;
            n = (n + 1) % this.countBorderSegments();
            xSegment = this.borderSegment(n);
        }
        if (this.borderSegment(n2).liesOn(xPoint2)) {
            simpleList.push((Object)xPoint2);
        } else {
            simpleList.push((Object)this.borderSegment(n2).target());
        }
        return new XPolyline(simpleList);
    }

    public boolean simple() {
        int n = this.countBorderSegments();
        if (n < 4) {
            return true;
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < n - 2) {
            XSegment xSegment = this.borderSegment(n2);
            int n3 = n2 + 2;
            while (n3 < n && bl) {
                XSegment xSegment2 = this.borderSegment(n3);
                if (!xSegment.incident(xSegment2)) {
                    bl = bl && xSegment.intersection(xSegment2).empty();
                }
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    public int findBorderIndex(int n, boolean bl) {
        if (n < 0 || n >= this._points.length) {
            return -1;
        }
        if (bl) {
            if (n < this._points.length - 1) {
                return n;
            }
            return -1;
        }
        if (n > 0) {
            return n - 1;
        }
        return -1;
    }

    public int countBorderSegments() {
        return Math.max(this._points.length - 1, 0);
    }

    public Intersection intersection(Object object) {
        if (this.supportsIntersection(object)) {
            if (object instanceof XPoint) {
                if (this.liesOn((XPoint)object) >= 0) {
                    return new Intersection(((XPoint)object).clone());
                }
                return new Intersection();
            }
            if (object instanceof XBaseline) {
                return new Intersection(this.intersection_impl((XBaseline)object));
            }
            if (object instanceof XPolyline) {
                return new Intersection(this.intersection_impl((XPolyline)object));
            }
        } else {
            if (object instanceof Intersectable && ((Intersectable)object).supportsIntersection(this)) {
                return ((Intersectable)object).intersection(this);
            }
            throw new IntersectionException(this, this, object);
        }
        throw new IntersectionException(this, this, object);
    }

    void moveData(XPolyline xPolyline) {
        if (xPolyline == null) {
            return;
        }
        this._points = xPolyline._points;
        xPolyline.clear();
    }

    public boolean empty() {
        return this._points.length == 0;
    }

    public void clear() {
        this._points = new XPoint[0];
    }

    public XObject transform_XObject(double d, double d2, double d3, double d4, double d5, double d6) {
        this.transform(d, d2, d3, d4, d5, d6);
        return this;
    }

    public XPoint point(int n) {
        if (this._points.length <= 0) {
            return null;
        }
        if ((n %= this._points.length) < 0) {
            n += this._points.length;
        }
        return this._points[n];
    }

    public XSegment segment(int n) {
        if (n < 0 || n >= this._points.length - 1) {
            return null;
        }
        return new XSegment(this._points[n], this._points[n + 1]);
    }

    public XSegment borderSegment(int n) {
        if (n < 0 || n >= this._points.length - 1) {
            return null;
        }
        return this.segment(n);
    }

    public XPoint closestPoint(XPoint xPoint) {
        XPoint xPoint2 = null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.countBorderSegments()) {
            XPoint xPoint3 = this.borderSegment(n).closestPoint(xPoint);
            double d2 = xPoint.squareDistance(xPoint3);
            if (d2 < d) {
                d = d2;
                xPoint2 = xPoint3;
            }
            ++n;
        }
        return xPoint2;
    }

    public boolean kinkPoint(int n, byte by) {
        byte by2;
        if (this._points.length <= 0) {
            return false;
        }
        if ((n %= this._points.length) < 0) {
            n += this._points.length;
        }
        return (by2 = XPoint.orientation(this._points[(n + this._points.length - 1) % this._points.length], this._points[n], this._points[(n + 1) % this._points.length])) == by;
    }

    public boolean convex() {
        int n = this.countBorderSegments();
        if (n <= 1) {
            return true;
        }
        byte by = 3;
        boolean bl = true;
        int n2 = 1;
        while (n2 <= n && bl) {
            byte by2 = this.borderSegment(n2 - 1).orientation(this.borderSegment(n2 % n).target());
            if (by == 3) {
                by = by2;
            }
            bl = by2 == 3 || by2 == by;
            ++n2;
        }
        return bl;
    }
}

