/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.x.Intersectable;
import gishur.x.Intersection;
import gishur.x.IntersectionException;
import gishur.x.XBaseline;
import gishur.x.XLine;
import gishur.x.XPoint;
import gishur.x.XSegment;

public class XRay
extends XBaseline
implements Intersectable,
Cloneable {
    private Object intersection_impl(XLine xLine) {
        Object object = super.baseIntersection(xLine);
        if (object == null) {
            return null;
        }
        if (object instanceof XBaseline) {
            return this;
        }
        if (object instanceof XPoint) {
            if (this.liesOn((XPoint)object)) {
                return object;
            }
            return null;
        }
        return null;
    }

    private Object intersection_impl(XRay xRay) {
        Object object = super.baseIntersection(xRay);
        if (object == null) {
            return null;
        }
        if (object instanceof XBaseline) {
            if (xRay.direction() == this.direction()) {
                if (this.liesOn(xRay._source)) {
                    return new XRay(xRay);
                }
                return new XRay(this);
            }
            return new XSegment(this._source, xRay._source);
        }
        if (object instanceof XPoint) {
            XPoint xPoint = (XPoint)object;
            if (!this.inBounds(xPoint.x, xPoint.y)) {
                return null;
            }
            if (!xRay.inBounds(xPoint.x, xPoint.y)) {
                return null;
            }
            return object;
        }
        return null;
    }

    boolean inBounds(double d, double d2) {
        if (this.vertical()) {
            if (d2 <= this._source.y + 1.0E-7 && this._target.y < this._source.y) {
                return true;
            }
            return d2 >= this._source.y - 1.0E-7 && this._target.y > this._source.y;
        }
        if (this._target.x < this._source.x) {
            return d <= this._source.x + 1.0E-7;
        }
        return d >= this._source.x - 1.0E-7;
    }

    public void set(XPoint xPoint, double d, byte by) {
        if (xPoint == null) {
            return;
        }
        if (by != 3 && by != 4 && by != 1 && by != 2) {
            return;
        }
        this._source = new XPoint(xPoint);
        switch (by) {
            case 3: {
                this._target = new XPoint(xPoint.x, xPoint.y + 1.0);
                return;
            }
            case 4: {
                this._target = new XPoint(xPoint.x, xPoint.y - 1.0);
                return;
            }
            case 2: {
                if (Math.abs(d) < 1.0) {
                    this._target = new XPoint(xPoint.x - 1.0, xPoint.y - d);
                    return;
                }
                if (d > 0.0) {
                    this._target = new XPoint(xPoint.x - 1.0 / d, xPoint.y - 1.0);
                    return;
                }
                this._target = new XPoint(xPoint.x + 1.0 / d, xPoint.y + 1.0);
                return;
            }
            case 1: {
                if (Math.abs(d) < 1.0) {
                    this._target = new XPoint(xPoint.x + 1.0, xPoint.y + d);
                    return;
                }
                if (d > 0.0) {
                    this._target = new XPoint(xPoint.x + 1.0 / d, xPoint.y + 1.0);
                    return;
                }
                this._target = new XPoint(xPoint.x - 1.0 / d, xPoint.y - 1.0);
                return;
            }
        }
    }

    public String toString(boolean bl, boolean bl2, boolean bl3) {
        String string = "";
        if (bl) {
            string = string + ",source=" + this._source.toString(true);
        }
        if (bl2) {
            string = string + ",slope=" + this.slope();
        }
        if (bl3) {
            string = this.source().x == this.target().x ? (this.source().y < this.target().y ? string + ",up" : string + ",down") : (this.source().x < this.target().x ? string + ",right" : string + ",left");
        }
        return string.substring(1);
    }

    public XRay() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    public XRay(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public XRay(XPoint xPoint, XPoint xPoint2) {
        this.set(xPoint.x(), xPoint.y(), xPoint2.x(), xPoint2.y());
    }

    public XRay(XPoint xPoint, double d, byte by) {
        this.set(xPoint, d, by);
    }

    public XRay(XRay xRay) {
        this.copy(xRay);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toString(true, true, true) + "]";
    }

    public boolean contains(double d, double d2) {
        if (this.vertical()) {
            if (d == this._source.x && d2 <= this._source.y && this._target.y < this._source.y) {
                return true;
            }
            return d == this._source.x && d2 >= this._source.y && this._target.y > this._source.y;
        }
        XPoint xPoint = this.calculatePoint(d);
        if (xPoint != null) {
            return xPoint.equals(d, d2);
        }
        return false;
    }

    public boolean supportsIntersection(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XPoint) {
            return true;
        }
        if (object instanceof XLine) {
            return true;
        }
        return object instanceof XRay;
    }

    public boolean incident(XBaseline xBaseline) {
        if ((xBaseline instanceof XRay || xBaseline instanceof XSegment) && this._source.equals(xBaseline._source)) {
            return true;
        }
        return xBaseline instanceof XSegment && this._source.equals(xBaseline._target);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XRay) {
            XRay xRay = (XRay)object;
            if (this.vertical() && xRay.vertical()) {
                return this._source.equals(xRay._source) && this.direction() == xRay.direction();
            }
            return this._source.equals(xRay._source) && this.slope() == xRay.slope();
        }
        return false;
    }

    public void copy(XRay xRay) {
        if (xRay == null) {
            return;
        }
        this._source = new XPoint(xRay._source);
        this._target = new XPoint(xRay._target);
    }

    public Intersection intersection(Object object) {
        if (this.supportsIntersection(object)) {
            if (object instanceof XPoint) {
                if (this.liesOn((XPoint)object)) {
                    return new Intersection(((XPoint)object).clone());
                }
                return new Intersection();
            }
            if (object instanceof XLine) {
                return new Intersection(this.intersection_impl((XLine)object));
            }
            if (object instanceof XRay) {
                return new Intersection(this.intersection_impl((XRay)object));
            }
        } else {
            if (object instanceof Intersectable && ((Intersectable)object).supportsIntersection(this)) {
                return ((Intersectable)object).intersection(this);
            }
            throw new IntersectionException(this, this, object);
        }
        throw new IntersectionException(this, this, object);
    }

    public XPoint calculatePointOn(double d) {
        if (d < 0.0) {
            return null;
        }
        return this.getPointInLineDirection(this._source, d);
    }

    public XPoint calculatePoint(double d) {
        if (this.vertical()) {
            if (d == this._source.x) {
                return new XPoint(this._source);
            }
            return null;
        }
        if (d <= this._source.x && this._target.x < this._source.x || d >= this._source.x && this._target.x > this._source.x) {
            return super.calculatePoint(d);
        }
        return null;
    }
}

